/************************************************************************************************/
/* Stata User File for H79 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H79.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H79.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H79.DO                                               */
/* The program below will output the Stata dataset H79.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL03 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID03 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  str    HIEUIDX 30-36
  byte   FCSZ1231 37-38
  byte   FCRP1231 39-40
  str    RULETR31 41-42
  str    RULETR42 43-44
  str    RULETR53 45-46
  str    RULETR03 47-48
  byte   RUSIZE31 49-50
  byte   RUSIZE42 51-52
  byte   RUSIZE53 53-54
  byte   RUSIZE03 55-56
  byte   RUCLAS31 57-58
  byte   RUCLAS42 59-60
  byte   RUCLAS53 61-62
  byte   RUCLAS03 63-63
  byte   FAMSZE31 64-65
  byte   FAMSZE42 66-67
  byte   FAMSZE53 68-69
  byte   FAMSZE03 70-71
  byte   FMRS1231 72-73
  byte   FAMS1231 74-75
  byte   FAMSZEYR 76-77
  byte   FAMRFPYR 78-79
  byte   REGION31 80-81
  byte   REGION42 82-83
  byte   REGION53 84-85
  byte   REGION03 86-87
  byte   MSA31 88-89
  byte   MSA42 90-91
  byte   MSA53 92-93
  byte   MSA03 94-95
  int    REFPRS31 96-98
  int    REFPRS42 99-101
  int    REFPRS53 102-104
  int    REFPRS03 105-107
  byte   RESP31 108-108
  byte   RESP42 109-109
  byte   RESP53 110-110
  byte   RESP03 111-111
  byte   PROXY31 112-113
  byte   PROXY42 114-115
  byte   PROXY53 116-117
  byte   PROXY03 118-118
  byte   INTVLANG 119-120
  byte   BEGRFD31 121-122
  byte   BEGRFM31 123-124
  int    BEGRFY31 125-128
  byte   ENDRFD31 129-130
  byte   ENDRFM31 131-132
  int    ENDRFY31 133-136
  byte   BEGRFD42 137-138
  byte   BEGRFM42 139-140
  int    BEGRFY42 141-144
  byte   ENDRFD42 145-146
  byte   ENDRFM42 147-148
  int    ENDRFY42 149-152
  byte   BEGRFD53 153-154
  byte   BEGRFM53 155-156
  int    BEGRFY53 157-160
  byte   ENDRFD53 161-162
  byte   ENDRFM53 163-164
  int    ENDRFY53 165-168
  byte   ENDRFD03 169-170
  byte   ENDRFM03 171-172
  int    ENDRFY03 173-176
  byte   KEYNESS 177-177
  byte   INSCOP31 178-178
  byte   INSCOP42 179-179
  byte   INSCOP53 180-180
  byte   INSCOP03 181-181
  byte   INSC1231 182-182
  byte   INSCOPE 183-183
  byte   ELGRND31 184-184
  byte   ELGRND42 185-185
  byte   ELGRND53 186-186
  byte   ELGRND03 187-187
  byte   PSTATS31 188-189
  byte   PSTATS42 190-191
  byte   PSTATS53 192-193
  str    RURSLT31 194-195
  str    RURSLT42 196-197
  str    RURSLT53 198-199
  byte   AGE31X 200-201
  byte   AGE42X 202-203
  byte   AGE53X 204-205
  byte   AGE03X 206-207
  byte   DOBMM 208-209
  int    DOBYY 210-213
  byte   SEX 214-214
  byte   RACEX 215-215
  byte   RACEAX 216-216
  byte   RACEBX 217-217
  byte   RACEWX 218-218
  byte   RACETHNX 219-219
  byte   HISPANX 220-220
  byte   HISPCAT 221-222
  byte   MARRY31X 223-224
  byte   MARRY42X 225-226
  byte   MARRY53X 227-228
  byte   MARRY03X 229-230
  int    SPOUID31 231-233
  int    SPOUID42 234-236
  int    SPOUID53 237-239
  int    SPOUID03 240-242
  byte   SPOUIN31 243-244
  byte   SPOUIN42 245-246
  byte   SPOUIN53 247-248
  byte   SPOUIN03 249-250
  byte   EDUCYEAR 251-252
  byte   HIDEGYR 253-254
  byte   FTSTU31X 255-256
  byte   FTSTU42X 257-258
  byte   FTSTU53X 259-260
  byte   FTSTU03X 261-262
  byte   ACTDTY31 263-264
  byte   ACTDTY42 265-266
  byte   ACTDTY53 267-268
  byte   DIDSERVE 269-270
  byte   VETVIET 271-272
  byte   VETKOR 273-274
  byte   VETWW 275-276
  byte   VETGULF 277-278
  byte   VETOTH 279-280
  byte   RFREL31X 281-282
  byte   RFREL42X 283-284
  byte   RFREL53X 285-286
  byte   RFREL03X 287-288
  int    MOPID31X 289-291
  int    MOPID42X 292-294
  int    MOPID53X 295-297
  int    DAPID31X 298-300
  int    DAPID42X 301-303
  int    DAPID53X 304-306
  byte   SSIDIS03 307-308
  byte   AFDC03 309-310
  byte   FILEDR03 311-312
  byte   WILFIL03 313-314
  byte   FLSTAT03 315-316
  byte   FILER03 317-318
  byte   JTINRU03 319-320
  int    JNTPID03 321-323
  byte   CLMDEP03 324-325
  byte   DEPDNT03 326-327
  byte   DPINRU03 328-329
  byte   DPOTSD03 330-331
  byte   TAXFRM03 332-333
  byte   DEDUCT03 334-335
  double TOTDED03 336-344
  byte   CLMHIP03 345-346
  byte   EICRDT03 347-348
  byte   FOODST03 349-350
  byte   FOODMN03 351-352
  double FOODCT03 353-358
  double FOODVL03 359-365
  long   TTLP03X 366-372
  byte   POVCAT03 373-373
  long   WAGEP03X 374-379
  byte   WAGIMP03 380-380
  long   BUSNP03X 381-387
  byte   BUSIMP03 388-388
  long   UNEMP03X 389-393
  byte   UNEIMP03 394-394
  long   WCMPP03X 395-399
  byte   WCPIMP03 400-400
  long   INTRP03X 401-405
  byte   INTIMP03 406-406
  long   DIVDP03X 407-411
  byte   DIVIMP03 412-412
  long   SALEP03X 413-418
  byte   SALIMP03 419-419
  long   PENSP03X 420-425
  byte   PENIMP03 426-426
  long   SSECP03X 427-431
  byte   SSCIMP03 432-432
  long   TRSTP03X 433-438
  byte   TRTIMP03 439-439
  long   VETSP03X 440-444
  byte   VETIMP03 445-445
  long   IRASP03X 446-450
  byte   IRAIMP03 451-451
  long   REFDP03X 452-456
  byte   REFIMP03 457-457
  long   ALIMP03X 458-462
  byte   ALIIMP03 463-463
  long   CHLDP03X 464-468
  byte   CHLIMP03 469-469
  long   CASHP03X 470-474
  byte   CSHIMP03 475-475
  long   SSIP03X 476-480
  byte   SSIIMP03 481-481
  long   PUBP03X 482-486
  byte   PUBIMP03 487-487
  long   OTHRP03X 488-492
  byte   OTHIMP03 493-493
  byte   RTHLTH31 494-495
  byte   RTHLTH42 496-497
  byte   RTHLTH53 498-499
  byte   MNHLTH31 500-501
  byte   MNHLTH42 502-503
  byte   MNHLTH53 504-505
  byte   IADLHP31 506-507
  byte   IADLHP42 508-509
  byte   IADLHP53 510-511
  byte   IADL3M31 512-513
  byte   IADL3M42 514-515
  byte   IADL3M53 516-517
  byte   ADLHLP31 518-519
  byte   ADLHLP42 520-521
  byte   ADLHLP53 522-523
  byte   ADL3MO31 524-525
  byte   ADL3MO42 526-527
  byte   ADL3MO53 528-529
  byte   AIDHLP31 530-531
  byte   AIDHLP53 532-533
  byte   WLKLIM31 534-535
  byte   WLKLIM53 536-537
  byte   LFTDIF31 538-539
  byte   LFTDIF53 540-541
  byte   STPDIF31 542-543
  byte   STPDIF53 544-545
  byte   WLKDIF31 546-547
  byte   WLKDIF53 548-549
  byte   MILDIF31 550-551
  byte   MILDIF53 552-553
  byte   STNDIF31 554-555
  byte   STNDIF53 556-557
  byte   BENDIF31 558-559
  byte   BENDIF53 560-561
  byte   RCHDIF31 562-563
  byte   RCHDIF53 564-565
  byte   FNGRDF31 566-567
  byte   FNGRDF53 568-569
  byte   WLK3MO31 570-571
  byte   WLK3MO53 572-573
  byte   ACTLIM31 574-575
  byte   ACTLIM53 576-577
  byte   WRKLIM31 578-579
  byte   WRKLIM53 580-581
  byte   HSELIM31 582-583
  byte   HSELIM53 584-585
  byte   SCHLIM31 586-587
  byte   SCHLIM53 588-589
  byte   UNABLE31 590-591
  byte   UNABLE53 592-593
  byte   SOCLIM31 594-595
  byte   SOCLIM53 596-597
  byte   COGLIM31 598-599
  byte   COGLIM53 600-601
  byte   WRGLAS42 602-603
  byte   SEEDIF42 604-605
  byte   BLIND42 606-607
  byte   READNW42 608-609
  byte   RECPEP42 610-611
  byte   VISION42 612-613
  byte   HEARAD42 614-615
  byte   HEARDI42 616-617
  byte   DEAF42 618-619
  byte   HEARMO42 620-621
  byte   HEARSM42 622-623
  byte   HEARNG42 624-625
  byte   ANYLIM03 626-627
  byte   LSHLTH42 628-629
  byte   NEVILL42 630-631
  byte   SICEAS42 632-633
  byte   HLTHLF42 634-635
  byte   WRHLTH42 636-637
  byte   CHPMED42 638-639
  byte   CHPMHB42 640-641
  byte   CHPMCN42 642-643
  byte   CHSERV42 644-645
  byte   CHSRHB42 646-647
  byte   CHSRCN42 648-649
  byte   CHLIMI42 650-651
  byte   CHLIHB42 652-653
  byte   CHLICO42 654-655
  byte   CHTHER42 656-657
  byte   CHTHHB42 658-659
  byte   CHTHCO42 660-661
  byte   CHCOUN42 662-663
  byte   CHEMPB42 664-665
  byte   CSHCN42 666-667
  byte   MOMPRO42 668-669
  byte   DADPRO42 670-671
  byte   UNHAP42 672-673
  byte   SCHLBH42 674-675
  byte   HAVFUN42 676-677
  byte   ADUPRO42 678-679
  byte   NERVAF42 680-681
  byte   SIBPRO42 682-683
  byte   KIDPRO42 684-685
  byte   SPRPRO42 686-687
  byte   SCHPRO42 688-689
  byte   HOMEBH42 690-691
  byte   TRBLE42 692-693
  byte   CHILCR42 694-695
  byte   CHILWW42 696-697
  byte   CHRTCR42 698-699
  byte   CHRTWW42 700-701
  byte   CHAPPT42 702-703
  byte   CHNDCR42 704-705
  byte   CHNECP42 706-707
  byte   CHLIST42 708-709
  byte   CHEXPL42 710-711
  byte   CHRESP42 712-713
  byte   CHPRTM42 714-715
  byte   CHHECR42 716-717
  byte   CHSPEC42 718-719
  byte   CHPRRE42 720-721
  byte   MESHGT42 722-723
  byte   WHNHGT42 724-725
  byte   MESWGT42 726-727
  byte   WHNWGT42 728-729
  double CHBMIX42 730-734
  byte   MESVIS42 735-736
  byte   MESBPR42 737-738
  byte   WHNBPR42 739-740
  byte   DENTAL42 741-742
  byte   WHNDEN42 743-744
  byte   EATHLT42 745-746
  byte   WHNEAT42 747-748
  byte   PHYSCL42 749-750
  byte   WHNPHY42 751-752
  byte   SAFEST42 753-754
  byte   WHNSAF42 755-756
  byte   BOOST42 757-758
  byte   WHNBST42 759-760
  byte   LAPBLT42 761-762
  byte   WHNLAP42 763-764
  byte   HELMET42 765-766
  byte   WHNHEL42 767-768
  byte   NOSMOK42 769-770
  byte   WHNSMK42 771-772
  byte   TIMALN42 773-774
  byte   DENTCK53 775-776
  byte   CHOLCK53 777-778
  byte   CHECK53 779-780
  byte   FLUSHT53 781-782
  byte   LSTETH53 783-784
  byte   PSA53 785-786
  byte   HYSTER53 787-788
  byte   PAPSMR53 789-790
  byte   BRSTEX53 791-792
  byte   MAMOGR53 793-794
  byte   STOOL53 795-796
  byte   WHENST53 797-798
  byte   BOWEL53 799-800
  byte   WHNBWL53 801-802
  byte   PHYACT53 803-804
  double BMINDX53 805-809
  byte   SEATBE53 810-811
  byte   SRTHRT53 812-813
  byte   THSYMP53 814-815
  byte   DRTHRT53 816-817
  byte   THANTB53 818-819
  byte   THSWAB53 820-821
  byte   THSYMF53 822-823
  byte   THSWBF53 824-825
  byte   THANTF53 826-827
  byte   DIABDX53 828-829
  byte   ASTHDX53 830-831
  byte   ASSTIL53 832-833
  byte   ASATAK53 834-835
  byte   ASACUT53 836-837
  byte   ASMRCN53 838-839
  byte   ASPREV53 840-841
  byte   ASDALY53 842-843
  byte   ASPKFL53 844-845
  byte   ASEVFL53 846-847
  byte   ASWNFL53 848-849
  byte   HIBPDX53 850-851
  byte   BPMLDX53 852-853
  byte   BPCHEK53 854-855
  byte   BPMONT53 856-857
  byte   CHDDX53 858-859
  byte   ANGIDX53 860-861
  byte   MIDX53 862-863
  byte   OHRTDX53 864-865
  byte   STRKDX53 866-867
  byte   EMPHDX53 868-869
  byte   NOFAT53 870-871
  byte   EXRCIS53 872-873
  byte   ASPRIN53 874-875
  byte   NOASPR53 876-877
  byte   STOMCH53 878-879
  byte   JTPAIN53 880-881
  byte   ARTHDX53 882-883
  byte   ARTHTX53 884-885
  byte   SAQELIG 886-886
  int    ADPRX42 887-889
  byte   ADILCR42 890-891
  byte   ADILWW42 892-893
  byte   ADRTCR42 894-895
  byte   ADRTWW42 896-897
  byte   ADAPPT42 898-899
  byte   ADNDCR42 900-901
  byte   ADNECP42 902-903
  byte   ADLIST42 904-905
  byte   ADEXPL42 906-907
  byte   ADRESP42 908-909
  byte   ADPRTM42 910-911
  byte   ADHECR42 912-913
  byte   ADSMOK42 914-915
  byte   ADNSMK42 916-917
  byte   ADDRBP42 918-919
  byte   ADSPEC42 920-921
  byte   ADPRRE42 922-923
  byte   ADGENH42 924-925
  byte   ADDAYA42 926-927
  byte   ADCLIM42 928-929
  byte   ADPALS42 930-931
  byte   ADPWLM42 932-933
  byte   ADMALS42 934-935
  byte   ADMWLM42 936-937
  byte   ADPAIN42 938-939
  byte   ADCAPE42 940-941
  byte   ADNRGY42 942-943
  byte   ADDOWN42 944-945
  byte   ADSOCA42 946-947
  double PCS42 948-952
  double MCS42 953-957
  byte   SFFLAG42 958-959
  byte   ADMOBI42 960-961
  byte   ADSELF42 962-963
  byte   ADACTI42 964-965
  byte   ADPAYN42 966-967
  byte   ADDEPR42 968-969
  int    ADSCAL42 970-972
  double EQU42 973-977
  byte   ADINSA42 978-979
  byte   ADINSB42 980-981
  byte   ADRISK42 982-983
  byte   ADOVER42 984-985
  byte   ADCMPM42 986-987
  byte   ADCMPD42 988-989
  int    ADCMPY42 990-993
  byte   ADLANG42 994-995
  byte   DSDIA53 996-997
  byte   DSA1C53 998-999
  byte   DSCKFT53 1000-1001
  byte   DSEY0453 1002-1003
  byte   DSEY0353 1004-1005
  byte   DSEY0253 1006-1007
  byte   DSEB0253 1008-1009
  byte   DSEYNV53 1010-1011
  byte   DSKIDN53 1012-1013
  byte   DSEYPR53 1014-1015
  byte   DSDIET53 1016-1017
  byte   DSMED53 1018-1019
  byte   DSINSU53 1020-1021
  byte   DSPRX53 1022-1023
  int    DDNWRK31 1024-1026
  int    DDNWRK42 1027-1029
  int    DDNWRK53 1030-1032
  int    WKINBD31 1033-1035
  int    WKINBD42 1036-1038
  int    WKINBD53 1039-1041
  byte   DDNSCL31 1042-1043
  int    DDNSCL42 1044-1046
  int    DDNSCL53 1047-1049
  byte   SCLNBD31 1050-1051
  byte   SCLNBD42 1052-1053
  byte   SCLNBD53 1054-1055
  int    DDBDYS31 1056-1058
  int    DDBDYS42 1059-1061
  int    DDBDYS53 1062-1064
  byte   OTHDYS31 1065-1066
  byte   OTHDYS42 1067-1068
  byte   OTHDYS53 1069-1070
  byte   OTHNDD31 1071-1072
  byte   OTHNDD42 1073-1074
  int    OTHNDD53 1075-1077
  byte   ACCELI42 1078-1079
  byte   LANGHM42 1080-1081
  byte   ENGHME42 1082-1083
  byte   ENGSPK42 1084-1085
  byte   USBORN42 1086-1087
  byte   USLGLV42 1088-1089
  byte   HAVEUS42 1090-1091
  byte   YNOUSC42 1092-1093
  byte   NOREAS42 1094-1095
  byte   SELDSI42 1096-1097
  byte   NEWARE42 1098-1099
  byte   DKWHRU42 1100-1101
  byte   USCNOT42 1102-1103
  byte   PERSLA42 1104-1105
  byte   DIFFPL42 1106-1107
  byte   INSRPL42 1108-1109
  byte   MYSELF42 1110-1111
  byte   CARECO42 1112-1113
  byte   OTHINS42 1114-1115
  byte   JOBRSN42 1116-1117
  byte   NEWDOC42 1118-1119
  byte   DOCELS42 1120-1121
  byte   NOLIKE42 1122-1123
  byte   KNOWDR42 1124-1125
  byte   NOGODR42 1126-1127
  byte   TRANS42 1128-1129
  byte   OTHREA42 1130-1131
  byte   PROVTY42 1132-1133
  byte   FACLPR42 1134-1135
  byte   PLCTYP42 1136-1137
  byte   GOTOUS42 1138-1139
  byte   TMTKUS42 1140-1141
  byte   DFTOUS42 1142-1143
  byte   TYPEPE42 1144-1145
  byte   LOCATN42 1146-1147
  byte   HSPLAP42 1148-1149
  byte   WHITPR42 1150-1151
  byte   BLCKPR42 1152-1153
  byte   ASIANP42 1154-1155
  byte   NATAMP42 1156-1157
  byte   PACISP42 1158-1159
  byte   OTHRCP42 1160-1161
  byte   GENDRP42 1162-1163
  byte   MINORP42 1164-1165
  byte   PREVEN42 1166-1167
  byte   REFFRL42 1168-1169
  byte   ONGONG42 1170-1171
  byte   PHNREG42 1172-1173
  byte   OFFHOU42 1174-1175
  byte   AFTHOU42 1176-1177
  byte   TREATM42 1178-1179
  byte   RESPCT42 1180-1181
  byte   DECIDE42 1182-1183
  byte   EXPLOP42 1184-1185
  byte   LANGPR42 1186-1187
  byte   MDUNAB42 1188-1189
  byte   MDUNRS42 1190-1191
  byte   MDUNPR42 1192-1193
  byte   MDDLAY42 1194-1195
  byte   MDDLRS42 1196-1197
  byte   MDDLPR42 1198-1199
  byte   DNUNAB42 1200-1201
  byte   DNUNRS42 1202-1203
  byte   DNUNPR42 1204-1205
  byte   DNDLAY42 1206-1207
  byte   DNDLRS42 1208-1209
  byte   DNDLPR42 1210-1211
  byte   PMUNAB42 1212-1213
  byte   PMUNRS42 1214-1215
  byte   PMUNPR42 1216-1217
  byte   PMDLAY42 1218-1219
  byte   PMDLRS42 1220-1221
  byte   PMDLPR42 1222-1223
  byte   EMPST31 1224-1225
  byte   EMPST42 1226-1227
  byte   EMPST53 1228-1229
  byte   RNDFLG31 1230-1231
  byte   MORJOB31 1232-1233
  byte   MORJOB42 1234-1235
  byte   MORJOB53 1236-1237
  byte   EVRWRK 1238-1239
  double HRWG31X 1240-1245
  double HRWG42X 1246-1251
  double HRWG53X 1252-1257
  byte   HRWGIM31 1258-1258
  byte   HRWGIM42 1259-1259
  byte   HRWGIM53 1260-1260
  byte   HRHOW31 1261-1262
  byte   HRHOW42 1263-1264
  byte   HRHOW53 1265-1266
  byte   DIFFWG31 1267-1268
  byte   DIFFWG42 1269-1270
  byte   DIFFWG53 1271-1272
  int    HOUR31 1273-1275
  int    HOUR42 1276-1278
  int    HOUR53 1279-1281
  byte   TEMPJB31 1282-1283
  byte   TEMPJB42 1284-1285
  byte   TEMPJB53 1286-1287
  byte   SSNLJB31 1288-1289
  byte   SSNLJB42 1290-1291
  byte   SSNLJB53 1292-1293
  byte   SELFCM31 1294-1295
  byte   SELFCM42 1296-1297
  byte   SELFCM53 1298-1299
  byte   DISVW31X 1300-1301
  byte   DISVW42X 1302-1303
  byte   DISVW53X 1304-1305
  byte   CHOIC31 1306-1307
  byte   CHOIC42 1308-1309
  byte   CHOIC53 1310-1311
  byte   INDCAT31 1312-1313
  byte   INDCAT42 1314-1315
  byte   INDCAT53 1316-1317
  int    NUMEMP31 1318-1320
  int    NUMEMP42 1321-1323
  int    NUMEMP53 1324-1326
  byte   MORE31 1327-1328
  byte   MORE42 1329-1330
  byte   MORE53 1331-1332
  byte   UNION31 1333-1334
  byte   UNION42 1335-1336
  byte   UNION53 1337-1338
  byte   NWK31 1339-1340
  byte   NWK42 1341-1342
  byte   NWK53 1343-1344
  byte   CHGJ3142 1345-1346
  byte   CHGJ4253 1347-1348
  byte   YCHJ3142 1349-1350
  byte   YCHJ4253 1351-1352
  byte   STJBMM31 1353-1354
  byte   STJBDD31 1355-1356
  int    STJBYY31 1357-1360
  byte   STJBMM42 1361-1362
  byte   STJBDD42 1363-1364
  int    STJBYY42 1365-1368
  byte   STJBMM53 1369-1370
  byte   STJBDD53 1371-1372
  int    STJBYY53 1373-1376
  byte   EVRETIRE 1377-1378
  byte   OCCCAT31 1379-1380
  byte   OCCCAT42 1381-1382
  byte   OCCCAT53 1383-1384
  byte   PAYVAC31 1385-1386
  byte   PAYVAC42 1387-1388
  byte   PAYVAC53 1389-1390
  byte   SICPAY31 1391-1392
  byte   SICPAY42 1393-1394
  byte   SICPAY53 1395-1396
  byte   PAYDR31 1397-1398
  byte   PAYDR42 1399-1400
  byte   PAYDR53 1401-1402
  byte   RETPLN31 1403-1404
  byte   RETPLN42 1405-1406
  byte   RETPLN53 1407-1408
  byte   BSNTY31 1409-1410
  byte   BSNTY42 1411-1412
  byte   BSNTY53 1413-1414
  byte   JOBORG31 1415-1416
  byte   JOBORG42 1417-1418
  byte   JOBORG53 1419-1420
  byte   HELD31X 1421-1422
  byte   HELD42X 1423-1424
  byte   HELD53X 1425-1426
  byte   OFFER31X 1427-1428
  byte   OFFER42X 1429-1430
  byte   OFFER53X 1431-1432
  byte   OFREMP31 1433-1434
  byte   OFREMP42 1435-1436
  byte   OFREMP53 1437-1438
  byte   YNOINS31 1439-1440
  byte   YNOINS42 1441-1442
  byte   YNOINS53 1443-1444
  byte   TRIJA03X 1445-1446
  byte   TRIFE03X 1447-1448
  byte   TRIMA03X 1449-1450
  byte   TRIAP03X 1451-1452
  byte   TRIMY03X 1453-1454
  byte   TRIJU03X 1455-1456
  byte   TRIJL03X 1457-1458
  byte   TRIAU03X 1459-1460
  byte   TRISE03X 1461-1462
  byte   TRIOC03X 1463-1464
  byte   TRINO03X 1465-1466
  byte   TRIDE03X 1467-1468
  byte   MCRJA03 1469-1470
  byte   MCRFE03 1471-1472
  byte   MCRMA03 1473-1474
  byte   MCRAP03 1475-1476
  byte   MCRMY03 1477-1478
  byte   MCRJU03 1479-1480
  byte   MCRJL03 1481-1482
  byte   MCRAU03 1483-1484
  byte   MCRSE03 1485-1486
  byte   MCROC03 1487-1488
  byte   MCRNO03 1489-1490
  byte   MCRDE03 1491-1492
  byte   MCRJA03X 1493-1494
  byte   MCRFE03X 1495-1496
  byte   MCRMA03X 1497-1498
  byte   MCRAP03X 1499-1500
  byte   MCRMY03X 1501-1502
  byte   MCRJU03X 1503-1504
  byte   MCRJL03X 1505-1506
  byte   MCRAU03X 1507-1508
  byte   MCRSE03X 1509-1510
  byte   MCROC03X 1511-1512
  byte   MCRNO03X 1513-1514
  byte   MCRDE03X 1515-1516
  byte   MCDJA03 1517-1518
  byte   MCDFE03 1519-1520
  byte   MCDMA03 1521-1522
  byte   MCDAP03 1523-1524
  byte   MCDMY03 1525-1526
  byte   MCDJU03 1527-1528
  byte   MCDJL03 1529-1530
  byte   MCDAU03 1531-1532
  byte   MCDSE03 1533-1534
  byte   MCDOC03 1535-1536
  byte   MCDNO03 1537-1538
  byte   MCDDE03 1539-1540
  byte   MCDJA03X 1541-1542
  byte   MCDFE03X 1543-1544
  byte   MCDMA03X 1545-1546
  byte   MCDAP03X 1547-1548
  byte   MCDMY03X 1549-1550
  byte   MCDJU03X 1551-1552
  byte   MCDJL03X 1553-1554
  byte   MCDAU03X 1555-1556
  byte   MCDSE03X 1557-1558
  byte   MCDOC03X 1559-1560
  byte   MCDNO03X 1561-1562
  byte   MCDDE03X 1563-1564
  byte   OPAJA03 1565-1566
  byte   OPAFE03 1567-1568
  byte   OPAMA03 1569-1570
  byte   OPAAP03 1571-1572
  byte   OPAMY03 1573-1574
  byte   OPAJU03 1575-1576
  byte   OPAJL03 1577-1578
  byte   OPAAU03 1579-1580
  byte   OPASE03 1581-1582
  byte   OPAOC03 1583-1584
  byte   OPANO03 1585-1586
  byte   OPADE03 1587-1588
  byte   OPBJA03 1589-1590
  byte   OPBFE03 1591-1592
  byte   OPBMA03 1593-1594
  byte   OPBAP03 1595-1596
  byte   OPBMY03 1597-1598
  byte   OPBJU03 1599-1600
  byte   OPBJL03 1601-1602
  byte   OPBAU03 1603-1604
  byte   OPBSE03 1605-1606
  byte   OPBOC03 1607-1608
  byte   OPBNO03 1609-1610
  byte   OPBDE03 1611-1612
  byte   STAJA03 1613-1614
  byte   STAFE03 1615-1616
  byte   STAMA03 1617-1618
  byte   STAAP03 1619-1620
  byte   STAMY03 1621-1622
  byte   STAJU03 1623-1624
  byte   STAJL03 1625-1626
  byte   STAAU03 1627-1628
  byte   STASE03 1629-1630
  byte   STAOC03 1631-1632
  byte   STANO03 1633-1634
  byte   STADE03 1635-1636
  byte   PUBJA03X 1637-1638
  byte   PUBFE03X 1639-1640
  byte   PUBMA03X 1641-1642
  byte   PUBAP03X 1643-1644
  byte   PUBMY03X 1645-1646
  byte   PUBJU03X 1647-1648
  byte   PUBJL03X 1649-1650
  byte   PUBAU03X 1651-1652
  byte   PUBSE03X 1653-1654
  byte   PUBOC03X 1655-1656
  byte   PUBNO03X 1657-1658
  byte   PUBDE03X 1659-1660
  byte   PEGJA03 1661-1662
  byte   PEGFE03 1663-1664
  byte   PEGMA03 1665-1666
  byte   PEGAP03 1667-1668
  byte   PEGMY03 1669-1670
  byte   PEGJU03 1671-1672
  byte   PEGJL03 1673-1674
  byte   PEGAU03 1675-1676
  byte   PEGSE03 1677-1678
  byte   PEGOC03 1679-1680
  byte   PEGNO03 1681-1682
  byte   PEGDE03 1683-1684
  byte   PDKJA03 1685-1686
  byte   PDKFE03 1687-1688
  byte   PDKMA03 1689-1690
  byte   PDKAP03 1691-1692
  byte   PDKMY03 1693-1694
  byte   PDKJU03 1695-1696
  byte   PDKJL03 1697-1698
  byte   PDKAU03 1699-1700
  byte   PDKSE03 1701-1702
  byte   PDKOC03 1703-1704
  byte   PDKNO03 1705-1706
  byte   PDKDE03 1707-1708
  byte   PNGJA03 1709-1710
  byte   PNGFE03 1711-1712
  byte   PNGMA03 1713-1714
  byte   PNGAP03 1715-1716
  byte   PNGMY03 1717-1718
  byte   PNGJU03 1719-1720
  byte   PNGJL03 1721-1722
  byte   PNGAU03 1723-1724
  byte   PNGSE03 1725-1726
  byte   PNGOC03 1727-1728
  byte   PNGNO03 1729-1730
  byte   PNGDE03 1731-1732
  byte   POGJA03 1733-1734
  byte   POGFE03 1735-1736
  byte   POGMA03 1737-1738
  byte   POGAP03 1739-1740
  byte   POGMY03 1741-1742
  byte   POGJU03 1743-1744
  byte   POGJL03 1745-1746
  byte   POGAU03 1747-1748
  byte   POGSE03 1749-1750
  byte   POGOC03 1751-1752
  byte   POGNO03 1753-1754
  byte   POGDE03 1755-1756
  byte   PRSJA03 1757-1758
  byte   PRSFE03 1759-1760
  byte   PRSMA03 1761-1762
  byte   PRSAP03 1763-1764
  byte   PRSMY03 1765-1766
  byte   PRSJU03 1767-1768
  byte   PRSJL03 1769-1770
  byte   PRSAU03 1771-1772
  byte   PRSSE03 1773-1774
  byte   PRSOC03 1775-1776
  byte   PRSNO03 1777-1778
  byte   PRSDE03 1779-1780
  byte   POUJA03 1781-1782
  byte   POUFE03 1783-1784
  byte   POUMA03 1785-1786
  byte   POUAP03 1787-1788
  byte   POUMY03 1789-1790
  byte   POUJU03 1791-1792
  byte   POUJL03 1793-1794
  byte   POUAU03 1795-1796
  byte   POUSE03 1797-1798
  byte   POUOC03 1799-1800
  byte   POUNO03 1801-1802
  byte   POUDE03 1803-1804
  byte   PRIJA03 1805-1806
  byte   PRIFE03 1807-1808
  byte   PRIMA03 1809-1810
  byte   PRIAP03 1811-1812
  byte   PRIMY03 1813-1814
  byte   PRIJU03 1815-1816
  byte   PRIJL03 1817-1818
  byte   PRIAU03 1819-1820
  byte   PRISE03 1821-1822
  byte   PRIOC03 1823-1824
  byte   PRINO03 1825-1826
  byte   PRIDE03 1827-1828
  byte   HPEJA03 1829-1830
  byte   HPEFE03 1831-1832
  byte   HPEMA03 1833-1834
  byte   HPEAP03 1835-1836
  byte   HPEMY03 1837-1838
  byte   HPEJU03 1839-1840
  byte   HPEJL03 1841-1842
  byte   HPEAU03 1843-1844
  byte   HPESE03 1845-1846
  byte   HPEOC03 1847-1848
  byte   HPENO03 1849-1850
  byte   HPEDE03 1851-1852
  byte   HPDJA03 1853-1854
  byte   HPDFE03 1855-1856
  byte   HPDMA03 1857-1858
  byte   HPDAP03 1859-1860
  byte   HPDMY03 1861-1862
  byte   HPDJU03 1863-1864
  byte   HPDJL03 1865-1866
  byte   HPDAU03 1867-1868
  byte   HPDSE03 1869-1870
  byte   HPDOC03 1871-1872
  byte   HPDNO03 1873-1874
  byte   HPDDE03 1875-1876
  byte   HPNJA03 1877-1878
  byte   HPNFE03 1879-1880
  byte   HPNMA03 1881-1882
  byte   HPNAP03 1883-1884
  byte   HPNMY03 1885-1886
  byte   HPNJU03 1887-1888
  byte   HPNJL03 1889-1890
  byte   HPNAU03 1891-1892
  byte   HPNSE03 1893-1894
  byte   HPNOC03 1895-1896
  byte   HPNNO03 1897-1898
  byte   HPNDE03 1899-1900
  byte   HPOJA03 1901-1902
  byte   HPOFE03 1903-1904
  byte   HPOMA03 1905-1906
  byte   HPOAP03 1907-1908
  byte   HPOMY03 1909-1910
  byte   HPOJU03 1911-1912
  byte   HPOJL03 1913-1914
  byte   HPOAU03 1915-1916
  byte   HPOSE03 1917-1918
  byte   HPOOC03 1919-1920
  byte   HPONO03 1921-1922
  byte   HPODE03 1923-1924
  byte   HPSJA03 1925-1926
  byte   HPSFE03 1927-1928
  byte   HPSMA03 1929-1930
  byte   HPSAP03 1931-1932
  byte   HPSMY03 1933-1934
  byte   HPSJU03 1935-1936
  byte   HPSJL03 1937-1938
  byte   HPSAU03 1939-1940
  byte   HPSSE03 1941-1942
  byte   HPSOC03 1943-1944
  byte   HPSNO03 1945-1946
  byte   HPSDE03 1947-1948
  byte   HPRJA03 1949-1950
  byte   HPRFE03 1951-1952
  byte   HPRMA03 1953-1954
  byte   HPRAP03 1955-1956
  byte   HPRMY03 1957-1958
  byte   HPRJU03 1959-1960
  byte   HPRJL03 1961-1962
  byte   HPRAU03 1963-1964
  byte   HPRSE03 1965-1966
  byte   HPROC03 1967-1968
  byte   HPRNO03 1969-1970
  byte   HPRDE03 1971-1972
  byte   INSJA03X 1973-1974
  byte   INSFE03X 1975-1976
  byte   INSMA03X 1977-1978
  byte   INSAP03X 1979-1980
  byte   INSMY03X 1981-1982
  byte   INSJU03X 1983-1984
  byte   INSJL03X 1985-1986
  byte   INSAU03X 1987-1988
  byte   INSSE03X 1989-1990
  byte   INSOC03X 1991-1992
  byte   INSNO03X 1993-1994
  byte   INSDE03X 1995-1996
  byte   PRVEV03 1997-1997
  byte   TRIEV03 1998-1998
  byte   MCREV03 1999-1999
  byte   MCDEV03 2000-2000
  byte   OPAEV03 2001-2001
  byte   OPBEV03 2002-2002
  byte   UNINS03 2003-2003
  byte   INSCOV03 2004-2004
  byte   TRIST31X 2005-2006
  byte   TRIST42X 2007-2008
  byte   TRIST03X 2009-2010
  byte   TRIPR31X 2011-2012
  byte   TRIPR42X 2013-2014
  byte   TRIPR03X 2015-2016
  byte   TRIEX31X 2017-2018
  byte   TRIEX42X 2019-2020
  byte   TRIEX03X 2021-2022
  byte   TRILI42X 2023-2024
  byte   TRILI03X 2025-2026
  byte   MCDHMO31 2027-2028
  byte   MCDHMO42 2029-2030
  byte   MCDHMO03 2031-2032
  byte   MCDMC31 2033-2034
  byte   MCDMC42 2035-2036
  byte   MCDMC03 2037-2038
  byte   PRVHMO31 2039-2040
  byte   PRVHMO42 2041-2042
  byte   PRVHMO03 2043-2044
  byte   PRVMNC31 2045-2046
  byte   PRVMNC42 2047-2048
  byte   PRVMNC03 2049-2050
  byte   PRVDRL31 2051-2052
  byte   PRVDRL42 2053-2054
  byte   PRVDRL03 2055-2056
  byte   PHMONP31 2057-2058
  byte   PHMONP42 2059-2060
  byte   PHMONP03 2061-2062
  byte   PMNCNP31 2063-2064
  byte   PMNCNP42 2065-2066
  byte   PMNCNP03 2067-2068
  byte   PRDRNP31 2069-2070
  byte   PRDRNP42 2071-2072
  byte   PRDRNP03 2073-2074
  byte   PREVCOVR 2075-2076
  byte   COVRMM 2077-2078
  int    COVRYY 2079-2082
  byte   WASESTB 2083-2084
  byte   WASMCARE 2085-2086
  byte   WASMCAID 2087-2088
  byte   WASCHAMP 2089-2090
  byte   WASVA 2091-2092
  byte   WASPRIV 2093-2094
  byte   WASOTGOV 2095-2096
  byte   WASAFDC 2097-2098
  byte   WASSSI 2099-2100
  byte   WASSTAT1 2101-2102
  byte   WASSTAT2 2103-2104
  byte   WASSTAT3 2105-2106
  byte   WASSTAT4 2107-2108
  byte   WASOTHER 2109-2110
  byte   NOINSBEF 2111-2112
  byte   NOINSTM 2113-2114
  byte   NOINUNIT 2115-2116
  byte   MORECOVR 2117-2118
  byte   INSENDMM 2119-2120
  int    INSENDYY 2121-2124
  byte   TRICR31X 2125-2126
  byte   TRICR42X 2127-2128
  byte   TRICR53X 2129-2130
  byte   TRICR03X 2131-2132
  byte   TRIAT31X 2133-2134
  byte   TRIAT42X 2135-2136
  byte   TRIAT53X 2137-2138
  byte   TRIAT03X 2139-2140
  byte   MCAID31 2141-2142
  byte   MCAID42 2143-2144
  byte   MCAID53 2145-2146
  byte   MCAID03 2147-2148
  byte   MCAID31X 2149-2150
  byte   MCAID42X 2151-2152
  byte   MCAID53X 2153-2154
  byte   MCAID03X 2155-2156
  byte   MCARE31 2157-2158
  byte   MCARE42 2159-2160
  byte   MCARE53 2161-2162
  byte   MCARE03 2163-2164
  byte   MCARE31X 2165-2166
  byte   MCARE42X 2167-2168
  byte   MCARE53X 2169-2170
  byte   MCARE03X 2171-2172
  byte   MCDAT31X 2173-2174
  byte   MCDAT42X 2175-2176
  byte   MCDAT53X 2177-2178
  byte   MCDAT03X 2179-2180
  byte   OTPAAT31 2181-2182
  byte   OTPAAT42 2183-2184
  byte   OTPAAT53 2185-2186
  byte   OTPAAT03 2187-2188
  byte   OTPBAT31 2189-2190
  byte   OTPBAT42 2191-2192
  byte   OTPBAT53 2193-2194
  byte   OTPBAT03 2195-2196
  byte   OTPUBA31 2197-2198
  byte   OTPUBA42 2199-2200
  byte   OTPUBA53 2201-2202
  byte   OTPUBA03 2203-2204
  byte   OTPUBB31 2205-2206
  byte   OTPUBB42 2207-2208
  byte   OTPUBB53 2209-2210
  byte   OTPUBB03 2211-2212
  byte   PRIDK31 2213-2214
  byte   PRIDK42 2215-2216
  byte   PRIDK53 2217-2218
  byte   PRIDK03 2219-2220
  byte   PRIEU31 2221-2222
  byte   PRIEU42 2223-2224
  byte   PRIEU53 2225-2226
  byte   PRIEU03 2227-2228
  byte   PRING31 2229-2230
  byte   PRING42 2231-2232
  byte   PRING53 2233-2234
  byte   PRING03 2235-2236
  byte   PRIOG31 2237-2238
  byte   PRIOG42 2239-2240
  byte   PRIOG53 2241-2242
  byte   PRIOG03 2243-2244
  byte   PRIS31 2245-2246
  byte   PRIS42 2247-2248
  byte   PRIS53 2249-2250
  byte   PRIS03 2251-2252
  byte   PRIV31 2253-2254
  byte   PRIV42 2255-2256
  byte   PRIV53 2257-2258
  byte   PRIV03 2259-2260
  byte   PRIVAT31 2261-2262
  byte   PRIVAT42 2263-2264
  byte   PRIVAT53 2265-2266
  byte   PRIVAT03 2267-2268
  byte   PROUT31 2269-2270
  byte   PROUT42 2271-2272
  byte   PROUT53 2273-2274
  byte   PROUT03 2275-2276
  byte   PUB31X 2277-2278
  byte   PUB42X 2279-2280
  byte   PUB53X 2281-2282
  byte   PUB03X 2283-2284
  byte   PUBAT31X 2285-2286
  byte   PUBAT42X 2287-2288
  byte   PUBAT53X 2289-2290
  byte   PUBAT03X 2291-2292
  byte   INS31X 2293-2294
  byte   INS42X 2295-2296
  byte   INS53X 2297-2298
  byte   INS03X 2299-2300
  byte   INSAT31X 2301-2302
  byte   INSAT42X 2303-2304
  byte   INSAT53X 2305-2306
  byte   INSAT03X 2307-2308
  byte   STAPR31 2309-2310
  byte   STAPR42 2311-2312
  byte   STAPR53 2313-2314
  byte   STAPR03 2315-2316
  byte   STPRAT31 2317-2318
  byte   STPRAT42 2319-2320
  byte   STPRAT53 2321-2322
  byte   STPRAT03 2323-2324
  byte   EVRUNINS 2325-2325
  byte   EVRUNAT 2326-2326
  byte   DENTIN31 2327-2328
  byte   DENTIN42 2329-2330
  byte   DENTIN53 2331-2332
  byte   PMEDIN31 2333-2334
  byte   PMEDIN42 2335-2336
  byte   PMEDIN53 2337-2338
  byte   GDCPBM42 2339-2340
  byte   APRTRM42 2341-2342
  byte   APRDLM42 2343-2344
  byte   LKINFM42 2345-2346
  byte   PBINFM42 2347-2348
  byte   CSTSVM42 2349-2350
  byte   PBSVCM42 2351-2352
  byte   PPRWKM42 2353-2354
  byte   PBPWKM42 2355-2356
  byte   RTPLNM42 2357-2358
  byte   GDCPBT42 2359-2360
  byte   APRTRT42 2361-2362
  byte   APRDLT42 2363-2364
  byte   LKINFT42 2365-2366
  byte   PBINFT42 2367-2368
  byte   CSTSVT42 2369-2370
  byte   PBSVCT42 2371-2372
  byte   PPRWKT42 2373-2374
  byte   PBPWKT42 2375-2376
  byte   RTPLNT42 2377-2378
  long   TOTTCH03 2379-2385
  long   TOTEXP03 2386-2391
  long   TOTSLF03 2392-2397
  long   TOTMCR03 2398-2403
  long   TOTMCD03 2404-2409
  long   TOTPRV03 2410-2415
  long   TOTVA03 2416-2421
  long   TOTTRI03 2422-2426
  long   TOTOFD03 2427-2431
  long   TOTSTL03 2432-2436
  long   TOTWCP03 2437-2442
  long   TOTOPR03 2443-2447
  long   TOTOPU03 2448-2452
  long   TOTOSR03 2453-2457
  int    OBTOTV03 2458-2460
  long   OBVTCH03 2461-2466
  long   OBVEXP03 2467-2471
  long   OBVSLF03 2472-2476
  long   OBVMCR03 2477-2481
  long   OBVMCD03 2482-2486
  long   OBVPRV03 2487-2491
  long   OBVVA03 2492-2496
  long   OBVTRI03 2497-2501
  long   OBVOFD03 2502-2506
  long   OBVSTL03 2507-2511
  long   OBVWCP03 2512-2516
  long   OBVOPR03 2517-2521
  long   OBVOPU03 2522-2526
  int    OBVOSR03 2527-2530
  int    OBDRV03 2531-2533
  long   OBDTCH03 2534-2539
  long   OBDEXP03 2540-2544
  long   OBDSLF03 2545-2549
  long   OBDMCR03 2550-2554
  long   OBDMCD03 2555-2559
  long   OBDPRV03 2560-2564
  long   OBDVA03 2565-2569
  long   OBDTRI03 2570-2574
  long   OBDOFD03 2575-2579
  long   OBDSTL03 2580-2584
  long   OBDWCP03 2585-2589
  long   OBDOPR03 2590-2594
  long   OBDOPU03 2595-2599
  int    OBDOSR03 2600-2603
  int    OBOTHV03 2604-2606
  long   OBOTCH03 2607-2612
  long   OBOEXP03 2613-2617
  long   OBOSLF03 2618-2622
  long   OBOMCR03 2623-2627
  long   OBOMCD03 2628-2632
  long   OBOPRV03 2633-2637
  long   OBOVA03 2638-2642
  int    OBOTRI03 2643-2646
  int    OBOOFD03 2647-2650
  int    OBOSTL03 2651-2654
  long   OBOWCP03 2655-2659
  int    OBOOPR03 2660-2663
  int    OBOOPU03 2664-2667
  int    OBOOSR03 2668-2671
  int    OBCHIR03 2672-2674
  long   OBCTCH03 2675-2679
  long   OBCEXP03 2680-2684
  int    OBCSLF03 2685-2688
  int    OBCMCR03 2689-2692
  int    OBCMCD03 2693-2696
  int    OBCPRV03 2697-2700
  int    OBCVA03 2701-2704
  int    OBCTRI03 2705-2708
  int    OBCOFD03 2709-2712
  byte   OBCSTL03 2713-2713
  int    OBCWCP03 2714-2717
  int    OBCOPR03 2718-2721
  int    OBCOPU03 2722-2724
  int    OBCOSR03 2725-2728
  int    OBNURS03 2729-2731
  long   OBNTCH03 2732-2737
  long   OBNEXP03 2738-2742
  long   OBNSLF03 2743-2747
  long   OBNMCR03 2748-2752
  long   OBNMCD03 2753-2757
  long   OBNPRV03 2758-2762
  int    OBNVA03 2763-2766
  int    OBNTRI03 2767-2770
  int    OBNOFD03 2771-2774
  int    OBNSTL03 2775-2777
  int    OBNWCP03 2778-2781
  int    OBNOPR03 2782-2784
  int    OBNOPU03 2785-2787
  int    OBNOSR03 2788-2791
  byte   OBOPTO03 2792-2793
  int    OBETCH03 2794-2797
  int    OBEEXP03 2798-2801
  int    OBESLF03 2802-2805
  int    OBEMCR03 2806-2809
  int    OBEMCD03 2810-2812
  int    OBEPRV03 2813-2816
  int    OBEVA03 2817-2820
  int    OBETRI03 2821-2824
  int    OBEOFD03 2825-2828
  int    OBESTL03 2829-2831
  byte   OBEWCP03 2832-2832
  int    OBEOPR03 2833-2835
  int    OBEOPU03 2836-2838
  int    OBEOSR03 2839-2841
  byte   OBASST03 2842-2843
  long   OBATCH03 2844-2848
  int    OBAEXP03 2849-2852
  int    OBASLF03 2853-2856
  int    OBAMCR03 2857-2860
  int    OBAMCD03 2861-2864
  int    OBAPRV03 2865-2868
  int    OBAVA03 2869-2871
  int    OBATRI03 2872-2874
  int    OBAOFD03 2875-2877
  byte   OBASTL03 2878-2879
  int    OBAWCP03 2880-2883
  int    OBAOPR03 2884-2886
  byte   OBAOPU03 2887-2887
  int    OBAOSR03 2888-2890
  int    OBTHER03 2891-2893
  long   OBTTCH03 2894-2898
  long   OBTEXP03 2899-2903
  int    OBTSLF03 2904-2907
  int    OBTMCR03 2908-2911
  int    OBTMCD03 2912-2915
  long   OBTPRV03 2916-2920
  int    OBTVA03 2921-2924
  int    OBTTRI03 2925-2928
  int    OBTOFD03 2929-2932
  int    OBTSTL03 2933-2936
  long   OBTWCP03 2937-2941
  int    OBTOPR03 2942-2945
  int    OBTOPU03 2946-2948
  int    OBTOSR03 2949-2952
  int    OPTOTV03 2953-2955
  long   OPFTCH03 2956-2961
  long   OPFEXP03 2962-2966
  int    OPFSLF03 2967-2970
  long   OPFMCR03 2971-2975
  long   OPFMCD03 2976-2980
  long   OPFPRV03 2981-2985
  long   OPFVA03 2986-2990
  int    OPFTRI03 2991-2994
  int    OPFOFD03 2995-2998
  int    OPFSTL03 2999-3002
  long   OPFWCP03 3003-3007
  long   OPFOPR03 3008-3012
  int    OPFOPU03 3013-3016
  long   OPFOSR03 3017-3021
  long   OPDEXP03 3022-3026
  long   OPDTCH03 3027-3031
  int    OPDSLF03 3032-3035
  int    OPDMCR03 3036-3039
  int    OPDMCD03 3040-3043
  long   OPDPRV03 3044-3048
  int    OPDVA03 3049-3051
  int    OPDTRI03 3052-3054
  int    OPDOFD03 3055-3057
  int    OPDSTL03 3058-3061
  int    OPDWCP03 3062-3065
  int    OPDOPR03 3066-3069
  int    OPDOPU03 3070-3072
  int    OPDOSR03 3073-3076
  int    OPDRV03 3077-3079
  long   OPVTCH03 3080-3085
  long   OPVEXP03 3086-3090
  int    OPVSLF03 3091-3094
  long   OPVMCR03 3095-3099
  long   OPVMCD03 3100-3104
  long   OPVPRV03 3105-3109
  int    OPVVA03 3110-3113
  int    OPVTRI03 3114-3117
  int    OPVOFD03 3118-3121
  int    OPVSTL03 3122-3125
  int    OPVWCP03 3126-3129
  long   OPVOPR03 3130-3134
  int    OPVOPU03 3135-3138
  int    OPVOSR03 3139-3142
  long   OPSEXP03 3143-3147
  long   OPSTCH03 3148-3152
  int    OPSSLF03 3153-3156
  int    OPSMCR03 3157-3160
  int    OPSMCD03 3161-3164
  long   OPSPRV03 3165-3169
  int    OPSVA03 3170-3172
  int    OPSTRI03 3173-3175
  int    OPSOFD03 3176-3178
  int    OPSSTL03 3179-3182
  int    OPSWCP03 3183-3186
  int    OPSOPR03 3187-3190
  int    OPSOPU03 3191-3193
  int    OPSOSR03 3194-3197
  int    OPOTHV03 3198-3200
  long   OPOTCH03 3201-3206
  long   OPOEXP03 3207-3211
  int    OPOSLF03 3212-3215
  long   OPOMCR03 3216-3220
  int    OPOMCD03 3221-3224
  long   OPOPRV03 3225-3229
  int    OPOVA03 3230-3233
  int    OPOTRI03 3234-3237
  int    OPOOFD03 3238-3241
  int    OPOSTL03 3242-3244
  long   OPOWCP03 3245-3249
  int    OPOOPR03 3250-3253
  int    OPOOPU03 3254-3256
  int    OPOOSR03 3257-3260
  long   OPPEXP03 3261-3265
  long   OPPTCH03 3266-3270
  int    OPPSLF03 3271-3274
  int    OPPMCR03 3275-3278
  int    OPPMCD03 3279-3282
  long   OPPPRV03 3283-3287
  int    OPPVA03 3288-3290
  int    OPPTRI03 3291-3293
  byte   OPPOFD03 3294-3294
  byte   OPPSTL03 3295-3296
  int    OPPWCP03 3297-3300
  int    OPPOPR03 3301-3304
  int    OPPOPU03 3305-3307
  int    OPPOSR03 3308-3310
  int    AMCHIR03 3311-3313
  long   AMCTCH03 3314-3318
  long   AMCEXP03 3319-3323
  int    AMCSLF03 3324-3327
  int    AMCMCR03 3328-3331
  int    AMCMCD03 3332-3335
  int    AMCPRV03 3336-3339
  int    AMCVA03 3340-3343
  int    AMCTRI03 3344-3347
  int    AMCOFD03 3348-3351
  byte   AMCSTL03 3352-3352
  int    AMCWCP03 3353-3356
  int    AMCOPR03 3357-3360
  int    AMCOPU03 3361-3363
  int    AMCOSR03 3364-3367
  int    AMNURS03 3368-3370
  long   AMNTCH03 3371-3376
  long   AMNEXP03 3377-3381
  long   AMNSLF03 3382-3386
  long   AMNMCR03 3387-3391
  long   AMNMCD03 3392-3396
  long   AMNPRV03 3397-3401
  int    AMNVA03 3402-3405
  int    AMNTRI03 3406-3409
  int    AMNOFD03 3410-3413
  int    AMNSTL03 3414-3416
  int    AMNWCP03 3417-3420
  int    AMNOPR03 3421-3423
  int    AMNOPU03 3424-3426
  int    AMNOSR03 3427-3430
  byte   AMOPTO03 3431-3432
  int    AMETCH03 3433-3436
  int    AMEEXP03 3437-3440
  int    AMESLF03 3441-3444
  int    AMEMCR03 3445-3448
  int    AMEMCD03 3449-3451
  int    AMEPRV03 3452-3455
  int    AMEVA03 3456-3459
  int    AMETRI03 3460-3463
  int    AMEOFD03 3464-3467
  int    AMESTL03 3468-3470
  byte   AMEWCP03 3471-3472
  int    AMEOPR03 3473-3475
  int    AMEOPU03 3476-3478
  int    AMEOSR03 3479-3481
  byte   AMASST03 3482-3483
  long   AMATCH03 3484-3488
  long   AMAEXP03 3489-3493
  int    AMASLF03 3494-3497
  int    AMAMCR03 3498-3501
  int    AMAMCD03 3502-3505
  int    AMAPRV03 3506-3509
  int    AMAVA03 3510-3513
  int    AMATRI03 3514-3516
  int    AMAOFD03 3517-3519
  byte   AMASTL03 3520-3521
  int    AMAWCP03 3522-3525
  int    AMAOPR03 3526-3529
  byte   AMAOPU03 3530-3530
  int    AMAOSR03 3531-3533
  int    AMTHER03 3534-3536
  long   AMTTCH03 3537-3541
  long   AMTEXP03 3542-3546
  int    AMTSLF03 3547-3550
  long   AMTMCR03 3551-3555
  int    AMTMCD03 3556-3559
  long   AMTPRV03 3560-3564
  int    AMTVA03 3565-3568
  int    AMTTRI03 3569-3572
  int    AMTOFD03 3573-3576
  int    AMTSTL03 3577-3580
  long   AMTWCP03 3581-3585
  int    AMTOPR03 3586-3589
  int    AMTOPU03 3590-3592
  int    AMTOSR03 3593-3596
  byte   AMTOTC03 3597-3598
  byte   AMDRC03 3599-3600
  byte   ERTOT03 3601-3602
  long   ERFTCH03 3603-3607
  long   ERFEXP03 3608-3612
  long   ERFSLF03 3613-3617
  int    ERFMCR03 3618-3621
  int    ERFMCD03 3622-3625
  long   ERFPRV03 3626-3630
  long   ERFVA03 3631-3635
  int    ERFTRI03 3636-3639
  int    ERFOFD03 3640-3643
  int    ERFSTL03 3644-3647
  int    ERFWCP03 3648-3651
  long   ERFOPR03 3652-3656
  int    ERFOPU03 3657-3660
  int    ERFOSR03 3661-3664
  int    ERDEXP03 3665-3668
  int    ERDTCH03 3669-3672
  int    ERDSLF03 3673-3676
  int    ERDMCR03 3677-3680
  int    ERDMCD03 3681-3684
  int    ERDPRV03 3685-3688
  int    ERDVA03 3689-3691
  int    ERDTRI03 3692-3694
  byte   ERDOFD03 3695-3695
  int    ERDSTL03 3696-3699
  int    ERDWCP03 3700-3702
  int    ERDOPR03 3703-3706
  int    ERDOPU03 3707-3709
  int    ERDOSR03 3710-3712
  byte   IPZERO03 3713-3713
  long   ZIFTCH03 3714-3718
  long   ZIFEXP03 3719-3723
  int    ZIFSLF03 3724-3727
  long   ZIFMCR03 3728-3732
  int    ZIFMCD03 3733-3736
  long   ZIFPRV03 3737-3741
  int    ZIFVA03 3742-3745
  int    ZIFTRI03 3746-3749
  byte   ZIFOFD03 3750-3750
  int    ZIFSTL03 3751-3754
  byte   ZIFWCP03 3755-3755
  long   ZIFOPR03 3756-3760
  int    ZIFOPU03 3761-3764
  long   ZIFOSR03 3765-3769
  int    ZIDEXP03 3770-3773
  long   ZIDTCH03 3774-3778
  int    ZIDSLF03 3779-3782
  int    ZIDMCR03 3783-3786
  int    ZIDMCD03 3787-3790
  int    ZIDPRV03 3791-3794
  byte   ZIDVA03 3795-3795
  byte   ZIDTRI03 3796-3797
  byte   ZIDOFD03 3798-3798
  int    ZIDSTL03 3799-3801
  byte   ZIDWCP03 3802-3802
  int    ZIDOPR03 3803-3805
  int    ZIDOPU03 3806-3809
  int    ZIDOSR03 3810-3812
  byte   IPDIS03 3813-3813
  long   IPFEXP03 3814-3819
  long   IPFTCH03 3820-3826
  long   IPFSLF03 3827-3831
  long   IPFMCR03 3832-3837
  long   IPFMCD03 3838-3843
  long   IPFPRV03 3844-3849
  long   IPFVA03 3850-3855
  long   IPFTRI03 3856-3860
  long   IPFOFD03 3861-3865
  long   IPFSTL03 3866-3870
  long   IPFWCP03 3871-3876
  long   IPFOPR03 3877-3881
  long   IPFOPU03 3882-3886
  long   IPFOSR03 3887-3891
  long   IPDEXP03 3892-3896
  long   IPDTCH03 3897-3901
  int    IPDSLF03 3902-3905
  long   IPDMCR03 3906-3910
  long   IPDMCD03 3911-3915
  long   IPDPRV03 3916-3920
  int    IPDVA03 3921-3924
  long   IPDTRI03 3925-3929
  int    IPDOFD03 3930-3932
  int    IPDSTL03 3933-3936
  long   IPDWCP03 3937-3941
  int    IPDOPR03 3942-3945
  int    IPDOPU03 3946-3949
  int    IPDOSR03 3950-3952
  int    IPNGTD03 3953-3955
  byte   DVTOT03 3956-3957
  long   DVTTCH03 3958-3962
  long   DVTEXP03 3963-3967
  long   DVTSLF03 3968-3972
  int    DVTMCR03 3973-3976
  int    DVTMCD03 3977-3980
  long   DVTPRV03 3981-3985
  int    DVTVA03 3986-3989
  int    DVTTRI03 3990-3993
  int    DVTOFD03 3994-3997
  int    DVTSTL03 3998-4001
  int    DVTWCP03 4002-4005
  int    DVTOPR03 4006-4009
  int    DVTOPU03 4010-4013
  int    DVTOSR03 4014-4017
  byte   DVGEN03 4018-4019
  long   DVGTCH03 4020-4024
  long   DVGEXP03 4025-4029
  int    DVGSLF03 4030-4033
  int    DVGMCR03 4034-4037
  int    DVGMCD03 4038-4041
  int    DVGPRV03 4042-4045
  int    DVGVA03 4046-4049
  int    DVGTRI03 4050-4053
  int    DVGOFD03 4054-4057
  int    DVGSTL03 4058-4061
  int    DVGWCP03 4062-4064
  int    DVGOPR03 4065-4068
  int    DVGOPU03 4069-4072
  int    DVGOSR03 4073-4076
  byte   DVORTH03 4077-4078
  long   DVOTCH03 4079-4083
  long   DVOEXP03 4084-4088
  int    DVOSLF03 4089-4092
  byte   DVOMCR03 4093-4093
  int    DVOMCD03 4094-4097
  long   DVOPRV03 4098-4102
  byte   DVOVA03 4103-4104
  byte   DVOTRI03 4105-4105
  int    DVOOFD03 4106-4108
  int    DVOSTL03 4109-4112
  int    DVOWCP03 4113-4116
  int    DVOOPR03 4117-4120
  byte   DVOOPU03 4121-4122
  int    DVOOSR03 4123-4126
  int    HHTOTD03 4127-4129
  int    HHAGD03 4130-4132
  long   HHATCH03 4133-4137
  long   HHAEXP03 4138-4142
  long   HHASLF03 4143-4147
  long   HHAMCR03 4148-4152
  long   HHAMCD03 4153-4157
  long   HHAPRV03 4158-4162
  int    HHAVA03 4163-4166
  byte   HHATRI03 4167-4167
  int    HHAOFD03 4168-4171
  long   HHASTL03 4172-4176
  int    HHAWCP03 4177-4180
  int    HHAOPR03 4181-4184
  int    HHAOPU03 4185-4188
  int    HHAOSR03 4189-4192
  int    HHINDD03 4193-4195
  long   HHNTCH03 4196-4200
  long   HHNEXP03 4201-4205
  long   HHNSLF03 4206-4210
  int    HHNMCR03 4211-4214
  int    HHNMCD03 4215-4218
  int    HHNPRV03 4219-4222
  int    HHNVA03 4223-4226
  byte   HHNTRI03 4227-4227
  byte   HHNOFD03 4228-4228
  long   HHNSTL03 4229-4233
  byte   HHNWCP03 4234-4234
  byte   HHNOPR03 4235-4235
  byte   HHNOPU03 4236-4236
  int    HHNOSR03 4237-4239
  int    HHINFD03 4240-4242
  int    VISEXP03 4243-4246
  int    VISTCH03 4247-4250
  int    VISSLF03 4251-4254
  int    VISMCR03 4255-4257
  int    VISMCD03 4258-4260
  int    VISPRV03 4261-4264
  int    VISVA03 4265-4267
  int    VISTRI03 4268-4270
  int    VISOFD03 4271-4274
  int    VISSTL03 4275-4277
  byte   VISWCP03 4278-4279
  int    VISOPR03 4280-4282
  int    VISOPU03 4283-4285
  int    VISOSR03 4286-4288
  long   OTHTCH03 4289-4293
  long   OTHEXP03 4294-4298
  long   OTHSLF03 4299-4303
  int    OTHMCR03 4304-4307
  int    OTHMCD03 4308-4311
  int    OTHPRV03 4312-4315
  long   OTHVA03 4316-4320
  long   OTHTRI03 4321-4325
  int    OTHOFD03 4326-4328
  int    OTHSTL03 4329-4332
  int    OTHWCP03 4333-4336
  int    OTHOPR03 4337-4340
  int    OTHOPU03 4341-4344
  int    OTHOSR03 4345-4348
  int    RXTOT03 4349-4351
  long   RXEXP03 4352-4356
  long   RXSLF03 4357-4361
  long   RXMCR03 4362-4366
  long   RXMCD03 4367-4371
  long   RXPRV03 4372-4376
  long   RXVA03 4377-4381
  long   RXTRI03 4382-4386
  int    RXOFD03 4387-4390
  long   RXSTL03 4391-4395
  int    RXWCP03 4396-4399
  int    RXOPR03 4400-4403
  int    RXOPU03 4404-4407
  int    RXOSR03 4408-4411
  double PERWT03F 4412-4423
  double FAMWT03F 4424-4435
  double FAMWT03C 4436-4447
  double SAQWT03F 4448-4459
  double DIABW03F 4460-4471
  int    VARSTR 4472-4474
  byte   VARPSU 4475-4475
using H79.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON NUMBER";
label variable DUPERSID "PERSID (DUID + PID)";
label variable PANEL03 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - R3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - R4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - R5/3";
label variable FAMID03 "FAMILY ID (STUDENT MERGED IN) - 12/31/03";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPSFAMID";
label variable HIEUIDX "HIEU IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY-03";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY-03";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR03 "RU LETTER AS OF 12/31/03";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE03 "RU SIZE AS OF 12/31/03";
label variable RUCLAS31 "RU FIELDED AS:STANDARD/NEW/STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD/NEW/STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS:STANDARD/NEW/STUDENT-R5/3";
label variable RUCLAS03 "RU FIELDED AS:STANDARD/NEW/STUD-12/31/03";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE03 "RU SIZE INCLUDING STUDENT AS OF 12/31/03";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION03 "CENSUS REGION AS OF 12/31/03";
label variable MSA31 "MSA STATUS - R3/1";
label variable MSA42 "MSA STATUS - R4/2";
label variable MSA53 "MSA STATUS - R5/3";
label variable MSA03 "MSA AS OF 12/31/03";
label variable REFPRS31 "REFERENCE PERSON AT - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS03 "REFERENCE PERSON AS OF 12/31/03";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP03 "1ST RESPONDENT INDICATOR AS OF 12/31/03";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY03 "WAS RESPONDENT A PROXY AS OF 12/31/03";
label variable INTVLANG "LANGUAGE INTERVIEW WAS COMPLETED";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REFERENCE PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD03 "2003 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM03 "2003 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY03 "2003 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP03 "INSCOPE - R5/3 START THROUGH 12/31/03";
label variable INSC1231 "INSCOPE STATUS ON 12/31/03";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 2003";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY - R5/3";
label variable ELGRND03 "ELIGIBILITY STATUS AS OF 12/31/03";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE - R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE - R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE03X "AGE AS OF 12/31/03 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACEAX "ASIAN AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEBX "BLACK AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACEWX "WHITE AMONG RACES RPTD (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY03X "MARITAL STATUS-12/31/03 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID03 "SPOUSE ID - 12/31/03";
label variable SPOUIN31 "MARITAL STATUS W/SPOUSE PRESENT-R3/1";
label variable SPOUIN42 "MARITAL STATUS W/SPOUSE PRESENT-R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT-R5/3";
label variable SPOUIN03 "MARITAL STATUS W/SPOUSE PRESENT-12/31/03";
label variable EDUCYEAR "YEARS OF EDUC WHEN FIRST ENTERED MEPS";
label variable HIDEGYR "HIGHEST DEGREE WHEN FIRST ENTERED MEPS";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 - R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 - R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23 - R5/3";
label variable FTSTU03X "STUDENT STATUS IF AGES 17-23 - 12/31/03";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - R3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - R4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - R5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETGULF "SERVED IN PERSIAN GULF/DESERT STORM";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS-R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS-R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS-R5/3 (EDIT/IMP)";
label variable RFREL03X "RELATION TO REF PERS-12/31/03 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS03 "SSI RECEIPT DUE TO DISABILITY";
label variable AFDC03 "DID PERSON S CHECK INCLUDE TANF";
label variable FILEDR03 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL03 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT03 "PERSON S FILING STATUS";
label variable FILER03 "PRIMARY OR SECONDARY FILER";
label variable JTINRU03 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID03 "PID OF SECONDARY FILER";
label variable CLMDEP03 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT03 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU03 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD03 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM03 "TAX FORM PERSON WILL FILE";
label variable DEDUCT03 "ITEMIZE OR STANDARD DEDUCTION";
label variable TOTDED03 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP03 "DID/WILL PERS DEDUCT HEALTH INSUR. PREM.";
label variable EICRDT03 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable FOODST03 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN03 "NUMBER OF MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT03 "MONTHLY AMT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL03 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP03X "PERSON S TOTAL INCOME";
label variable POVCAT03 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP03X "PERSON S WAGE INCOME";
label variable WAGIMP03 "WAGE IMPUTATION FLAG";
label variable BUSNP03X "PERSON S BUSINESS INCOME";
label variable BUSIMP03 "BUSINESS INCOME IMPUTATION FLAG";
label variable UNEMP03X "PERSON S UNEMPLOYMENT COMP INCOME";
label variable UNEIMP03 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP03X "PERSON S WORKERS  COMPENSATION";
label variable WCPIMP03 "WORKER S COMP IMPUTATION FLAG";
label variable INTRP03X "PERSON S INTEREST INCOME";
label variable INTIMP03 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP03X "PERSON S DIVIDEND INCOME";
label variable DIVIMP03 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP03X "PERSON S SALES INCOME";
label variable SALIMP03 "SALES INCOME IMPUTATION FLAG";
label variable PENSP03X "PERSON S PENSION INCOME";
label variable PENIMP03 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP03X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP03 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP03X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP03 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP03X "PERSON S VETERANS INCOME";
label variable VETIMP03 "VETERAN S INCOME IMPUTATION FLAG";
label variable IRASP03X "PERSON S IRA INCOME";
label variable IRAIMP03 "IRA INCOME IMPUTATION FLAG";
label variable REFDP03X "PERSON S REFUND INCOME";
label variable REFIMP03 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP03X "PERSON S ALIMONY INCOME";
label variable ALIIMP03 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP03X "PERSON S CHILD SUPPORT";
label variable CHLIMP03 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP03X "PERSON S OTHER REGULAR CASH CONTRIBUTION";
label variable CSHIMP03 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP03X "PERSON S SSI";
label variable SSIIMP03 "SSI IMPUTATION FLAG";
label variable PUBP03X "PERSON S PUBLIC ASSISTANCE";
label variable PUBIMP03 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP03X "PERSON S OTHER INCOME";
label variable OTHIMP03 "OTHER INCOME IMPUTATION FLAG";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable IADL3M31 "IADL HELP 3+ MONTHS - RD 3/1";
label variable IADL3M42 "IADL HELP 3+ MONTHS - RD 4/2";
label variable IADL3M53 "IADL HELP 3+ MONTHS - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable ADL3MO31 "ADL HELP 3+ MONTHS - RD 3/1";
label variable ADL3MO42 "ADL HELP 3+ MONTHS - RD 4/2";
label variable ADL3MO53 "ADL HELP 3+ MONTHS - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable WLK3MO31 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 3/1";
label variable WLK3MO53 "PHYS FUNCTIONING HELP 3+ MONTHS - RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM03 "ANY LIMITATION IN P7R3,4,5/P8R1,2,3";
label variable LSHLTH42 "LESS HEALTHY THAN OTHR CHILD (0-17)-R4/2";
label variable NEVILL42 "NEVER BEEN SERIOUSLY ILL (0-17)-R4/2";
label variable SICEAS42 "CHILD GETS SICK EASILY (0-17)-R4/2";
label variable HLTHLF42 "CHILD WILL HAVE HEALTHY LIFE (0-17)-R4/2";
label variable WRHLTH42 "WORRY MORE ABOUT HEALTH (0-17)-R4/2";
label variable CHPMED42 "CSHCN:CHILD NEEDS PRESCRB MED(0-17)-R4/2";
label variable CHPMHB42 "CSHCN:PMED FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHPMCN42 "CSHCN:PMED COND LAST 12+ MOS (0-17)-R4/2";
label variable CHSERV42 "CSHCN:CHLD NEEDS MED&OTH SERV(0-17)-R4/2";
label variable CHSRHB42 "CSHCN:SERV FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHSRCN42 "CSHCN:SERV COND LAST 12+ MOS (0-17)-R4/2";
label variable CHLIMI42 "CSHCN:LIMITED IN ANY WAY (0-17)-R4/2";
label variable CHLIHB42 "CSHCN:LIMT FOR HLTH/BEHV COND(0-17)-R4/2";
label variable CHLICO42 "CSHCN:LIMIT COND LAST 12+MOS (0-17)-R4/2";
label variable CHTHER42 "CSHCN:CHLD NEEDS SPEC THERAPY(0-17)-R4/2";
label variable CHTHHB42 "CSHCN:SPEC THER FOR HLTH+COND(0-17)-R4/2";
label variable CHTHCO42 "CSHCN:THER COND LAST 12+ MOS (0-17)-R4/2";
label variable CHCOUN42 "CSHCN:CHILD NEEDS COUNSELING (0-17)-R4/2";
label variable CHEMPB42 "CSHCN:COUNS PROB LAST 12+MOS (0-17)-R4/2";
label variable CSHCN42 "CSHCN:CHILD W/SPEC HC NEEDS (0-17)-R4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-R4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-R4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-R4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-R4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - R4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PRBLM GETTING ALONG W/SIBS (5-17)-R4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17)-R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17)-R4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-R4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-R4/2";
label variable TRBLE42 "PRBLM STAY OUT OF TROUBLE (5-17)-R4/2";
label variable CHILCR42 "CAHPS:12MOS:ILL/INJ NEED CARE(0-17)-R4/2";
label variable CHILWW42 "CAHPS:12MOS:ILL CARE WHN WNTD(0-17)-R4/2";
label variable CHRTCR42 "CAHPS:12MOS:MAKE ROUT CARE APT(0-17)R4/2";
label variable CHRTWW42 "CAHPS:12MOS:ROUT APT WHN WNTD(0-17)-R4/2";
label variable CHAPPT42 "CAHPS:12MOS:# OF OFF/CLIN APTS(0-17)R4/2";
label variable CHNDCR42 "CAHPS:12MOS:NEED ANY CARE/TRT(0-17)-R4/2";
label variable CHNECP42 "CAHPS:12MOS:PROB GET NEC CARE(0-17)R4/2";
label variable CHLIST42 "CAHPS:12MOS:CHLD DR LSN TO YOU(0-17)R4/2";
label variable CHEXPL42 "CAHPS:12MOS:CHLD DR EXPL THNG(0-17)R4/2";
label variable CHRESP42 "CAHPS:12MOS:CHLD S DR SHW RESP(0-17)R4/2";
label variable CHPRTM42 "CAHPS:12MOS:CHILD DR ENGH TIME(0-17)R4/2";
label variable CHHECR42 "CAHPS:12MOS:RATE CHLD HLT CARE(0-17)R4/2";
label variable CHSPEC42 "CAHPS:12MOS:CHLD NEEDED SPEC(0-17)R4/2";
label variable CHPRRE42 "CAHPS:12MOS:PRB W/RFR TO SPEC(0-17)R4/2";
label variable MESHGT42 "DOCTOR EVER MEASURED HEIGHT (0-17)-R4/2";
label variable WHNHGT42 "WHEN DOCTOR MEASURED HEIGHT (0-17)-R4/2";
label variable MESWGT42 "DOCTOR EVER MEASURED WEIGHT (0-17)-R4/2";
label variable WHNWGT42 "WHEN DOCTOR MEASURED WEIGHT (0-17)-R4/2";
label variable CHBMIX42 "CHILD S BODY MASS INDEX (6-17) - R4/2";
label variable MESVIS42 "DOCTOR CHECKED CHILD S VISION (3-6)-R4/2";
label variable MESBPR42 "DR CHECKED BLOOD PRESSURE (2-17)-R4/2";
label variable WHNBPR42 "WHEN DR CHECKED BLOOD PRESS (2-17)-R4/2";
label variable DENTAL42 "DR ADVISE REG DENTAL CHECKUP (2-17)-R4/2";
label variable WHNDEN42 "WHEN DR ADVISE DENT CHECKUP (2-17)-R4/2";
label variable EATHLT42 "DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable WHNEAT42 "WHEN DR ADVISE EAT HEALTHY (2-17)-R4/2";
label variable PHYSCL42 "DR ADVISE EXERCISE (2-17)-R4/2";
label variable WHNPHY42 "WHEN DR ADVISE EXERCISE (2-17)-R4/2";
label variable SAFEST42 "DR ADVISE CHLD SAFETY SEAT (WT<=40)-R4/2";
label variable WHNSAF42 "WHEN DR ADVISE SAFETY SEAT (WT<=40)-R4/2";
label variable BOOST42 "DR ADVISE BOOSTER SEAT (40<WT<=80)-R4/2";
label variable WHNBST42 "WHN DR ADVISE BOOST SEAT(40<WT<=80)-R4/2";
label variable LAPBLT42 "DR ADVISE LAP/SHOULDER BELT (80<WT)-R4/2";
label variable WHNLAP42 "WHN DR ADVISE LAP/SHLDR BLT (80<WT)-R4/2";
label variable HELMET42 "DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable WHNHEL42 "WHEN DR ADVISE BIKE HELMET (2-17)-R4/2";
label variable NOSMOK42 "DR ADVISE SMKG IN HOME IS BAD(0-17)-R4/2";
label variable WHNSMK42 "WHN DR ADVIS SMKG IN HOME BAD(0-17)-R4/2";
label variable TIMALN42 "DOCTOR SPEND ANY TIME ALONE (12-17)-R4/2";
label variable DENTCK53 "HOW OFTEN DENTAL CHECK-UP - RD 5/3";
label variable CHOLCK53 "HOW LNG CHOLEST LST CHCK (>17) - RD 5/3";
label variable CHECK53 "HOW LNG LST ROUTNE CHECKUP (>17)-RD 5/3";
label variable FLUSHT53 "HOW LNG LAST FLU SHT (>17) - RD 5/3";
label variable LSTETH53 "LOST ALL UPPR AND LOWR TEETH (>17)-RD5/3";
label variable PSA53 "HOW LONG SINCE LAST PSA (>39) - RD 5/3";
label variable HYSTER53 "HAD A HYSTERECTOMY (>17) - RD 5/3";
label variable PAPSMR53 "HOW LNG LST PAP SMEAR TST (>17) - RD 5/3";
label variable BRSTEX53 "HOW LNG SNCE LST BREAST EXAM (>17)-RD5/3";
label variable MAMOGR53 "HOW LNG SNCE LST MAMMOGRAM (>29) - RD5/3";
label variable STOOL53 "BLD STOOL TST KIT/CRDS HOME (>17)-RD5/3";
label variable WHENST53 "WHN LST BLD STOOL TST HME KIT (>17)-R5/3";
label variable BOWEL53 "SIGMOIDOSCOPY/COLONOSCOPY (>17) - RD 5/3";
label variable WHNBWL53 "LST SIGMOIDOSCOP/COLONOSCOP (>17)-RD 5/3";
label variable PHYACT53 "MOD/VIG PHYS ACTIV 3X WK (>17) - RD 5/3";
label variable BMINDX53 "ADULT BODY MASS INDEX (>17) - RD 5/3";
label variable SEATBE53 "WEARS SEAT BELT (>15) - RD 5/3";
label variable SRTHRT53 "12MO: SERIOUS SORE THROAT(0-17)-RD 5/3";
label variable THSYMP53 "12MO:SORE THRT/OTH SYMPTMS(0-17)-RD 5/3";
label variable DRTHRT53 "12MO: SEE DR FOR SORE THRT(0-17)-RD 5/3";
label variable THANTB53 "12MO: DR PRES ANTBTC SRE THRT(0-17)RD5/3";
label variable THSWAB53 "12MO: DR GAVE THROAT SWAB(0-17)-RD 5/3";
label variable THSYMF53 "12MO:FAM SAME SRE THRT SYMP (0-17)RD5/3";
label variable THSWBF53 "12MO:DR GAVE FAM THRT SWAB(0-17)-RD5/3";
label variable THANTF53 "12MO:DR PRES FAM ATBTC SR THT(0-17)RD5/3";
label variable DIABDX53 "DIABETES DIAGNOSIS - RD 5/3";
label variable ASTHDX53 "ASTHMA DIAGNOSIS - RD 5/3";
label variable ASSTIL53 "DOES PERSON STILL HAVE ASTHMA - RD 5/3";
label variable ASATAK53 "ASTHMA ATTACK LAST 12 MOS - RD 5/3";
label variable ASACUT53 "USED ACUTE PRES INHALER LAST 3 MOS-RD5/3";
label variable ASMRCN53 "USED>3ACUTE CN PRES INH LAST 3 MOS-RD5/3";
label variable ASPREV53 "EVER USED PREV DAILY ASTHMA MEDS -RD 5/3";
label variable ASDALY53 "NOW TAKE PREV DAILY ASTHMA MEDS - RD 5/3";
label variable ASPKFL53 "HAVE PEAK FLOW METER AT HOME - RD 5/3";
label variable ASEVFL53 "EVER USED PEAK FLOW METER - RD 5/3";
label variable ASWNFL53 "WHEN LAST USED PEAK FLOW METER - RD 5/3";
label variable HIBPDX53 "HIGH BLOOD PRESSURE DIAG (>17) - RD 5/3";
label variable BPMLDX53 "MULT DIAG HIGH BLOOD PRESS (>17) - RD5/3";
label variable BPCHEK53 "TIME SNCE LST BLOOD PRES CHK (>17)-RD5/3";
label variable BPMONT53 "# MOS SNCE LST BLOOD PRES CHK (>17)-R5/3";
label variable CHDDX53 "CORONARY HRT DISEASE DIAG (>17) - RD 5/3";
label variable ANGIDX53 "ANGINA DIAGNOSIS (>17) - RD 5/3";
label variable MIDX53 "HEART ATTACK (MI) DIAG (>17) - RD 5/3";
label variable OHRTDX53 "OTHER HEART DISEASE DIAG (>17) - RD 5/3";
label variable STRKDX53 "STROKE DIAGNOSIS (>17) - RD 5/3";
label variable EMPHDX53 "EMPHYSEMA DIAGNOSIS (>17) - RD 5/3";
label variable NOFAT53 "RESTRICT HGH FAT/CHOLES FOOD (>17)-RD5/3";
label variable EXRCIS53 "ADVISED TO EXERCISE MORE (>17) - RD 5/3";
label variable ASPRIN53 "TKE ASPIRN EVERY (OTHR) DAY (>17)-RD 5/3";
label variable NOASPR53 "TAKING ASPIRIN UNSAFE (>17) - RD 5/3";
label variable STOMCH53 "TKE ASPRN UNSAFE B/C STOMCH (>17)-RD 5/3";
label variable JTPAIN53 "JOINT PAIN LAST 12 MONTHS (>17) - RD 5/3";
label variable ARTHDX53 "ARTHRITIS DIAGNOSIS (>17) - RD 5/3";
label variable ARTHTX53 "ARTHRITIS TREATMNT CURRENTLY (>17)RD5/3";
label variable SAQELIG "ELIGIBILITY STATUS FOR SAQ";
label variable ADPRX42 "SAQ: RELATIONSHIP OF PROXY TO ADULT";
label variable ADILCR42 "SAQ 12MOS: ILL/INJURY NEEDING IMMED CARE";
label variable ADILWW42 "SAQ 12 MOS: GOT CARE WHEN NEEDED ILL/INJ";
label variable ADRTCR42 "SAQ 12 MOS: MADE APPT ROUTINE MED CARE";
label variable ADRTWW42 "SAQ 12 MOS: GOT MED APPT WHEN WANTED";
label variable ADAPPT42 "SAQ 12 MOS: # VISITS TO MED OFF FOR CARE";
label variable ADNDCR42 "SAQ 12MOS: NEED ANY CARE, TEST, TREATMNT";
label variable ADNECP42 "SAQ 12MOS: PROBS GETTING NEEDED MED CARE";
label variable ADLIST42 "SAQ 12 MOS: DOCTOR LISTENED TO YOU";
label variable ADEXPL42 "SAQ 12 MOS: DOC EXPLAINED SO UNDERSTOOD";
label variable ADRESP42 "SAQ 12 MOS: DR SHOWED RESPECT";
label variable ADPRTM42 "SAQ 12 MOS: DR SPENT ENUF TIME WITH YOU";
label variable ADHECR42 "SAQ 12 MOS: RATING OF HEALTH CARE";
label variable ADSMOK42 "SAQ: CURRENTLY SMOKE";
label variable ADNSMK42 "SAQ 12MOS: DR ADVISED TO QUIT SMOKING";
label variable ADDRBP42 "SAQ 2 YRS: DR CHECKED BLOOD PRESSURE";
label variable ADSPEC42 "SAQ 12 MOS: NEEDED TO SEE SPECIALIST";
label variable ADPRRE42 "SAQ 12MOS: PROBLEM GETTING SPEC REFERRAL";
label variable ADGENH42 "SAQ: HEALTH IN GENERAL SF-12V2";
label variable ADDAYA42 "SAQ: HLTH LIMITS MOD ACTIVITIES SF-12V2";
label variable ADCLIM42 "SAQ: HLTH LIMITS CLIMBING STAIRS SF-12V2";
label variable ADPALS42 "SAQ 4WKS:ACCMP LESS B/C PHY PRBS SF-12V2";
label variable ADPWLM42 "SAQ 4WKS:WORK LIMT B/C PHY PROBS SF-12V2";
label variable ADMALS42 "SAQ 4WKS:ACCMP LESS B/C MNT PRBS SF-12V2";
label variable ADMWLM42 "SAQ 4WKS:WORK LIMT B/C MNT PROBS SF-12V2";
label variable ADPAIN42 "SAQ 4WKS:PAIN LIMITS NORMAL WORK SF-12V2";
label variable ADCAPE42 "SAQ 4WKS: FELT CALM/PEACEFUL SF-12V2";
label variable ADNRGY42 "SAQ 4WKS: HAD A LOT OF ENERGY SF-12V2";
label variable ADDOWN42 "SAQ 4WKS: FELT DOWNHEARTED/DEPR SF-12V2";
label variable ADSOCA42 "SAQ 4WKS: HLTH STOPPED SOC ACTIV SF-12V2";
label variable PCS42 "SAQ:PHY COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable MCS42 "SAQ:MNT COMPONENT SUMMRY SF-12V2 IMPUTED";
label variable SFFLAG42 "SAQ: PCS/MCS IMPUTATION FLAG SF-12V2";
label variable ADMOBI42 "SAQ HEALTH TODAY: MOBILITY EQ-5D";
label variable ADSELF42 "SAQ HEALTH TODAY: SELF-CARE EQ-5D";
label variable ADACTI42 "SAQ HEALTH TODAY: USUAL ACTIVITY EQ-5D";
label variable ADPAYN42 "SAQ HEALTH TODAY: PAIN/DISCOMFORT EQ-5D";
label variable ADDEPR42 "SAQ HLTH TODAY: ANXIETY/DEPRESSION EQ-5D";
label variable ADSCAL42 "SAQ SCALE: HEALTH STATE TODAY EQ-5D";
label variable EQU42 "SAQ: PREFERENCE BASED INDEX EQ-5D";
label variable ADINSA42 "SAQ: DO NOT NEED HEALTH INSURANCE";
label variable ADINSB42 "SAQ: HEALTH INSURANCE NOT WORTH COST";
label variable ADRISK42 "SAQ: MORE LIKELY TO TAKE RISKS";
label variable ADOVER42 "SAQ: CAN OVERCOME ILLS WITHOUT MED HELP";
label variable ADCMPM42 "SAQ: DATE COMPLETED - MONTH";
label variable ADCMPD42 "SAQ: DATE COMPLETED - DAY";
label variable ADCMPY42 "SAQ: DATE COMPLETED - YEAR";
label variable ADLANG42 "SAQ: LANGUAGE OF SAQ INTERVIEW";
label variable DSDIA53 "DCS: DIABETES DIAGNOSIS BY HEALTH PROF";
label variable DSA1C53 "DCS: TIMES TESTED FOR A-ONE-C - 2003";
label variable DSCKFT53 "DCS: TIMES FEET CHECKED FOR SORES - 2003";
label variable DSEY0453 "DCS: DILATED EYE EXAM IN 2004";
label variable DSEY0353 "DCS: DILATED EYE EXAM IN 2003";
label variable DSEY0253 "DCS: DILATED EYE EXAM IN 2002";
label variable DSEB0253 "DCS: DILATED EYE EXAM BEFORE 2002";
label variable DSEYNV53 "DCS: NEVER HAD DILATED EYE EXAM";
label variable DSKIDN53 "DCS: HAS DIABETES CAUSED KIDNEY PROBLEMS";
label variable DSEYPR53 "DCS: HAS DIABETES CAUSED EYE PROBS";
label variable DSDIET53 "DCS: TREAT DIABETES W/DIET MODIFICATION";
label variable DSMED53 "DCS: TREAT DIABETES W/MEDS BY MOUTH";
label variable DSINSU53 "DCS: TREAT DIABETES W/INSULIN INJECTIONS";
label variable DSPRX53 "DCS: WAS RESPONDENT A PROXY";
label variable DDNWRK31 "# DAYS MISSED WORK DUE TO ILL/INJ (RD31)";
label variable DDNWRK42 "# DAYS MISSED WORK DUE TO ILL/INJ (RD42)";
label variable DDNWRK53 "# DAYS MISSED WORK DUE TO ILL/INJ (RD53)";
label variable WKINBD31 "# DAYS MISSED WORK STAYED IN BED (RD31)";
label variable WKINBD42 "# DAYS MISSED WORK STAYED IN BED (RD42)";
label variable WKINBD53 "# DAYS MISSED WORK STAYED IN BED (RD53)";
label variable DDNSCL31 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD31)";
label variable DDNSCL42 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD42)";
label variable DDNSCL53 "# DAYS MISSD SCHOOL DUE TO ILL/INJ(RD53)";
label variable SCLNBD31 "# DAYS MISSED SCHOOL STAYD IN BED (RD31)";
label variable SCLNBD42 "# DAYS MISSED SCHOOL STAYD IN BED (RD42)";
label variable SCLNBD53 "# DAYS MISSED SCHOOL STAYD IN BED (RD53)";
label variable DDBDYS31 "# OTH DAY SPENT IN BED SINCE START(RD31)";
label variable DDBDYS42 "# OTH DAY SPENT IN BED SINCE START(RD42)";
label variable DDBDYS53 "# OTH DAY SPENT IN BED SINCE START(RD53)";
label variable OTHDYS31 "MISS ANY WORK DAY TO CARE FOR OTH (RD31)";
label variable OTHDYS42 "MISS ANY WORK DAY TO CARE FOR OTH (RD42)";
label variable OTHDYS53 "MISS ANY WORK DAY TO CARE FOR OTH (RD53)";
label variable OTHNDD31 "# DAY MISSED WORK TO CARE FOR OTH (RD31)";
label variable OTHNDD42 "# DAY MISSED WORK TO CARE FOR OTH (RD42)";
label variable OTHNDD53 "# DAY MISSED WORK TO CARE FOR OTH (RD53)";
label variable ACCELI42 "PERS ELIGIBLE FOR ACCESS SUPPLEMENT-R4/2";
label variable LANGHM42 "AC01 LANGUAGE SPOKEN MOST IN HOME-R4/2";
label variable ENGHME42 "AC02 HH COMFORTABLE SPEAKNG ENGLISH-R4/2";
label variable ENGSPK42 "AC02A NOT COMFRTBLE SPEAKNG ENGLISH-R4/2";
label variable USBORN42 "AC03 WAS PERSON BORN IN US-R4/2";
label variable USLGLV42 "AC04 HOW LONG HAS PERS LIVED IN US-R4/2";
label variable HAVEUS42 "AC05 DOES PERSON HAVE USC PROVIDER-R4/2";
label variable YNOUSC42 "AC07 MAIN REAS PERS DOESNT HAVE USC-R4/2";
label variable NOREAS42 "AC08 OTH REAS NO USC:NO OTH REASONS-R4/2";
label variable SELDSI42 "AC08 OTH REAS NO USC:SELDM/NEV SICK-R4/2";
label variable NEWARE42 "AC08 OTH REAS NO USC:RECENTLY MOVED-R4/2";
label variable DKWHRU42 "AC08 OTH REAS NO USC:DK WHERE TO GO-R4/2";
label variable USCNOT42 "AC08 OTH REAS NO USC: USC NOT AVAIL-R4/2";
label variable PERSLA42 "AC08 OTH REAS NO USC: LANGUAGE-R4/2";
label variable DIFFPL42 "AC08 OTH REAS NO USC:DIFFRNT PLACES-R4/2";
label variable INSRPL42 "AC08 OTH REAS NO USC:JUST CHNGD INS-R4/2";
label variable MYSELF42 "AC08 OTH REAS NO USC:NO DOC/TRT SLF-R4/2";
label variable CARECO42 "AC08 OTH REAS NO USC:COST OF MED CR-R4/2";
label variable OTHINS42 "AC08 OTH REAS NO USC: INS RELATED-R4/2";
label variable JOBRSN42 "AC08 OTH REAS NO USC: JOB RELATED-R4/2";
label variable NEWDOC42 "AC08 OTH REAS NO USC: LOOKNG FOR DR-R4/2";
label variable DOCELS42 "AC08 OTH REAS NO USC: DR ELSEWHERE-R4/2";
label variable NOLIKE42 "AC08 OTH REAS NO USC: DONT LIKE DRS-R4/2";
label variable KNOWDR42 "AC08 OTH REAS NO USC: KNOWS/IS A DR-R4/2";
label variable NOGODR42 "AC08 OTH REAS NO USC: WONT GO TO DR-R4/2";
label variable TRANS42 "AC08 OTH REAS NO USC: TRANSPRT/TIME-R4/2";
label variable OTHREA42 "AC08 OTH REAS NO USC: OTHER REASON-R4/2";
label variable PROVTY42 "PROVIDER TYPE-R4/2";
label variable FACLPR42 "AC10 DOES PERS SEE PARTICULAR PROV-R4/2";
label variable PLCTYP42 "USC TYPE OF PLACE-R4/2";
label variable GOTOUS42 "AC12 HOW DOES PERS GET TO USC PROV-R4/2";
label variable TMTKUS42 "AC13 HOW LONG IT TAKES GET TO USC-R4/2";
label variable DFTOUS42 "AC14 HOW DIFFICULT IS IT GET TO USC-R4/2";
label variable TYPEPE42 "USC TYPE OF PROVIDER-R4/2";
label variable LOCATN42 "USC LOCATION-R4/2";
label variable HSPLAP42 "AC18 IS PROVIDER HISPANIC OR LATINO-R4/2";
label variable WHITPR42 "AC19 IS PROVIDER WHITE-R4/2";
label variable BLCKPR42 "AC19 IS PROVIDER BLACK/AFRICAN AMER-R4/2";
label variable ASIANP42 "AC19 IS PROVIDER ASIAN-R4/2";
label variable NATAMP42 "AC19 IS PROVIDER NATIVE AMERICAN-R4/2";
label variable PACISP42 "AC19 IS PROVIDER OTH PACIFIC ISLNDR-R4/2";
label variable OTHRCP42 "AC19 IS PROVIDER SOME OTHER RACE-R4/2";
label variable GENDRP42 "AC20 IS PROVIDER MALE OR FEMALE-R4/2";
label variable MINORP42 "AC22 GO TO USC FOR NEW HEALTH PROB-R4/2";
label variable PREVEN42 "AC22 GO TO USC FOR PRVNTVE HLT CARE-R4/2";
label variable REFFRL42 "AC22 GO TO USC FOR REFERRALS-R4/2";
label variable ONGONG42 "AC22 GO TO USC FOR ONGOING HLTH PRB-R4/2";
label variable PHNREG42 "AC23 HOW DIFF CONTACT USC BY PHONE-R4/2";
label variable OFFHOU42 "AC24 USC HAS OFFCE HRS NGHTS/WKENDS-R4/2";
label variable AFTHOU42 "AC25 HOW DIFF CONTACT USC AFT HOURS-R4/2";
label variable TREATM42 "AC26 PROV ASK ABOUT OTH TREATMENTS-R4/2";
label variable RESPCT42 "AC27 PROV SHOWS RESPECT FOR TRTMNTS-R4/2";
label variable DECIDE42 "AC28 PROV ASKS PERS TO HELP DECIDE-R4/2";
label variable EXPLOP42 "AC30 PROV EXPLNS OPTIONS TO PERS-R4/2";
label variable LANGPR42 "AC31 PROV SPEAKS PERSON S LANGUAGE-R4/2";
label variable MDUNAB42 "UNABLE TO GET NECESSRY MEDICAL CARE-R4/2";
label variable MDUNRS42 "AC34 RSN UNABLE GET NECSRY MED CARE-R4/2";
label variable MDUNPR42 "AC35 PRB NOT GETTING NCSRY MED CARE-R4/2";
label variable MDDLAY42 "DELAYED IN GETTING NECSRY MED CARE-R4/2";
label variable MDDLRS42 "AC38 RSN DLAYD GETTING NEC MED CARE-R4/2";
label variable MDDLPR42 "AC39 PRB DLAYD GETTING NEC MED CARE-R4/2";
label variable DNUNAB42 "UNABLE TO GET NECESSARY DENTAL CARE-R4/2";
label variable DNUNRS42 "AC42 RSN UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNUNPR42 "AC43 PRB UNABLE GET NCSRY DENT CARE-R4/2";
label variable DNDLAY42 "DELAYED IN GETTING NEC DENTAL CARE-R4/2";
label variable DNDLRS42 "AC46 RSN DLAYD GETTNG NEC DENT CARE-R4/2";
label variable DNDLPR42 "AC47 PRB DLAYD GETTNG NEC DENT CARE-R4/2";
label variable PMUNAB42 "UNABLE TO GET NECESSARY PRES MED-R4/2";
label variable PMUNRS42 "AC50 RSN UNABLE TO GET NEC PRES MED-R4/2";
label variable PMUNPR42 "AC51 PRB UNABLE TO GET NEC PRES MED-R4/2";
label variable PMDLAY42 "DELAYED IN GETTING NECSRY PRES MED-R4/2";
label variable PMDLRS42 "AC54 RSN DLAYD GETTING NEC PRES MED-R4/2";
label variable PMDLPR42 "AC55 PRB DLAYD GETTING NEC PRES MED-R4/2";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/03";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ (IMP)";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ (IMP)";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ (IMP)";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED RD 3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED RD 4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED RD 5/3";
label variable DIFFWG31 "PERSONS WAGES DIFFERENT THIS RD31 AT CMJ";
label variable DIFFWG42 "PERSONS WAGES DIFFERENT THIS RD42 AT CMJ";
label variable DIFFWG53 "PERSONS WAGES DIFFERENT THIS RD53 AT CMJ";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable TEMPJB31 "IS CMJ A TEMPORARY JOB RD 3/1";
label variable TEMPJB42 "IS CMJ A TEMPORARY JOB RD 4/2";
label variable TEMPJB53 "IS CMJ A TEMPORARY JOB RD 5/3";
label variable SSNLJB31 "IS CMJ A SEASONAL JOB RD 3/1";
label variable SSNLJB42 "IS CMJ A SEASONAL JOB RD 4/2";
label variable SSNLJB53 "IS CMJ A SEASONAL JOB RD 5/3";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT RD 3/1 CMJ (ED)";
label variable DISVW42X "DISAVOWED HEALTH INS AT RD 4/2 CMJ (ED)";
label variable DISVW53X "DISAVOWED HEALTH INS AT RD 5/3 CMJ (ED)";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable INDCAT31 "INDUSTRY GROUP RD 3/1 CMJ";
label variable INDCAT42 "INDUSTRY GROUP RD 4/2 CMJ";
label variable INDCAT53 "INDUSTRY GROUP RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable OCCCAT31 "OCCUPATION GROUP RD 3/1 CMJ";
label variable OCCCAT42 "OCCUPATION GROUP RD 4/2 CMJ";
label variable OCCCAT53 "OCCUPATION GROUP RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSUR HELD FROM RD 3/1 CMJ (ED)";
label variable HELD42X "HEALTH INSUR HELD FROM RD 4/2 CMJ (ED)";
label variable HELD53X "HEALTH INSUR HELD FROM RD 5/3 CMJ (ED)";
label variable OFFER31X "HEALTH INSUR OFFERED BY RD 3/1 CMJ (ED)";
label variable OFFER42X "HEALTH INSUR OFFERED BY RD 4/2 CMJ (ED)";
label variable OFFER53X "HEALTH INSUR OFFERED BY RD 5/3 CMJ (ED)";
label variable OFREMP31 "EMPLOYER OFFERS HEALTH INS RD 3/1 CMJ";
label variable OFREMP42 "EMPLOYER OFFERS HEALTH INS RD 4/2 CMJ";
label variable OFREMP53 "EMPLOYER OFFERS HEALTH INS RD 5/3 CMJ";
label variable YNOINS31 "WHY NOT ELIGIBLE HEALTH INS RD 3/1 CMJ";
label variable YNOINS42 "WHY NOT ELIGIBLE HEALTH INS RD 4/2 CMJ";
label variable YNOINS53 "WHY NOT ELIGIBLE HEALTH INS RD 5/3 CMJ";
label variable TRIJA03X "COVERED BY TRICARE IN JAN03 (ED)";
label variable TRIFE03X "COVERED BY TRICARE IN FEB03 (ED)";
label variable TRIMA03X "COVERED BY TRICARE IN MAR03 (ED)";
label variable TRIAP03X "COVERED BY TRICARE IN APR03 (ED)";
label variable TRIMY03X "COVERED BY TRICARE IN MAY03 (ED)";
label variable TRIJU03X "COVERED BY TRICARE IN JUN03 (ED)";
label variable TRIJL03X "COVERED BY TRICARE IN JUL03 (ED)";
label variable TRIAU03X "COVERED BY TRICARE IN AUG03 (ED)";
label variable TRISE03X "COVERED BY TRICARE IN SEP03 (ED)";
label variable TRIOC03X "COVERED BY TRICARE IN OCT03 (ED)";
label variable TRINO03X "COVERED BY TRICARE IN NOV03 (ED)";
label variable TRIDE03X "COVERED BY TRICARE IN DEC03 (ED)";
label variable MCRJA03 "COVERED BY MEDICARE IN JAN03";
label variable MCRFE03 "COVERED BY MEDICARE IN FEB03";
label variable MCRMA03 "COVERED BY MEDICARE IN MAR03";
label variable MCRAP03 "COVERED BY MEDICARE IN APR03";
label variable MCRMY03 "COVERED BY MEDICARE IN MAY03";
label variable MCRJU03 "COVERED BY MEDICARE IN JUN03";
label variable MCRJL03 "COVERED BY MEDICARE IN JUL03";
label variable MCRAU03 "COVERED BY MEDICARE IN AUG03";
label variable MCRSE03 "COVERED BY MEDICARE IN SEP03";
label variable MCROC03 "COVERED BY MEDICARE IN OCT03";
label variable MCRNO03 "COVERED BY MEDICARE IN NOV03";
label variable MCRDE03 "COVERED BY MEDICARE IN DEC03";
label variable MCRJA03X "COVERED BY MEDICARE IN JAN03 (ED)";
label variable MCRFE03X "COVERED BY MEDICARE IN FEB03 (ED)";
label variable MCRMA03X "COVERED BY MEDICARE IN MAR03 (ED)";
label variable MCRAP03X "COVERED BY MEDICARE IN APR03 (ED)";
label variable MCRMY03X "COVERED BY MEDICARE IN MAY03 (ED)";
label variable MCRJU03X "COVERED BY MEDICARE IN JUN03 (ED)";
label variable MCRJL03X "COVERED BY MEDICARE IN JUL03 (ED)";
label variable MCRAU03X "COVERED BY MEDICARE IN AUG03 (ED)";
label variable MCRSE03X "COVERED BY MEDICARE IN SEP03 (ED)";
label variable MCROC03X "COVERED BY MEDICARE IN OCT03 (ED)";
label variable MCRNO03X "COVERED BY MEDICARE IN NOV03 (ED)";
label variable MCRDE03X "COVERED BY MEDICARE IN DEC03 (ED)";
label variable MCDJA03 "COV BY MEDICAID OR SCHIP IN JAN03";
label variable MCDFE03 "COV BY MEDICAID OR SCHIP IN FEB03";
label variable MCDMA03 "COV BY MEDICAID OR SCHIP IN MAR03";
label variable MCDAP03 "COV BY MEDICAID OR SCHIP IN APR03";
label variable MCDMY03 "COV BY MEDICAID OR SCHIP IN MAY03";
label variable MCDJU03 "COV BY MEDICAID OR SCHIP IN JUN03";
label variable MCDJL03 "COV BY MEDICAID OR SCHIP IN JUL03";
label variable MCDAU03 "COV BY MEDICAID OR SCHIP IN AUG03";
label variable MCDSE03 "COV BY MEDICAID OR SCHIP IN SEP03";
label variable MCDOC03 "COV BY MEDICAID OR SCHIP IN OCT03";
label variable MCDNO03 "COV BY MEDICAID OR SCHIP IN NOV03";
label variable MCDDE03 "COV BY MEDICAID OR SCHIP IN DEC03";
label variable MCDJA03X "COV BY MEDICAID OR SCHIP IN JAN03 (ED)";
label variable MCDFE03X "COV BY MEDICAID OR SCHIP IN FEB03 (ED)";
label variable MCDMA03X "COV BY MEDICAID OR SCHIP IN MAR03 (ED)";
label variable MCDAP03X "COV BY MEDICAID OR SCHIP IN APR03 (ED)";
label variable MCDMY03X "COV BY MEDICAID OR SCHIP IN MAY03 (ED)";
label variable MCDJU03X "COV BY MEDICAID OR SCHIP IN JUN03 (ED)";
label variable MCDJL03X "COV BY MEDICAID OR SCHIP IN JUL03 (ED)";
label variable MCDAU03X "COV BY MEDICAID OR SCHIP IN AUG03 (ED)";
label variable MCDSE03X "COV BY MEDICAID OR SCHIP IN SEP03 (ED)";
label variable MCDOC03X "COV BY MEDICAID OR SCHIP IN OCT03 (ED)";
label variable MCDNO03X "COV BY MEDICAID OR SCHIP IN NOV03 (ED)";
label variable MCDDE03X "COV BY MEDICAID OR SCHIP IN DEC03 (ED)";
label variable OPAJA03 "COV BY OTHER PUBLIC A INS IN JAN03";
label variable OPAFE03 "COV BY OTHER PUBLIC A INS IN FEB03";
label variable OPAMA03 "COV BY OTHER PUBLIC A INS IN MAR03";
label variable OPAAP03 "COV BY OTHER PUBLIC A INS IN APR03";
label variable OPAMY03 "COV BY OTHER PUBLIC A INS IN MAY03";
label variable OPAJU03 "COV BY OTHER PUBLIC A INS IN JUN03";
label variable OPAJL03 "COV BY OTHER PUBLIC A INS IN JUL03";
label variable OPAAU03 "COV BY OTHER PUBLIC A INS IN AUG03";
label variable OPASE03 "COV BY OTHER PUBLIC A INS IN SEP03";
label variable OPAOC03 "COV BY OTHER PUBLIC A INS IN OCT03";
label variable OPANO03 "COV BY OTHER PUBLIC A INS IN NOV03";
label variable OPADE03 "COV BY OTHER PUBLIC A INS IN DEC03";
label variable OPBJA03 "COV BY OTHER PUBLIC B INS IN JAN03";
label variable OPBFE03 "COV BY OTHER PUBLIC B INS IN FEB03";
label variable OPBMA03 "COV BY OTHER PUBLIC B INS IN MAR03";
label variable OPBAP03 "COV BY OTHER PUBLIC B INS IN APR03";
label variable OPBMY03 "COV BY OTHER PUBLIC B INS IN MAY03";
label variable OPBJU03 "COV BY OTHER PUBLIC B INS IN JUN03";
label variable OPBJL03 "COV BY OTHER PUBLIC B INS IN JUL03";
label variable OPBAU03 "COV BY OTHER PUBLIC B INS IN AUG03";
label variable OPBSE03 "COV BY OTHER PUBLIC B INS IN SEP03";
label variable OPBOC03 "COV BY OTHER PUBLIC B INS IN OCT03";
label variable OPBNO03 "COV BY OTHER PUBLIC B INS IN NOV03";
label variable OPBDE03 "COV BY OTHER PUBLIC B INS IN DEC03";
label variable STAJA03 "COVERED BY OTHER STATE PROG IN JAN03";
label variable STAFE03 "COVERED BY OTHER STATE PROG IN FEB03";
label variable STAMA03 "COVERED BY OTHER STATE PROG IN MAR03";
label variable STAAP03 "COVERED BY OTHER STATE PROG IN APR03";
label variable STAMY03 "COVERED BY OTHER STATE PROG IN MAY03";
label variable STAJU03 "COVERED BY OTHER STATE PROG IN JUN03";
label variable STAJL03 "COVERED BY OTHER STATE PROG IN JUL03";
label variable STAAU03 "COVERED BY OTHER STATE PROG IN AUG03";
label variable STASE03 "COVERED BY OTHER STATE PROG IN SEP03";
label variable STAOC03 "COVERED BY OTHER STATE PROG IN OCT03";
label variable STANO03 "COVERED BY OTHER STATE PROG IN NOV03";
label variable STADE03 "COVERED BY OTHER STATE PROG IN DEC03";
label variable PUBJA03X "COVR BY ANY PUBLIC INS IN JAN03 (ED)";
label variable PUBFE03X "COVR BY ANY PUBLIC INS IN FEB03 (ED)";
label variable PUBMA03X "COVR BY ANY PUBLIC INS IN MAR03 (ED)";
label variable PUBAP03X "COVR BY ANY PUBLIC INS IN APR03 (ED)";
label variable PUBMY03X "COVR BY ANY PUBLIC INS IN MAY03 (ED)";
label variable PUBJU03X "COVR BY ANY PUBLIC INS IN JUN03 (ED)";
label variable PUBJL03X "COVR BY ANY PUBLIC INS IN JUL03 (ED)";
label variable PUBAU03X "COVR BY ANY PUBLIC INS IN AUG03 (ED)";
label variable PUBSE03X "COVR BY ANY PUBLIC INS IN SEP03 (ED)";
label variable PUBOC03X "COVR BY ANY PUBLIC INS IN OCT03 (ED)";
label variable PUBNO03X "COVR BY ANY PUBLIC INS IN NOV03 (ED)";
label variable PUBDE03X "COVR BY ANY PUBLIC INS IN DEC03 (ED)";
label variable PEGJA03 "COVERED BY EMPL UNION INS IN JAN03";
label variable PEGFE03 "COVERED BY EMPL UNION INS IN FEB03";
label variable PEGMA03 "COVERED BY EMPL UNION INS IN MAR03";
label variable PEGAP03 "COVERED BY EMPL UNION INS IN APR03";
label variable PEGMY03 "COVERED BY EMPL UNION INS IN MAY03";
label variable PEGJU03 "COVERED BY EMPL UNION INS IN JUN03";
label variable PEGJL03 "COVERED BY EMPL UNION INS IN JUL03";
label variable PEGAU03 "COVERED BY EMPL UNION INS IN AUG03";
label variable PEGSE03 "COVERED BY EMPL UNION INS IN SEP03";
label variable PEGOC03 "COVERED BY EMPL UNION INS IN OCT03";
label variable PEGNO03 "COVERED BY EMPL UNION INS IN NOV03";
label variable PEGDE03 "COVERED BY EMPL UNION INS IN DEC03";
label variable PDKJA03 "COVR BY PRIV INS (SOURCE UNKNWN) JAN03";
label variable PDKFE03 "COVR BY PRIV INS (SOURCE UNKNWN) FEB03";
label variable PDKMA03 "COVR BY PRIV INS (SOURCE UNKNWN) MAR03";
label variable PDKAP03 "COVR BY PRIV INS (SOURCE UNKNWN) APR03";
label variable PDKMY03 "COVR BY PRIV INS (SOURCE UNKNWN) MAY03";
label variable PDKJU03 "COVR BY PRIV INS (SOURCE UNKNWN) JUN03";
label variable PDKJL03 "COVR BY PRIV INS (SOURCE UNKNWN) JUL03";
label variable PDKAU03 "COVR BY PRIV INS (SOURCE UNKNWN) AUG03";
label variable PDKSE03 "COVR BY PRIV INS (SOURCE UNKNWN) SEP03";
label variable PDKOC03 "COVR BY PRIV INS (SOURCE UNKNWN) OCT03";
label variable PDKNO03 "COVR BY PRIV INS (SOURCE UNKNWN) NOV03";
label variable PDKDE03 "COVR BY PRIV INS (SOURCE UNKNWN) DEC03";
label variable PNGJA03 "COVERED BY NONGROUP INS IN JAN03";
label variable PNGFE03 "COVERED BY NONGROUP INS IN FEB03";
label variable PNGMA03 "COVERED BY NONGROUP INS IN MAR03";
label variable PNGAP03 "COVERED BY NONGROUP INS IN APR03";
label variable PNGMY03 "COVERED BY NONGROUP INS IN MAY03";
label variable PNGJU03 "COVERED BY NONGROUP INS IN JUN03";
label variable PNGJL03 "COVERED BY NONGROUP INS IN JUL03";
label variable PNGAU03 "COVERED BY NONGROUP INS IN AUG03";
label variable PNGSE03 "COVERED BY NONGROUP INS IN SEP03";
label variable PNGOC03 "COVERED BY NONGROUP INS IN OCT03";
label variable PNGNO03 "COVERED BY NONGROUP INS IN NOV03";
label variable PNGDE03 "COVERED BY NONGROUP INS IN DEC03";
label variable POGJA03 "COVERED BY OTHER GROUP INS IN JAN03";
label variable POGFE03 "COVERED BY OTHER GROUP INS IN FEB03";
label variable POGMA03 "COVERED BY OTHER GROUP INS IN MAR03";
label variable POGAP03 "COVERED BY OTHER GROUP INS IN APR03";
label variable POGMY03 "COVERED BY OTHER GROUP INS IN MAY03";
label variable POGJU03 "COVERED BY OTHER GROUP INS IN JUN03";
label variable POGJL03 "COVERED BY OTHER GROUP INS IN JUL03";
label variable POGAU03 "COVERED BY OTHER GROUP INS IN AUG03";
label variable POGSE03 "COVERED BY OTHER GROUP INS IN SEP03";
label variable POGOC03 "COVERED BY OTHER GROUP INS IN OCT03";
label variable POGNO03 "COVERED BY OTHER GROUP INS IN NOV03";
label variable POGDE03 "COVERED BY OTHER GROUP INS IN DEC03";
label variable PRSJA03 "COVERED BY SELF-EMP-1 INS IN JAN03";
label variable PRSFE03 "COVERED BY SELF-EMP-1 INS IN FEB03";
label variable PRSMA03 "COVERED BY SELF-EMP-1 INS IN MAR03";
label variable PRSAP03 "COVERED BY SELF-EMP-1 INS IN APR03";
label variable PRSMY03 "COVERED BY SELF-EMP-1 INS IN MAY03";
label variable PRSJU03 "COVERED BY SELF-EMP-1 INS IN JUN03";
label variable PRSJL03 "COVERED BY SELF-EMP-1 INS IN JUL03";
label variable PRSAU03 "COVERED BY SELF-EMP-1 INS IN AUG03";
label variable PRSSE03 "COVERED BY SELF-EMP-1 INS IN SEP03";
label variable PRSOC03 "COVERED BY SELF-EMP-1 INS IN OCT03";
label variable PRSNO03 "COVERED BY SELF-EMP-1 INS IN NOV03";
label variable PRSDE03 "COVERED BY SELF-EMP-1 INS IN DEC03";
label variable POUJA03 "COVERED BY HOLDER OUTSIDE OF RU IN JAN03";
label variable POUFE03 "COVERED BY HOLDER OUTSIDE OF RU IN FEB03";
label variable POUMA03 "COVERED BY HOLDER OUTSIDE OF RU IN MAR03";
label variable POUAP03 "COVERED BY HOLDER OUTSIDE OF RU IN APR03";
label variable POUMY03 "COVERED BY HOLDER OUTSIDE OF RU IN MAY03";
label variable POUJU03 "COVERED BY HOLDER OUTSIDE OF RU IN JUN03";
label variable POUJL03 "COVERED BY HOLDER OUTSIDE OF RU IN JUL03";
label variable POUAU03 "COVERED BY HOLDER OUTSIDE OF RU IN AUG03";
label variable POUSE03 "COVERED BY HOLDER OUTSIDE OF RU IN SEP03";
label variable POUOC03 "COVERED BY HOLDER OUTSIDE OF RU IN OCT03";
label variable POUNO03 "COVERED BY HOLDER OUTSIDE OF RU IN NOV03";
label variable POUDE03 "COVERED BY HOLDER OUTSIDE OF RU IN DEC03";
label variable PRIJA03 "COVERED BY PRIVATE INS IN JAN03";
label variable PRIFE03 "COVERED BY PRIVATE INS IN FEB03";
label variable PRIMA03 "COVERED BY PRIVATE INS IN MAR03";
label variable PRIAP03 "COVERED BY PRIVATE INS IN APR03";
label variable PRIMY03 "COVERED BY PRIVATE INS IN MAY03";
label variable PRIJU03 "COVERED BY PRIVATE INS IN JUN03";
label variable PRIJL03 "COVERED BY PRIVATE INS IN JUL03";
label variable PRIAU03 "COVERED BY PRIVATE INS IN AUG03";
label variable PRISE03 "COVERED BY PRIVATE INS IN SEP03";
label variable PRIOC03 "COVERED BY PRIVATE INS IN OCT03";
label variable PRINO03 "COVERED BY PRIVATE INS IN NOV03";
label variable PRIDE03 "COVERED BY PRIVATE INS IN DEC03";
label variable HPEJA03 "HOLDER OF EMPL UNION INS IN JAN03";
label variable HPEFE03 "HOLDER OF EMPL UNION INS IN FEB03";
label variable HPEMA03 "HOLDER OF EMPL UNION INS IN MAR03";
label variable HPEAP03 "HOLDER OF EMPL UNION INS IN APR03";
label variable HPEMY03 "HOLDER OF EMPL UNION INS IN MAY03";
label variable HPEJU03 "HOLDER OF EMPL UNION INS IN JUN03";
label variable HPEJL03 "HOLDER OF EMPL UNION INS IN JUL03";
label variable HPEAU03 "HOLDER OF EMPL UNION INS IN AUG03";
label variable HPESE03 "HOLDER OF EMPL UNION INS IN SEP03";
label variable HPEOC03 "HOLDER OF EMPL UNION INS IN OCT03";
label variable HPENO03 "HOLDER OF EMPL UNION INS IN NOV03";
label variable HPEDE03 "HOLDER OF EMPL UNION INS IN DEC03";
label variable HPDJA03 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN03";
label variable HPDFE03 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB03";
label variable HPDMA03 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR03";
label variable HPDAP03 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR03";
label variable HPDMY03 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY03";
label variable HPDJU03 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN03";
label variable HPDJL03 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL03";
label variable HPDAU03 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG03";
label variable HPDSE03 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP03";
label variable HPDOC03 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT03";
label variable HPDNO03 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV03";
label variable HPDDE03 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC03";
label variable HPNJA03 "HOLDER OF NONGROUP INS IN JAN03";
label variable HPNFE03 "HOLDER OF NONGROUP INS IN FEB03";
label variable HPNMA03 "HOLDER OF NONGROUP INS IN MAR03";
label variable HPNAP03 "HOLDER OF NONGROUP INS IN APR03";
label variable HPNMY03 "HOLDER OF NONGROUP INS IN MAY03";
label variable HPNJU03 "HOLDER OF NONGROUP INS IN JUN03";
label variable HPNJL03 "HOLDER OF NONGROUP INS IN JUL03";
label variable HPNAU03 "HOLDER OF NONGROUP INS IN AUG03";
label variable HPNSE03 "HOLDER OF NONGROUP INS IN SEP03";
label variable HPNOC03 "HOLDER OF NONGROUP INS IN OCT03";
label variable HPNNO03 "HOLDER OF NONGROUP INS IN NOV03";
label variable HPNDE03 "HOLDER OF NONGROUP INS IN DEC03";
label variable HPOJA03 "HOLDER OF OTHER GROUP INS IN JAN03";
label variable HPOFE03 "HOLDER OF OTHER GROUP INS IN FEB03";
label variable HPOMA03 "HOLDER OF OTHER GROUP INS IN MAR03";
label variable HPOAP03 "HOLDER OF OTHER GROUP INS IN APR03";
label variable HPOMY03 "HOLDER OF OTHER GROUP INS IN MAY03";
label variable HPOJU03 "HOLDER OF OTHER GROUP INS IN JUN03";
label variable HPOJL03 "HOLDER OF OTHER GROUP INS IN JUL03";
label variable HPOAU03 "HOLDER OF OTHER GROUP INS IN AUG03";
label variable HPOSE03 "HOLDER OF OTHER GROUP INS IN SEP03";
label variable HPOOC03 "HOLDER OF OTHER GROUP INS IN OCT03";
label variable HPONO03 "HOLDER OF OTHER GROUP INS IN NOV03";
label variable HPODE03 "HOLDER OF OTHER GROUP INS IN DEC03";
label variable HPSJA03 "HOLDER OF SELF-EMP-1 INS IN JAN03";
label variable HPSFE03 "HOLDER OF SELF-EMP-1 INS IN FEB03";
label variable HPSMA03 "HOLDER OF SELF-EMP-1 INS IN MAR03";
label variable HPSAP03 "HOLDER OF SELF-EMP-1 INS IN APR03";
label variable HPSMY03 "HOLDER OF SELF-EMP-1 INS IN MAY03";
label variable HPSJU03 "HOLDER OF SELF-EMP-1 INS IN JUN03";
label variable HPSJL03 "HOLDER OF SELF-EMP-1 INS IN JUL03";
label variable HPSAU03 "HOLDER OF SELF-EMP-1 INS IN AUG03";
label variable HPSSE03 "HOLDER OF SELF-EMP-1 INS IN SEP03";
label variable HPSOC03 "HOLDER OF SELF-EMP-1 INS IN OCT03";
label variable HPSNO03 "HOLDER OF SELF-EMP-1 INS IN NOV03";
label variable HPSDE03 "HOLDER OF SELF-EMP-1 INS IN DEC03";
label variable HPRJA03 "HOLDER OF PRIVATE INSURANCE IN JAN03";
label variable HPRFE03 "HOLDER OF PRIVATE INSURANCE IN FEB03";
label variable HPRMA03 "HOLDER OF PRIVATE INSURANCE IN MAR03";
label variable HPRAP03 "HOLDER OF PRIVATE INSURANCE IN APR03";
label variable HPRMY03 "HOLDER OF PRIVATE INSURANCE IN MAY03";
label variable HPRJU03 "HOLDER OF PRIVATE INSURANCE IN JUN03";
label variable HPRJL03 "HOLDER OF PRIVATE INSURANCE IN JUL03";
label variable HPRAU03 "HOLDER OF PRIVATE INSURANCE IN AUG03";
label variable HPRSE03 "HOLDER OF PRIVATE INSURANCE IN SEP03";
label variable HPROC03 "HOLDER OF PRIVATE INSURANCE IN OCT03";
label variable HPRNO03 "HOLDER OF PRIVATE INSURANCE IN NOV03";
label variable HPRDE03 "HOLDER OF PRIVATE INSURANCE IN DEC03";
label variable INSJA03X "COVR BY HOSP/MED INS IN JAN03 (ED)";
label variable INSFE03X "COVR BY HOSP/MED INS IN FEB03 (ED)";
label variable INSMA03X "COVR BY HOSP/MED INS IN MAR03 (ED)";
label variable INSAP03X "COVR BY HOSP/MED INS IN APR03 (ED)";
label variable INSMY03X "COVR BY HOSP/MED INS IN MAY03 (ED)";
label variable INSJU03X "COVR BY HOSP/MED INS IN JUN03 (ED)";
label variable INSJL03X "COVR BY HOSP/MED INS IN JUL03 (ED)";
label variable INSAU03X "COVR BY HOSP/MED INS IN AUG03 (ED)";
label variable INSSE03X "COVR BY HOSP/MED INS IN SEP03 (ED)";
label variable INSOC03X "COVR BY HOSP/MED INS IN OCT03 (ED)";
label variable INSNO03X "COVR BY HOSP/MED INS IN NOV03 (ED)";
label variable INSDE03X "COVR BY HOSP/MED INS IN DEC03 (ED)";
label variable PRVEV03 "EVER HAVE PRIVATE INSURANCE DURING 03";
label variable TRIEV03 "EVER HAVE TRICARE DURING 03";
label variable MCREV03 "EVER HAVE MEDICARE DURING 03 (ED)";
label variable MCDEV03 "EVER HAVE MEDICAID/SCHIP DURING 03 (ED)";
label variable OPAEV03 "EVER HAVE OTHER PUBLIC A INS DURING 03";
label variable OPBEV03 "EVER HAVE OTHER PUBLIC B INS DURING 03";
label variable UNINS03 "UNINSURED ALL OF 03";
label variable INSCOV03 "HEALTH INSURANCE COVERAGE INDICATOR 03";
label variable TRIST31X "COVERED BY TRICARE STANDARD - R3/1";
label variable TRIST42X "COVERED BY TRICARE STANDARD - R4/2";
label variable TRIST03X "COVERED BY TRICARE STANDARD - 12/31/03";
label variable TRIPR31X "COVERED BY TRICARE PRIME - R3/1";
label variable TRIPR42X "COVERED BY TRICARE PRIME - R4/2";
label variable TRIPR03X "COVERED BY TRICARE PRIME - 12/31/03";
label variable TRIEX31X "COVERED BY TRICARE EXTRA - R3/1";
label variable TRIEX42X "COVERED BY TRICARE EXTRA - R4/2";
label variable TRIEX03X "COVERED BY TRICARE EXTRA - 12/31/03";
label variable TRILI42X "COVERED BY TRICARE FOR LIFE - R4/2";
label variable TRILI03X "COVERED BY TRICARE FOR LIFE - 12/31/03";
label variable MCDHMO31 "COVERED BY MEDICAID OR SCHIP HMO - R3/1";
label variable MCDHMO42 "COVERED BY MEDICAID OR SCHIP HMO - R4/2";
label variable MCDHMO03 "COVRED BY MEDICAID OR SCHIP HMO-12/31/03";
label variable MCDMC31 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R3/1";
label variable MCDMC42 "COV BY MCAID/SCHIP GATEKEEPER PLAN-R4/2";
label variable MCDMC03 "COV BY MCAID/SCHIP GTKEEPR PLAN-12/31/03";
label variable PRVHMO31 "COVERED BY PRIVATE HMO - R3/1";
label variable PRVHMO42 "COVERED BY PRIVATE HMO - R4/2";
label variable PRVHMO03 "COVERED BY PRIVATE HMO - 12/31/03";
label variable PRVMNC31 "COVERED BY PRIVATE GATEKEEPER PLAN-R3/1";
label variable PRVMNC42 "COVERED BY PRIVATE GATEKEEPER PLAN-R4/2";
label variable PRVMNC03 "COVERED BY PRIV GATEKEEPER PLAN-12/31/03";
label variable PRVDRL31 "COV BY PRIV PLAN W/DOCTOR LIST - R3/1";
label variable PRVDRL42 "COV BY PRIV PLAN W/DOCTOR LIST - R4/2";
label variable PRVDRL03 "COV BY PRIV PLAN W/DOCTOR LIST-12/31/03";
label variable PHMONP31 "COV BY HMO-PAYS NON-PLAN DR VISITS-R3/1";
label variable PHMONP42 "COV BY HMO-PAYS NON-PLAN DR VISITS-R4/2";
label variable PHMONP03 "COV BY HMO-PAYS NON-PLAN DRS - 12/31/03";
label variable PMNCNP31 "COV BY GATEKPR-PAYS NON-PLAN DRS-R3/1";
label variable PMNCNP42 "COV BY GATEKPR-PAYS NON-PLAN DRS-R4/2";
label variable PMNCNP03 "COV BY GATEKP-PAYS NON-PLAN DRS-12/31/03";
label variable PRDRNP31 "COV BY DR LIST-PAYS NON-PLAN DRS-R3/1";
label variable PRDRNP42 "COV BY DR LIST-PAYS NON-PLAN DRS-R4/2";
label variable PRDRNP03 "COV BY DR LIST-PAYS NON-PLAN DR-12/31/03";
label variable PREVCOVR "PER COV BY INS IN PREV 2 YRS-PANL 8 ONLY";
label variable COVRMM "MONTH MOST RECENTLY COVERED-PANEL 8 ONLY";
label variable COVRYY "YEAR MOST RECENTLY COVERED-PANEL 8 ONLY";
label variable WASESTB "WAS PREV INS BY EMPL OR UNION-PNL 8 ONLY";
label variable WASMCARE "WAS PREV INS BY MEDICARE-PANEL 8 ONLY";
label variable WASMCAID "WAS PREV INS BY MCAID/SCHIP-PANEL 8 ONLY";
label variable WASCHAMP "WAS PREV INS TRICARE/CHAMPVA-PANL 8 ONLY";
label variable WASVA "WAS PREV INS VA/MILITAR CARE-PANL 8 ONLY";
label variable WASPRIV "WAS PREV INS GRP/ASSOC/INS CO-PNL 8 ONLY";
label variable WASOTGOV "WAS PREV INS BY OTH GOV PRG-PANEL 8 ONLY";
label variable WASAFDC "WAS PREV INS BY PUBLIC AFDC-PANEL 8 ONLY";
label variable WASSSI "WAS PREV INS BY SSI PROGRAM-PANEL 8 ONLY";
label variable WASSTAT1 "WAS PREV INS BY STAT PROG 1-PANEL 8 ONLY";
label variable WASSTAT2 "WAS PREV INS BY STAT PROG 2-PANEL 8 ONLY";
label variable WASSTAT3 "WAS PREV INS BY STAT PROG 3-PANEL 8 ONLY";
label variable WASSTAT4 "WAS PREV INS BY STAT PROG 4-PANEL 8 ONLY";
label variable WASOTHER "WAS PREV INS BY OTH SOURCE-PANEL 8 ONLY";
label variable NOINSBEF "EVR WOUT HLTH INSR PREV YR-PANEL 8 ONLY";
label variable NOINSTM "# WKS/MON WOUT HLTH INS PRV YR-PNL 8 ONL";
label variable NOINUNIT "UNIT OF TIME WOUT HLTH INS-PANEL 8 ONLY";
label variable MORECOVR "COV BY MOR COMPR PL PREV 2 YR-PNL 8 ONLY";
label variable INSENDMM "MONTH MOST RECENTLY COVD-PANEL 8 ONLY";
label variable INSENDYY "YEAR MOST RECENTLY COVD-PANEL 8 ONLY";
label variable TRICR31X "COV BY TRICARE - R3/1 INT DT (ED)";
label variable TRICR42X "COV BY TRICARE - R4/2 INT DT (ED)";
label variable TRICR53X "COV BY TRICARE 12-31/R3 INT DT (ED)";
label variable TRICR03X "COV BY TRICARE - 12/31/03 (ED)";
label variable TRIAT31X "ANY TIME COV TRICARE - R3/1";
label variable TRIAT42X "ANY TIME COV TRICARE - R4/2";
label variable TRIAT53X "ANY TIME COV TRICARE - R5/3";
label variable TRIAT03X "ANY TIME COV TRICARE - 12/31/03";
label variable MCAID31 "COV BY MEDICAID OR SCHIP - R3/1 INT DT";
label variable MCAID42 "COV BY MEDICAID OR SCHIP - R4/2 INT DT";
label variable MCAID53 "COV BY MEDICAID OR SCHIP 12-31/R3 INT DT";
label variable MCAID03 "COV BY MEDICAID OR SCHIP - 12/31/03";
label variable MCAID31X "COV BY MEDICAID/SCHIP - R3/1 INT DT (ED)";
label variable MCAID42X "COV BY MEDICAID/SCHIP - R4/2 INT DT (ED)";
label variable MCAID53X "COV MEDICAID/SCHIP 12-31/R3 INT DT(ED)";
label variable MCAID03X "COV BY MEDICAID OR SCHIP - 12/31/03 (ED)";
label variable MCARE31 "COV BY MEDICARE - R3/1 INT DT";
label variable MCARE42 "COV BY MEDICARE - R4/2 INT DT";
label variable MCARE53 "COV BY MEDICARE 12-31/R3 INT DT";
label variable MCARE03 "COV BY MEDICARE - 12/31/03";
label variable MCARE31X "COV BY MEDICARE - R3/1 INT DT (ED)";
label variable MCARE42X "COV BY MEDICARE - R4/2 INT DT (ED)";
label variable MCARE53X "COV BY MEDICARE 12-31/R3 INT DT (ED)";
label variable MCARE03X "COV BY MEDICARE - 12/31/03 (ED)";
label variable MCDAT31X "ANY TIME COV MEDICAID OR SCHIP - R3/1";
label variable MCDAT42X "ANY TIME COV MEDICAID OR SCHIP - R4/2";
label variable MCDAT53X "ANY TIME COV MEDICAID OR SCHIP - R5/3";
label variable MCDAT03X "ANY TIME COV MEDICAID OR SCHIP-12/31/03";
label variable OTPAAT31 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R3/1";
label variable OTPAAT42 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R4/2";
label variable OTPAAT53 "ANY TIME COV OT GOV MCAID/SCHIP HMO-R5/3";
label variable OTPAAT03 "ANY COV OT GOV MCAID/SCHIP HMO-12/31/03";
label variable OTPBAT31 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R3/1";
label variable OTPBAT42 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R4/2";
label variable OTPBAT53 "ANY COV OT GOV NOT MCAID/SCHIP HMO-R5/3";
label variable OTPBAT03 "ANY CV OT GV NT MCAID/SCHIP HMO-12/31/03";
label variable OTPUBA31 "COV/PAY OTH GOV MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBA42 "COV/PAY OTH GOV MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBA53 "COV/PAY OTH GOV MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBA03 "COV/PAY OTH GOV MCAID/SCHIP HMO-12/31/03";
label variable OTPUBB31 "COV OTH GOV NOT MCAID/SCHIP HMO-R3/1 INT";
label variable OTPUBB42 "COV OTH GOV NOT MCAID/SCHIP HMO-R4/2 INT";
label variable OTPUBB53 "COV OTH GOV NOT MCAID/SCHIP HMO 12-31/R3";
label variable OTPUBB03 "COV OTH GOV NOT MCAID/SCHIP HMO-12/31/03";
label variable PRIDK31 "COV BY PRIV INS (DK PLAN) - R3/1 INT";
label variable PRIDK42 "COV BY PRIV INS (DK PLAN) - R4/2 INT";
label variable PRIDK53 "COV BY PRIV INS (DK PLAN) 12-31/R3 INT";
label variable PRIDK03 "COV BY PRIV INS (DK PLAN) - 12/31/03";
label variable PRIEU31 "COV BY EMPL/UNION GRP INS - R3/1 INT DT";
label variable PRIEU42 "COV BY EMPL/UNION GRP INS - R4/2 INT DT";
label variable PRIEU53 "COV BY EMPL/UNION GRP INS 12-31/R3 INT";
label variable PRIEU03 "COV BY EMPL/UNION GRP INS - 12/31/03";
label variable PRING31 "COV BY NON-GROUP INS - R3/1 INT DT";
label variable PRING42 "COV BY NON-GROUP INS - R4/2 INT DT";
label variable PRING53 "COV BY NON-GROUP INS 12-31/R3 INT DT";
label variable PRING03 "COV BY NON-GROUP INS - 12/31/03";
label variable PRIOG31 "COV BY OTHER GROUP INS - R3/1 INT DT";
label variable PRIOG42 "COV BY OTHER GROUP INS - R4/2 INT DT";
label variable PRIOG53 "COV BY OTHER GROUP INS 12-31/R3 INT DT";
label variable PRIOG03 "COV BY OTHER GROUP INS - 12/31/03";
label variable PRIS31 "COV BY SELF-EMP-1 INS - R3/1 INT DT";
label variable PRIS42 "COV BY SELF-EMP-1 INS - R4/2 INT DT";
label variable PRIS53 "COV BY SELF-EMP-1 INS 12-31/R3 INT DT";
label variable PRIS03 "COV BY SELF-EMP-1 INS - 12/31/03";
label variable PRIV31 "COV BY PRIV HLTH INS - R3/1 INT DATE";
label variable PRIV42 "COV BY PRIV HLTH INS - R4/2 INT DATE";
label variable PRIV53 "COV BY PRIV HLTH INS 12-31/R3 INT DATE";
label variable PRIV03 "COV BY PRIV HLTH INS - 12/31/03";
label variable PRIVAT31 "ANY TIME COV PRIVATE INS - R3/1";
label variable PRIVAT42 "ANY TIME COV PRIVATE INS - R4/2";
label variable PRIVAT53 "ANY TIME COV PRIVATE INS - R5/3";
label variable PRIVAT03 "ANY TIME COV PRIVATE INS - 12/31/03";
label variable PROUT31 "COV BY SOMEONE OUT OF RU - R3/1 INT";
label variable PROUT42 "COV BY SOMEONE OUT OF RU - R4/2 INT";
label variable PROUT53 "COV BY SOMEONE OUT OF RU 12-31/R3 INT DT";
label variable PROUT03 "COV BY SOMEONE OUT OF RU - 12/31/03";
label variable PUB31X "COV BY PUBLIC INS - R3/1 INT DT (ED)";
label variable PUB42X "COV BY PUBLIC INS - R4/2 INT DT (ED)";
label variable PUB53X "COV BY PUBLIC INS 12-31/R3 INT DT (ED)";
label variable PUB03X "COV BY PUBLIC INS - 12/31/03 (ED)";
label variable PUBAT31X "ANY TIME COV BY PUBLIC - R3/1";
label variable PUBAT42X "ANY TIME COV BY PUBLIC - R4/2";
label variable PUBAT53X "ANY TIME COV BY PUBLIC - R5/3";
label variable PUBAT03X "ANY TIME COV BY PUBLIC - 12/31/03";
label variable INS31X "INSURED - R3/1 INT DATE (ED)";
label variable INS42X "INSURED - R4/2 INT DATE (ED)";
label variable INS53X "INSURED 12-31/R3 INT DATE (ED)";
label variable INS03X "INSURED - 12/31/03 (ED)";
label variable INSAT31X "INSURED ANY TIME IN R3/1";
label variable INSAT42X "INSURED ANY TIME IN R4/2";
label variable INSAT53X "INSURED ANY TIME IN R5/3";
label variable INSAT03X "INSURED ANY TIME IN R3 UNTIL 12/31/03/R5";
label variable STAPR31 "COV BY STATE-SPEC PROG - R3/1 INT DT";
label variable STAPR42 "COV BY STATE-SPEC PROG - R4/2 INT DT";
label variable STAPR53 "COV BY STATE-SPEC PROG 12-31/R3 INT DT";
label variable STAPR03 "COV BY STATE-SPEC PROG - 12/31/03";
label variable STPRAT31 "ANY TIME COVERAGE BY STATE INS - R3/1";
label variable STPRAT42 "ANY TIME COVERAGE BY STATE INS - R4/2";
label variable STPRAT53 "ANY TIME COVERAGE BY STATE INS - R5/3";
label variable STPRAT03 "ANY TIME COV BY STATE INS - 12/31/03";
label variable EVRUNINS "EVER UNINSURED IN 03 USING PRIV/PUBX";
label variable EVRUNAT "EVER UNINSURED IN 03 USING PRIVAT/PUBATX";
label variable DENTIN31 "DENTAL INSURANCE - RD 3/1";
label variable DENTIN42 "DENTAL INSURANCE - RD 4/2";
label variable DENTIN53 "DENTAL INSURANCE - RD 5/3";
label variable PMEDIN31 "PRESCRIPTION DRUG INSURANCE - RD 3/1";
label variable PMEDIN42 "PRESCRIPTION DRUG INSURANCE - RD 4/2";
label variable PMEDIN53 "PRESCRIPTION DRUG INSURANCE - RD 5/3";
label variable GDCPBM42 "MCAID/O PUB: PROB GETTING PERS DOC-R4/2";
label variable APRTRM42 "MCAID/O PUB: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLM42 "MCAID/O PUB: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFM42 "MCAID/O PUB: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFM42 "MCAID/O PUB: PROBLEM FINDING INFO-R4/2";
label variable CSTSVM42 "MCAID/O PUB: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCM42 "MCAID/O PUB: PROB GET HELP FR CSRVC-R4/2";
label variable PPRWKM42 "MCAID/O PUB:FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKM42 "MCAID/O PUB: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNM42 "MCAID/O PUB: RATE EXPERIENCE W PLAN-R4/2";
label variable GDCPBT42 "TRICARE: PROB GETTING PERS DOC-R4/2";
label variable APRTRT42 "TRICARE: NEED APPRVL 4 TREATMNT-R4/2";
label variable APRDLT42 "TRICARE: DELAY WAITING 4 APPRVL-R4/2";
label variable LKINFT42 "TRICARE: INFO ON HOW PLAN WORKS-R4/2";
label variable PBINFT42 "TRICARE: PROBLEM FINDING INFO-R4/2";
label variable CSTSVT42 "TRICARE: CALL CUSTOMER SERVICE-R4/2";
label variable PBSVCT42 "TRICARE: PROB GET HELP FR CST SRVC-R4/2";
label variable PPRWKT42 "TRICARE: FILL OUT PAPERWRK 4 PLN-R4/2";
label variable PBPWKT42 "TRICARE: PROB W PLAN PAPERWORK-R4/2";
label variable RTPLNT42 "TRICARE: RATE EXPERIENCE W PLAN-R4/2";
label variable TOTTCH03 "TOTAL HEALTH CARE CHARGES 03, EXCL RX";
label variable TOTEXP03 "TOTAL HEALTH CARE EXP 03";
label variable TOTSLF03 "TOTAL AMT PAID BY SELF/FAMILY 03";
label variable TOTMCR03 "TOTAL AMT PAID BY MEDICARE 03";
label variable TOTMCD03 "TOTAL AMT PAID BY MEDICAID 03";
label variable TOTPRV03 "TOTAL AMT PAID BY PRIVATE INS 03";
label variable TOTVA03 "TOTAL AMT PAID BY VA 03";
label variable TOTTRI03 "TOTAL AMT PAID BY TRICARE 03";
label variable TOTOFD03 "TOTAL AMT PAID BY OTHER FEDERAL 03";
label variable TOTSTL03 "TOTAL AMT PAID BY OTH ST/LOCAL 03";
label variable TOTWCP03 "TOTAL AMT PAID BY WORKERS COMP 03";
label variable TOTOPR03 "TOTAL AMT PAID BY OTHER PRIVATE 03";
label variable TOTOPU03 "TOTAL AMT PAID BY OTHER PUBLIC 03";
label variable TOTOSR03 "TOTAL AMT PAID BY OTHER SOURCES 03";
label variable OBTOTV03 "# OFFICE-BASED PROVIDER VISITS 03";
label variable OBVTCH03 "OFFICE-BASED PROVIDER VISIT CHARGES 03";
label variable OBVEXP03 "TOTAL OFFICE-BASED EXP 03";
label variable OBVSLF03 "ALL OFFICE VISITS -SELF/FAMILY AMT 03";
label variable OBVMCR03 "ALL OFFICE VISITS -MEDICARE AMT 03";
label variable OBVMCD03 "ALL OFFICE VISITS -MEDICAID AMT 03";
label variable OBVPRV03 "ALL OFFICE VISITS -PRIVATE INS AMT 03";
label variable OBVVA03 "ALL OFFICE VISITS-VA AMT 03";
label variable OBVTRI03 "ALL OFFICE VISITS-TRICARE AMT 03";
label variable OBVOFD03 "ALL OFFICE VISITS-OTHER FEDERAL AMT 03";
label variable OBVSTL03 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 03";
label variable OBVWCP03 "ALL OFFICE VISITS -WORKERS COMP AMT 03";
label variable OBVOPR03 "ALL OFFICE VISITS - OTH PRIVATE AMT 03";
label variable OBVOPU03 "ALL OFFICE VISITS - OTH PUBLIC AMT 03";
label variable OBVOSR03 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBDRV03 "# OFFICE-BASED PHYSICIAN VISITS 03";
label variable OBDTCH03 "OFFICE-BASED PHYSICIAN VISIT CHARGES 03";
label variable OBDEXP03 "TOTAL OFF-BASED DR EXP 03";
label variable OBDSLF03 "DR OFFICE VISITS -SELF/FAMILY AMT 03";
label variable OBDMCR03 "DR OFFICE VISITS -MEDICARE AMT 03";
label variable OBDMCD03 "DR OFFICE VISITS -MEDICAID AMT 03";
label variable OBDPRV03 "DR OFFICE VISITS -PRIVATE INS AMT 03";
label variable OBDVA03 "DR OFFICE VISITS -VA AMT 03";
label variable OBDTRI03 "DR OFFICE VISITS -TRICARE AMT 03";
label variable OBDOFD03 "DR OFFICE VISITS -OTHER FEDERAL AMT 03";
label variable OBDSTL03 "DR OFFICE VISITS -OTH ST/LOCAL AMT 03";
label variable OBDWCP03 "DR OFFICE VISITS -WORKERS COMP AMT 03";
label variable OBDOPR03 "DR OFFICE VISITS - OTH PRIVATE AMT 03";
label variable OBDOPU03 "DR OFFICE VISITS - OTH PUBLIC AMT 03";
label variable OBDOSR03 "DR OFF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBOTHV03 "# OFFICE-BASED NON-PHYSICAN VISITS 03";
label variable OBOTCH03 "OFFICE-BASED NON-DR VISIT CHARGES 03";
label variable OBOEXP03 "TOTAL OFF-BASED NON-DR EXP 03";
label variable OBOSLF03 "NON-DR OFF VISTS -SELF/FAMILY AMT 03";
label variable OBOMCR03 "NON-DR OFF VISTS -MEDICARE AMT 03";
label variable OBOMCD03 "NON-DR OFF VISTS -MEDICAID AMT 03";
label variable OBOPRV03 "NON-DR OFF VISTS -PRIVATE INS AMT 03";
label variable OBOVA03 "NON-DR OFF VISTS -VA AMT 03";
label variable OBOTRI03 "NON-DR OFF VISTS -TRICARE AMT 03";
label variable OBOOFD03 "NON-DR OFF VISTS -OTHER FEDERAL AMT 03";
label variable OBOSTL03 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 03";
label variable OBOWCP03 "NON-DR OFF VISTS -WORKERS COMP AMT 03";
label variable OBOOPR03 "NON-DR OFF VISTS - OTH PRIVATE AMT 03";
label variable OBOOPU03 "NON-DR OFF VISTS - OTH PUBLIC AMT 03";
label variable OBOOSR03 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBCHIR03 "# OFFICE-BASED CHIROPRACTOR VISITS 03";
label variable OBCTCH03 "OFFICE-BASED CHIRO VISIT CHARGES 03";
label variable OBCEXP03 "TOTAL OFF-BASED CHIRO EXP 03";
label variable OBCSLF03 "CHIRO OFF VISITS -SELF/FAMILY AMT 03";
label variable OBCMCR03 "CHIRO OFF VISITS -MEDICARE AMT 03";
label variable OBCMCD03 "CHIRO OFF VISITS -MEDICAID AMT 03";
label variable OBCPRV03 "CHIRO OFF VISITS -PRIVATE INS AMT 03";
label variable OBCVA03 "CHIRO OFF VISITS -VA AMT 03";
label variable OBCTRI03 "CHIRO OFF VISITS -TRICARE AMT 03";
label variable OBCOFD03 "CHIRO OFF VISITS -OTHER FEDERAL AMT 03";
label variable OBCSTL03 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 03";
label variable OBCWCP03 "CHIRO OFF VISITS -WORKERS COMP AMT 03";
label variable OBCOPR03 "CHIRO OFF VISTS - OTHR PRIVATE AMT 03";
label variable OBCOPU03 "CHIRO OFF VISTS - OTHR PUBLIC AMT 03";
label variable OBCOSR03 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 03";
label variable OBNURS03 "# OFF-BASED NURSE/PRACTITIONER VISITS 03";
label variable OBNTCH03 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 03";
label variable OBNEXP03 "TOTAL OFF-BASED NURSE/PRAC 03";
label variable OBNSLF03 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 03";
label variable OBNMCR03 "NURSE/PRAC OFF VISITS -MEDICARE AMT 03";
label variable OBNMCD03 "NURSE/PRAC OFF VSTS -MEDICAID AMT 03";
label variable OBNPRV03 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 03";
label variable OBNVA03 "NURSE/PRAC OFF VSTS -VA AMT 03";
label variable OBNTRI03 "NURSE/PRAC OFF VSTS -TRICARE AMT 03";
label variable OBNOFD03 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 03";
label variable OBNSTL03 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 03";
label variable OBNWCP03 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 03";
label variable OBNOPR03 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 03";
label variable OBNOPU03 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 03";
label variable OBNOSR03 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBOPTO03 "# OFF-BASED OPTOMETRIST VISITS 03";
label variable OBETCH03 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 03";
label variable OBEEXP03 "TOTAL OFF-BASED OPOTMETRIST EXP 03";
label variable OBESLF03 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 03";
label variable OBEMCR03 "OPTOMETRIST OFF VSTS -MEDICARE AMT 03";
label variable OBEMCD03 "OPTOMETRIST OFF VSTS -MEDICAID AMT 03";
label variable OBEPRV03 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 03";
label variable OBEVA03 "OPTOMETRIST OFF VSTS -VA AMT 03";
label variable OBETRI03 "OPTOMETRIST OFF VSTS -TRICARE AMT 03";
label variable OBEOFD03 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 03";
label variable OBESTL03 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 03";
label variable OBEWCP03 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 03";
label variable OBEOPR03 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 03";
label variable OBEOPU03 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 03";
label variable OBEOSR03 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBASST03 "# OFF-BASED PHYSICIAN ASSIST VISITS 03";
label variable OBATCH03 "OFFICE-BASED PHYS ASST VISIT CHARGES 03";
label variable OBAEXP03 "TOTAL OFF-BASED PHYS ASS T EXP 03";
label variable OBASLF03 "PHYS ASS T OFF VSTS -SELF/FAMILY AMT 03";
label variable OBAMCR03 "PHYS ASS T OFF VSTS -MEDICARE AMT 03";
label variable OBAMCD03 "PHYS ASS T OFF VSTS -MEDICAID AMT 03";
label variable OBAPRV03 "PHYS ASS T OFF VSTS -PRIVATE INS AMT 03";
label variable OBAVA03 "PHYS ASS T OFF VSTS -VA AMT 03";
label variable OBATRI03 "PHYS ASS T OFF VSTS -TRICARE AMT 03";
label variable OBAOFD03 "PHYS ASS T OFF VSTS -OTHER FED AMT 03";
label variable OBASTL03 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 03";
label variable OBAWCP03 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 03";
label variable OBAOPR03 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 03";
label variable OBAOPU03 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 03";
label variable OBAOSR03 "P A OFF VSTS - OTH UNCLASS SRCE AMT 03";
label variable OBTHER03 "# OFF-BASED PT/OT VISITS 03";
label variable OBTTCH03 "OFFICE-BASED PT/OC VISIT CHARGES 03";
label variable OBTEXP03 "TOT OFF-BASED PT EXP 03";
label variable OBTSLF03 "PT/OT OFF VISITS -SELF/FAMILY AMT 03";
label variable OBTMCR03 "PT/OT OFF VISITS -MEDICARE AMT 03";
label variable OBTMCD03 "PT/OT OFF VISITS -MEDICAID AMT 03";
label variable OBTPRV03 "PT/OT OFF VISITS -PRIVATE INS AMT 03";
label variable OBTVA03 "PT/OT OFF VISITS -VA AMT 03";
label variable OBTTRI03 "PT/OT OFF VISITS -TRICARE AMT 03";
label variable OBTOFD03 "PT/OT OFF VISITS -OTHER FED AMT 03";
label variable OBTSTL03 "PT/OT OFF VISITS -OTH ST/LOCL AMT 03";
label variable OBTWCP03 "PT/OT OFF VISITS -WORKERS COMP AMT 03";
label variable OBTOPR03 "PT/OT OFF VISITS - OTH PRIVATE AMT 03";
label variable OBTOPU03 "PT/OT OFF VISITS - OTH PUBLIC AMT 03";
label variable OBTOSR03 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 03";
label variable OPTOTV03 "# OUTPATIENT DEPT PROVIDER VISITS 03";
label variable OPFTCH03 "OPD PROVIDER VISIT CHARGES - FAC 03";
label variable OPFEXP03 "TOTAL OUTPATIENT FACILITY EXP 03";
label variable OPFSLF03 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 03";
label variable OPFMCR03 "ALL OPD VISITS-MEDICARE AMT-FAC 03";
label variable OPFMCD03 "ALL OPD VISITS-MEDICAID AMT-FAC 03";
label variable OPFPRV03 "ALL OPD VISITS-PRIV INS AMT-FAC 03";
label variable OPFVA03 "ALL OPD VISITS-VA AMT-FAC 03";
label variable OPFTRI03 "ALL OPD VISITS-TRICARE AMT-FAC 03";
label variable OPFOFD03 "ALL OPD VISITS-OTHER FED AMT-FAC 03";
label variable OPFSTL03 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 03";
label variable OPFWCP03 "ALL OPD VISITS-WORKERS COMP AMT-FAC 03";
label variable OPFOPR03 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 03";
label variable OPFOPU03 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 03";
label variable OPFOSR03 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 03";
label variable OPDEXP03 "TOTAL OUTPATIENT PROVIDER EXP 03";
label variable OPDTCH03 "OPD PROVIDER VISIT CHARGES - DR 03";
label variable OPDSLF03 "ALL OPD VISITS-SELF/FAMILY AMT-DR 03";
label variable OPDMCR03 "ALL OPD VISITS-MEDICARE AMT -DR 03";
label variable OPDMCD03 "ALL OPD VISITS-MEDICAID AMT -DR 03";
label variable OPDPRV03 "ALL OPD VISITS-PRIV INS AMT-DR 03";
label variable OPDVA03 "ALL OPD VISITS-VA AMT-DR 03";
label variable OPDTRI03 "ALL OPD VISITS-TRICARE AMT-DR 03";
label variable OPDOFD03 "ALL OPD VISITS-OTHER FED AMT-DR 03";
label variable OPDSTL03 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 03";
label variable OPDWCP03 "ALL OPD VISITS-WORKERS COMP AMT-DR 03";
label variable OPDOPR03 "ALL OPD VISITS - OTH PRIVATE AMT-DR 03";
label variable OPDOPU03 "ALL OPD VISITS-OTH PUBLIC AMT-DR 03";
label variable OPDOSR03 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 03";
label variable OPDRV03 "# OUTPATIENT DEPT PHYSICIAN VISITS 03";
label variable OPVTCH03 "OPD PHYSICIAN VISIT CHARGES - FAC 03";
label variable OPVEXP03 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 03";
label variable OPVSLF03 "OPD DR VISITS-SELF/FAMILY AMT-FAC 03";
label variable OPVMCR03 "OPD DR VISITS-MEDICARE AMT-FAC 03";
label variable OPVMCD03 "OPD DR VISITS-MEDICAID AMT-FAC 03";
label variable OPVPRV03 "OPD DR VISITS-PRIV INS AMT-FAC 03";
label variable OPVVA03 "OPD DR VISITS-VA AMT-FAC 03";
label variable OPVTRI03 "OPD DR VISITS-TRICARE AMT-FAC 03";
label variable OPVOFD03 "OPD DR VISITS-OTHER FED AMT-FAC 03";
label variable OPVSTL03 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 03";
label variable OPVWCP03 "OPD DR VISITS-WORKERS COMP AMT-FAC 03";
label variable OPVOPR03 "OPD DR VISITS - OTH PRIVATE AMT-FAC 03";
label variable OPVOPU03 "OPD DR VISITS-OTH PUBLIC AMT-FAC 03";
label variable OPVOSR03 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 03";
label variable OPSEXP03 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 03";
label variable OPSTCH03 "OPD PHYSICIAN VISIT CHARGES - DR 03";
label variable OPSSLF03 "OPD DR VISITS-SELF/FAMILY AMT-DR 03";
label variable OPSMCR03 "OPD DR VISITS-MEDICARE AMT-DR 03";
label variable OPSMCD03 "OPD DR VISITS-MEDICAID AMT-DR 03";
label variable OPSPRV03 "OPD DR VISITS-PRIV INS AMT-DR 03";
label variable OPSVA03 "OPD DR VISITS-VA AMT-DR 03";
label variable OPSTRI03 "OPD DR VISITS-TRICARE AMT-DR 03";
label variable OPSOFD03 "OPD DR VISITS-OTHER FED AMT-DR 03";
label variable OPSSTL03 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 03";
label variable OPSWCP03 "OPD DR VISITS-WORKERS COMP AMT-DR 03";
label variable OPSOPR03 "OPD DR VISITS - OTH PRIVATE AMT-DR 03";
label variable OPSOPU03 "OPD DR VISITS-OTH PUBLIC AMT-DR 03";
label variable OPSOSR03 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 03";
label variable OPOTHV03 "# OUTPATIENT DEPT NON-DR VISITS 03";
label variable OPOTCH03 "OPD NON-PHYS VISIT CHARGES - FAC 03";
label variable OPOEXP03 "TOTAL OUTPATIENT NON-DR - FAC EXP 03";
label variable OPOSLF03 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 03";
label variable OPOMCR03 "OPD NON-DR VISITS-MEDICARE AMT-FAC 03";
label variable OPOMCD03 "OPD NON-DR VISITS-MEDICAID AMT-FAC 03";
label variable OPOPRV03 "OPD NON-DR VISITS-PRIV INS AMT-FAC 03";
label variable OPOVA03 "OPD NON-DR VISITS-VA AMT-FAC 03";
label variable OPOTRI03 "OPD NON-DR VISITS-TRICARE AMT-FAC 03";
label variable OPOOFD03 "OPD NON-DR VISITS-OTHER FED AMT-FAC 03";
label variable OPOSTL03 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 03";
label variable OPOWCP03 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 03";
label variable OPOOPR03 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 03";
label variable OPOOPU03 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 03";
label variable OPOOSR03 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 03";
label variable OPPEXP03 "TOTAL OUTPATIENT NON-DR - DR EXP 03";
label variable OPPTCH03 "OPD NON-PHYS VISIT CHARGES - DR 03";
label variable OPPSLF03 "OPD NON-DR VISITS-SELF/FAM AMT-DR 03";
label variable OPPMCR03 "OPD NON-DR VISITS-MEDICARE AMT-DR 03";
label variable OPPMCD03 "OPD NON-DR VISITS-MEDICAID AMT-DR 03";
label variable OPPPRV03 "OPD NON-DR VISITS-PRIV INS AMT-DR 03";
label variable OPPVA03 "OPD NON-DR VISITS-VA AMT-DR 03";
label variable OPPTRI03 "OPD NON-DR VISITS-TRICARE AMT-DR 03";
label variable OPPOFD03 "OPD NON-DR VISITS-OTHER FED AMT-DR 03";
label variable OPPSTL03 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 03";
label variable OPPWCP03 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 03";
label variable OPPOPR03 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 03";
label variable OPPOPU03 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 03";
label variable OPPOSR03 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 03";
label variable AMCHIR03 "# CHIROPRACTR VSTS (OFF+OUTPAT), 2003";
label variable AMCTCH03 "CHIRO AMBULATORY VISIT CHARGES 03";
label variable AMCEXP03 "TOTL AMBULTRY (OB+OP) CHIRO EXP 03";
label variable AMCSLF03 "CHIRO AMB VISITS -SELF/FAMILY AMT 03";
label variable AMCMCR03 "CHIRO AMB VISITS -MEDICARE AMT 03";
label variable AMCMCD03 "CHIRO AMB VISITS -MEDICAID AMT 03";
label variable AMCPRV03 "CHIRO AMB VISITS -PRIVATE INS AMT 03";
label variable AMCVA03 "CHIRO AMB VISITS -VA AMT 03";
label variable AMCTRI03 "CHIRO AMB VISITS-TRICARE AMT 03";
label variable AMCOFD03 "CHIRO AMB VISITS -OTHER FEDERAL AMT 03";
label variable AMCSTL03 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 03";
label variable AMCWCP03 "CHIRO AMB VISITS-WORKERS COMP AMT 03";
label variable AMCOPR03 "CHIRO AMB VISITS - OTH PRIVATE AMT 03";
label variable AMCOPU03 "CHIRO AMB VISITS - OTH PUBLIC AMT 03";
label variable AMCOSR03 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 03";
label variable AMNURS03 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 03";
label variable AMNTCH03 "NRS/PRAC AMBULATORY VISIT CHARGES 03";
label variable AMNEXP03 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 03";
label variable AMNSLF03 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 03";
label variable AMNMCR03 "NRS/PRAC AMB VSTS -MEDICARE AMT 03";
label variable AMNMCD03 "NRS/PRAC AMB VSTS -MEDICAID AMT 03";
label variable AMNPRV03 "NRS/PRAC AMB VSTS -PRIV INS AMT 03";
label variable AMNVA03 "NRS/PRAC AMB VSTS-VA AMT 03";
label variable AMNTRI03 "NRS/PRAC AMB VSTS-TRICARE AMT 03";
label variable AMNOFD03 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 03";
label variable AMNSTL03 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 03";
label variable AMNWCP03 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 03";
label variable AMNOPR03 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 03";
label variable AMNOPU03 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 03";
label variable AMNOSR03 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 03";
label variable AMOPTO03 "# AMB OPTOMETRIST VSTS (OB+OP) 03";
label variable AMETCH03 "OPTOMETRIST AMBULATORY VISIT CHARGES 03";
label variable AMEEXP03 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 03";
label variable AMESLF03 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 03";
label variable AMEMCR03 "OPTMTRIST AMB VSTS -MEDICARE AMT 03";
label variable AMEMCD03 "OPTMTRIST AMB VSTS -MEDICAID AMT 03";
label variable AMEPRV03 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 03";
label variable AMEVA03 "OPTMTRIST AMB VSTS-VA AMT 03";
label variable AMETRI03 "OPTMTRIST AMB VSTS-TRICARE AMT 03";
label variable AMEOFD03 "OPTMTRIST AMB VSTS-OTHER FED AMT 03";
label variable AMESTL03 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 03";
label variable AMEWCP03 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 03";
label variable AMEOPR03 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 03";
label variable AMEOPU03 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 03";
label variable AMEOSR03 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 03";
label variable AMASST03 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 2003";
label variable AMATCH03 "PHYS ASS T AMBULATORY VISIT CHARGES 03";
label variable AMAEXP03 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 03";
label variable AMASLF03 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 03";
label variable AMAMCR03 "PHYS ASS T AMB VSTS-MEDICARE AMT 03";
label variable AMAMCD03 "PHYS ASS T AMB VSTS-MEDICAID AMT 03";
label variable AMAPRV03 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 03";
label variable AMAVA03 "PHYS ASS T AMB VSTS-VA AMT 03";
label variable AMATRI03 "PHYS ASS T AMB VSTS-TRICARE AMT 03";
label variable AMAOFD03 "PHYS ASS T AMB VSTS -OTHER FED AMT 03";
label variable AMASTL03 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 03";
label variable AMAWCP03 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 03";
label variable AMAOPR03 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 03";
label variable AMAOPU03 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 03";
label variable AMAOSR03 "P A AMB VSTS- OTH UNCLASS SRCE AMT 03";
label variable AMTHER03 "# AMB PT/OT THRPY VISITS (OB+OP) 03";
label variable AMTTCH03 "PT/OC AMBULATORY VISIT CHARGES 03";
label variable AMTEXP03 "TOTL AMBULTRY (OB+OP) PT/OT EXP 03";
label variable AMTSLF03 "PT/OT AMB VISITS-SELF/FAMILY AMT 03";
label variable AMTMCR03 "PT/OT AMB VISITS-MEDICARE AMT 03";
label variable AMTMCD03 "PT/OT AMB VISITS-MEDICAID AMT 03";
label variable AMTPRV03 "PT/OT AMB VISITS-PRIVATE INS AMT 03";
label variable AMTVA03 "PT/OT AMB VISITS-VA AMT 03";
label variable AMTTRI03 "PT/OT AMB VISITS-TRICARE AMT 03";
label variable AMTOFD03 "PT/OT AMB VISITS -OTHER FED AMT 03";
label variable AMTSTL03 "PT/OT AMB VISITS-OTH ST/LOCL AMT 03";
label variable AMTWCP03 "PT/OT AMB VISITS-WORKERS COMP AMT 03";
label variable AMTOPR03 "PT/OT AMB VISITS - OTH PRIVATE AMT 03";
label variable AMTOPU03 "PT/OT AMB VISITS-OTH PUBLIC AMT 03";
label variable AMTOSR03 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 03";
label variable AMTOTC03 "# CALLS W/OFFICE & OUPAT DEPTS, 2003";
label variable AMDRC03 "# CALLS W/OFF & OUTPAT PHYSICIANS, 2003";
label variable ERTOT03 "# EMERGENCY ROOM VISITS 03";
label variable ERFTCH03 "ER FACILITY VISIT CHARGES 03";
label variable ERFEXP03 "TOTAL ER FACILITY EXP 03";
label variable ERFSLF03 "ER-SELF/FAMILY AMT - FAC 03";
label variable ERFMCR03 "ER-MEDICARE AMT - FAC 03";
label variable ERFMCD03 "ER-MEDICAID AMT - FAC 03";
label variable ERFPRV03 "ER-PRIVATE INS AMT - FAC 03";
label variable ERFVA03 "ER-VA AMT - FAC 03";
label variable ERFTRI03 "ER-TRICARE AMT - FAC 03";
label variable ERFOFD03 "ER-OTHER FEDERAL AMT - FAC 03";
label variable ERFSTL03 "ER-OTH ST/LOCAL AMT - FAC 03";
label variable ERFWCP03 "ER-WORKERS COMP AMT - FAC 03";
label variable ERFOPR03 "ER-OTHER PRIVATE AMT - FAC 03";
label variable ERFOPU03 "ER-OTHER PUBLIC AMT - FAC 03";
label variable ERFOSR03 "ER-OTH UNCLASS SRCE AMT - FAC 03";
label variable ERDEXP03 "TOTAL EMERGENCY ROOM DR EXP 03";
label variable ERDTCH03 "ER DOCTOR VISIT CHARGES 03";
label variable ERDSLF03 "ER-SELF/FAMILY AMT - DR 03";
label variable ERDMCR03 "ER-MEDICARE AMT - DR 03";
label variable ERDMCD03 "ER-MEDICAID AMT - DR 03";
label variable ERDPRV03 "ER-PRIVATE INS AMT - DR 03";
label variable ERDVA03 "ER-VA AMT - DR 03";
label variable ERDTRI03 "ER-TRICARE AMT - DR 03";
label variable ERDOFD03 "ER-OTHER FED AMT - DR 03";
label variable ERDSTL03 "ER-OTH ST/LOCAL AMT - DR 03";
label variable ERDWCP03 "ER-WORKERS COMP AMT - DR 03";
label variable ERDOPR03 "ER - OTHER PRIVATE AMT - DR 03";
label variable ERDOPU03 "ER - OTHER PUBLIC AMT - DR 03";
label variable ERDOSR03 "ER-OTH UNCLASS SRCE AMT - DR 03";
label variable IPZERO03 "# ZERO-NIGHT HOSPITAL STAYS 03";
label variable ZIFTCH03 "ZERO-NITE IP STAY CHARGES - FAC 03";
label variable ZIFEXP03 "TOTAL ZERO-NITE STAYS FAC EXP 03";
label variable ZIFSLF03 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 03";
label variable ZIFMCR03 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 03";
label variable ZIFMCD03 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 03";
label variable ZIFPRV03 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 03";
label variable ZIFVA03 "ZERO-NITE IP STAZ-VA AMT-FAC 03";
label variable ZIFTRI03 "ZERO-NITE IP STAZ-TRICARE AMT-FAC 03";
label variable ZIFOFD03 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 03";
label variable ZIFSTL03 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 03";
label variable ZIFWCP03 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 03";
label variable ZIFOPR03 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 03";
label variable ZIFOPU03 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 03";
label variable ZIFOSR03 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 03";
label variable ZIDEXP03 "TOTAL ZERO-NITE STAZ DR 03";
label variable ZIDTCH03 "ZERO-NITE IP STAY CHARGES - DR 03";
label variable ZIDSLF03 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 03";
label variable ZIDMCR03 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 03";
label variable ZIDMCD03 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 03";
label variable ZIDPRV03 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 03";
label variable ZIDVA03 "ZERO-NITE IP STAZ-VA AMT-DR 03";
label variable ZIDTRI03 "ZERO-NITE IP STAZ-TRICARE AMT-DR 03";
label variable ZIDOFD03 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 03";
label variable ZIDSTL03 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 03";
label variable ZIDWCP03 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 03";
label variable ZIDOPR03 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 03";
label variable ZIDOPU03 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 03";
label variable ZIDOSR03 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 03";
label variable IPDIS03 "# HOSPITAL DISCHARGES, 2003";
label variable IPFEXP03 "TOT HOSP IP FACILITY EXP-INC 0 NITES 03";
label variable IPFTCH03 "IP HOSP STAY CHARGES - FAC 03";
label variable IPFSLF03 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 03";
label variable IPFMCR03 "IP HOSP STAZ-MEDICARE AMT-FAC 03";
label variable IPFMCD03 "IP HOSP STAZ-MEDICAID AMT-FAC 03";
label variable IPFPRV03 "IP HOSP STAZ-PRIV INS AMT-FAC 03";
label variable IPFVA03 "IP HOSP STAZ-VA AMT-FAC 03";
label variable IPFTRI03 "IP HOSP STAZ-TRICARE AMT-FAC 03";
label variable IPFOFD03 "IP HOSP STAZ-OTHER FED AMT-FAC 03";
label variable IPFSTL03 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 03";
label variable IPFWCP03 "IP HOSP STAZ-WORKERS COMP AMT-FAC 03";
label variable IPFOPR03 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 03";
label variable IPFOPU03 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 03";
label variable IPFOSR03 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 03";
label variable IPDEXP03 "TOTL HOSP STAZ DR EXP 03";
label variable IPDTCH03 "IP HOSP STAY CHARGES - DR 03";
label variable IPDSLF03 "IP HOSP STAZ-SELF/FAMILY AMT-DR 03";
label variable IPDMCR03 "IP HOSP STAZ-MEDICARE AMT- DR 03";
label variable IPDMCD03 "IP HOSP STAZ-MEDICAID AMT-DR 03";
label variable IPDPRV03 "IP HOSP STAZ-PRIV INS AMT- DR 03";
label variable IPDVA03 "IP HOSP STAZ-VA AMT-DR 03";
label variable IPDTRI03 "IP HOSP STAZ-TRICARE AMT-DR 03";
label variable IPDOFD03 "IP HOSP STAZ-OTHER FED AMT-DR 03";
label variable IPDSTL03 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 03";
label variable IPDWCP03 "IP HOSP STAZ-WORKERS COMP AMT-DR 03";
label variable IPDOPR03 "IP HOSP STAZ - OTH PRIVATE AMT-DR 03";
label variable IPDOPU03 "IP HOSP STAZ - OTH PUBLIC AMT-DR 03";
label variable IPDOSR03 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 03";
label variable IPNGTD03 "# NIGHTS IN HOSP FOR DISCHARGES, 2003";
label variable DVTOT03 "# DENTAL CARE VISITS 03";
label variable DVTTCH03 "TOTAL DENTAL CARE VISIT CHARGES 03";
label variable DVTEXP03 "TOTAL DENTAL CARE EXP 03";
label variable DVTSLF03 "ALL DENTAL CARE -SELF/FAMILY AMT 03";
label variable DVTMCR03 "ALL DENTAL CARE -MEDICARE AMT 03";
label variable DVTMCD03 "ALL DENTAL CARE -MEDICAID AMT 03";
label variable DVTPRV03 "ALL DENTAL CARE -PRIVATE INS AMT 03";
label variable DVTVA03 "ALL DENTAL CARE -VA AMT 03";
label variable DVTTRI03 "ALL DENTAL CARE -TRICARE AMT 03";
label variable DVTOFD03 "ALL DENTAL CARE -OTHER FEDRL AMT 03";
label variable DVTSTL03 "ALL DENTAL CARE -OTH ST/LOCAL AMT 03";
label variable DVTWCP03 "ALL DENTAL CARE -WORKERS COMP AMT 03";
label variable DVTOPR03 "ALL DENTAL CARE - OTH PRIVATE AMT 03";
label variable DVTOPU03 "ALL DENTAL CARE - OTH PUBLIC AMT 03";
label variable DVTOSR03 "ALL DENT CARE-OT UNCLASS SRCE AMT 03";
label variable DVGEN03 "# GENERAL DENTIST VISITS 03";
label variable DVGTCH03 "GENERAL DENTAL CARE VISIT CHARGES 03";
label variable DVGEXP03 "TOTAL GENERAL DENTIST EXP 03";
label variable DVGSLF03 "GNRL DENTAL VISITS -SELF/FAM AMT 03";
label variable DVGMCR03 "GNRL DENTAL VISITS -MEDICARE AMT 03";
label variable DVGMCD03 "GNRL DENTAL VISITS -MEDICAID AMT 03";
label variable DVGPRV03 "GNRL DENTAL VISITS -PRIVATE INS AMT 03";
label variable DVGVA03 "GNRL DENTAL VISITS -VA AMT 03";
label variable DVGTRI03 "GNRL DENTAL VISITS-TRICARE AMT 03";
label variable DVGOFD03 "GNRL DENTAL VISITS- OTHER FED AMT 03";
label variable DVGSTL03 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 03";
label variable DVGWCP03 "GNRL DENTAL VISITS - WORKERS COMP AMT 03";
label variable DVGOPR03 "GNRL DENTAL VISITS - OTH PRIVATE AMT 03";
label variable DVGOPU03 "GNRL DENTAL VISITS - OTH PUBLIC AMT 03";
label variable DVGOSR03 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 03";
label variable DVORTH03 "# ORTHODONTIST VISITS 03";
label variable DVOTCH03 "ORTHODONTIST VISIT CHARGES 03";
label variable DVOEXP03 "TOTAL ORTHODONTIST EXP 03";
label variable DVOSLF03 "ORTHODONTIST VISITS -SELF/FAMILY AMT 03";
label variable DVOMCR03 "ORTHODONTIST VISITS -MEDICARE AMT 03";
label variable DVOMCD03 "ORTHODONTIST VISITS -MEDICAID AMT 03";
label variable DVOPRV03 "ORTHODONTIST VISITS -PRIVATE INS AMT 03";
label variable DVOVA03 "ORTHODONTIST VISITS-VA AMT 03";
label variable DVOTRI03 "ORTHODONTIST VISITS-TRICARE AMT 03";
label variable DVOOFD03 "ORTHODONTIST VISITS-OTHR FED AMT 03";
label variable DVOSTL03 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 03";
label variable DVOWCP03 "ORTHODONTIST VISITS-WORKERS COMP AMT 03";
label variable DVOOPR03 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 03";
label variable DVOOPU03 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 03";
label variable DVOOSR03 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 03";
label variable HHTOTD03 "# HOME HEALTH PROVIDER DAYS, 2003";
label variable HHAGD03 "# AGENCY HOME HEALTH PROVIDER DAYS 03";
label variable HHATCH03 "HOME HEALTH AGENCY VISIT CHARGES 03";
label variable HHAEXP03 "TOTAL HOME HEALTH AGENCY EXP 03";
label variable HHASLF03 "HOME HLTH AGENCY -SELF/FAMILY AMT 03";
label variable HHAMCR03 "HOME HLTH AGENCY -MEDICARE AMT 03";
label variable HHAMCD03 "HOME HLTH AGENCY -MEDICAID AMT 03";
label variable HHAPRV03 "HOME HLTH AGENCY -PRIVATE INS AMT 03";
label variable HHAVA03 "HOME HLTH AGENCY-VA AMT 03";
label variable HHATRI03 "HOME HLTH AGENCY-TRICARE AMT 03";
label variable HHAOFD03 "HOME HLTH AGENCY-OTHER FED AMT 03";
label variable HHASTL03 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 03";
label variable HHAWCP03 "HOME HLTH AGENCY- WORKERS COMP AMT 03";
label variable HHAOPR03 "HOME HLTH AGENCY - OTH PRIVATE AMT 03";
label variable HHAOPU03 "HOME HLTH AGENCY - OTH PUBLIC AMT 03";
label variable HHAOSR03 "H HLTH AGENCY - OT UNCLASS SRCE AMT 03";
label variable HHINDD03 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 03";
label variable HHNTCH03 "HOME HEALTH NON-AGENCY VISIT CHARGES 03";
label variable HHNEXP03 "TOTAL HOME HEALTH NON-AGNCY EXP 03";
label variable HHNSLF03 "HOME HLTH NON-AGNCY -SELF/FAM AMT 03";
label variable HHNMCR03 "HOME HLTH NON-AGNCY -MEDICARE AMT 03";
label variable HHNMCD03 "HOME HLTH NON-AGNCY -MEDICAID AMT 03";
label variable HHNPRV03 "HOME HLTH NON-AGNCY -PRIV INS AMT 03";
label variable HHNVA03 "HOME HLTH NON-AGNCY-VA AMT 03";
label variable HHNTRI03 "HOME HLTH NON-AGNCY-TRICARE AMT 03";
label variable HHNOFD03 "HOME HLTH NON-AGNCY-OTHR FED AMT 03";
label variable HHNSTL03 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 03";
label variable HHNWCP03 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 03";
label variable HHNOPR03 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 03";
label variable HHNOPU03 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 03";
label variable HHNOSR03 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 03";
label variable HHINFD03 "# INFORMAL HOME HEALTH PROVIDER DAYS 03";
label variable VISEXP03 "TOTAL GLASSES/CONTACT LENS EXP 03";
label variable VISTCH03 "GLASSES/CONTACT LENSES CHARGES 03";
label variable VISSLF03 "GLASSES/CNTCT LENSES -SELF/FAM AMT 03";
label variable VISMCR03 "GLASSES/CNTCT LENSES-MEDICARE AMT 03";
label variable VISMCD03 "GLASSES/CNTCT LENSES-MEDICAID AMT 03";
label variable VISPRV03 "GLASSES/CNTCT LENSES-PRIV INS AMT 03";
label variable VISVA03 "GLASSES/CNTCT LENSES-VA AMT 03";
label variable VISTRI03 "GLASSES/LENSES-TRICARE AMT 03";
label variable VISOFD03 "GLASSES/CNTCT LENSES-OTHR FED AMT 03";
label variable VISSTL03 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 03";
label variable VISWCP03 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 03";
label variable VISOPR03 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 03";
label variable VISOPU03 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 03";
label variable VISOSR03 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 03";
label variable OTHTCH03 "OTHER EQUP/SUPPLIES CHARGES 03";
label variable OTHEXP03 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 03";
label variable OTHSLF03 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 03";
label variable OTHMCR03 "OTHER EQUP/SUPPLIES-MEDICARE AMT 03";
label variable OTHMCD03 "OTHER EQUP/SUPPLIES-MEDICAID AMT 03";
label variable OTHPRV03 "OTHER EQUP/SUPPLIES-PRIV INS AMT 03";
label variable OTHVA03 "OTHER EQUP/SUPPLY-VA AMT 03";
label variable OTHTRI03 "OTHER EQUP/SUPPLY-TRICARE AMT 03";
label variable OTHOFD03 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 03";
label variable OTHSTL03 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 03";
label variable OTHWCP03 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 03";
label variable OTHOPR03 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 03";
label variable OTHOPU03 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 03";
label variable OTHOSR03 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 03";
label variable RXTOT03 "# PRESC MEDS INCL REFILLS 03";
label variable RXEXP03 "TOTAL RX-EXP 03";
label variable RXSLF03 "TOTAL RX-SELF/FAMILY AMT 03";
label variable RXMCR03 "TOTAL RX--MEDICARE AMT 03";
label variable RXMCD03 "TOTAL RX-MEDICAID AMT 03";
label variable RXPRV03 "TOTAL RX-PRIVATE INS AMT 03";
label variable RXVA03 "TOTAL RX-VA AMT 03";
label variable RXTRI03 "TOTAL RX-TRICARE AMT 03";
label variable RXOFD03 "TOTAL RX-OTHER FED AMT 03";
label variable RXSTL03 "TOTAL RX-OTHER ST/LOCAL AMT 03";
label variable RXWCP03 "TOTAL RX-WORKERS COMP AMT 03";
label variable RXOPR03 "TOTAL RX - OTH PRIVATE AMT 03";
label variable RXOPU03 "TOTAL RX - OTH PUBLIC AMT 03";
label variable RXOSR03 "TOT RX-OTH UNCLASS SRCE AMT 03";
label variable PERWT03F "FINAL PERSON WEIGHT, 2003";
label variable FAMWT03F "FINAL FAMILY WEIGHT, 2003";
label variable FAMWT03C "POV ADJ FAMILY WGT-CPS FAM ON 12/31/03";
label variable SAQWT03F "FINAL SAQ-PAQ PERSON WEIGHT, 2003";
label variable DIABW03F "FINAL DIABETES CARE SUPPLEMENT WEIGHT";
label variable VARSTR "VARIANCE ESTIMATION STRATUM - 2003";
label variable VARPSU "VARIANCE ESTIMATION PSU - 2003";


*DEFINE VALUE LABELS FOR REPORTS;
label define H790001X
         -1 "-1 INAPPLICABLE"
         1 "1 YES" ;

label define H790002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H790003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H790004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H790005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO PERFORM ACTIVITIES" ;

label define H790008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H790009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H790011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED A LOT"
         2 "2 LIMITED A LITTLE"
         3 "3 NOT LIMITED" ;

label define H790015X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT ANXIOUS/DEPRESSED"
         2 "2 MODERATELY ANXIOUS/DEPRESSED"
         3 "3 EXTREMELY ANXIOUS/DEPRESSED" ;

label define H790016X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790019X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H790020X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H790021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H790024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H790025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790027X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790028X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH VERSION SAQ WAS ADMINISTERED"
         2 "2 SPANISH VERSION SAQ WAS ADMINISTERED" ;

label define H790029X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790030X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 CONFINED TO BED" ;

label define H790035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790039X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 HAD NO VISITS IN THE LAST 12 MONTHS" ;

label define H790040X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H790041X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NOT AT ALL"
         2 "2 A LITTLE BIT"
         3 "3 MODERATELY"
         4 "4 QUITE A BIT"
         5 "5 EXTREMELY" ;

label define H790042X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790043X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PAIN"
         2 "2 HAVE MODERATE PAIN"
         3 "3 HAVE EXTREME PAIN" ;

label define H790044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF-ADMINISTERED"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         100 "100 INTERVIEWER ADMINISTERED"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP - /HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 PARTNER'S DAUGHTER"
         33 "33 PARTNER'S SON"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP - /HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         47 "47 PARENT"
         48 "48 GRANDPARENT"
         49 "49 NOT PERSON ON SAQ LABEL,RELATIONSHIP UNK"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H790047X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790048X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790049X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAGREE STRONGLY"
         2 "2 DISAGREE SOMEWHAT"
         3 "3 UNCERTAIN"
         4 "4 AGREE SOMEWHAT"
         5 "5 AGREE STRONGLY" ;

label define H790050X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790051X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH"
         100 "100 BEST HEALTH" ;

label define H790053X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HAVE NO PROBLEMS"
         2 "2 HAVE SOME PROBLEMS"
         3 "3 UNABLE TO WASH/DRESS" ;

label define H790054X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALL OF THE TIME"
         2 "2 MOST OF THE TIME"
         3 "3 SOME OF THE TIME"
         4 "4 LITTLE OF THE TIME"
         5 "5 NONE OF THE TIME" ;

label define H790056X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790057X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AFDC"
         2 "2 NOT AFDC" ;

label define H790059X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H790060X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790062X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H790063X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790064X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790065X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790066X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790067X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790068X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790069X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790070X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790071X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790072X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790073X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790074X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790075X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790076X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790077X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790078X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790079X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790080X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790082X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790083X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2815 "$2815" ;

label define H790084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         423 "$423" ;

label define H790086X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790087X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790088X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790089X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790090X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790091X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790092X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790093X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790094X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790095X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790096X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790097X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790098X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790099X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790100X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790101X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790102X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790103X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790104X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790105X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790106X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790107X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790108X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20" ;

label define H790109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790110X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790111X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790112X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790113X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790114X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790115X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790116X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790117X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790118X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790119X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790120X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790121X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790122X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790123X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790124X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790125X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790126X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790127X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790128X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790129X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790130X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790131X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790132X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790133X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790134X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790135X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790136X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790137X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790138X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790139X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790140X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790142X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790143X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H790144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 NO VISITS IN LAST 12 MONTHS" ;

label define H790145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790148X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790149X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790150X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790151X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790152X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790158X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790159X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790160X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN LAST 7 DAYS"
         2 "2 MORE THAN 7, BUT WITHIN LAST 30 DAYS"
         3 "3 MORE THAN 30 DAYS AGO" ;

label define H790161X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790162X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790163X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790164X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790165X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790166X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790167X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR"
         2003 "2003 YEAR" ;

label define H790168X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR" ;

label define H790169X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR"
         2004 "2004 YEAR" ;

label define H790170X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790171X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790172X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790173X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790174X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H790175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790177X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790178X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790179X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H790182X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H790183X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H790184X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H790185X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790186X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790187X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790188X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NONE"
         1 "1 1"
         2 "2 2"
         3 "3 3"
         4 "4 4"
         5 "5 5 TO 9"
         6 "6 10 OR MORE" ;

label define H790189X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H790190X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790191X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790192X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790193X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790194X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790195X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H790196X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H790197X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 WORST HEALTH CARE POSSIBLE"
         10 "10 BEST HEALTH CARE POSSIBLE" ;

label define H790198X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790199X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790200X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790201X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790202X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790204X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H790205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 BIG PROBLEM"
         2 "2 SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790209X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790210X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790212X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790213X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H790229X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H790230X
         -1 "-1 INAPPLICABLE"
         -8 "-8 DK"
         1 "1 YES"
         2 "2 NO" ;

label define H790231X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790232X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNKNOWN" ;

label define H790234X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H790235X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790236X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790237X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790238X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790239X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790240X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790241X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790242X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790243X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790244X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790245X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790246X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790247X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790248X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H790249X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H790250X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790251X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 TWICE A YEAR OR MORE"
         2 "2 ONCE A YEAR"
         3 "3 LESS THAN ONCE A YEAR"
         4 "4 NEVER GO TO DENTIST" ;

label define H790252X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790253X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790254X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790255X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES" ;

label define H790256X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H790257X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790258X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H790259X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790260X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H790261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H790262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES [WAGE AMOUNT CHANGED]"
         2 "2 NO [WAGE AMOUNT DID NOT CHANGE]" ;

label define H790263X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H790264X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H790265X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE THROUGH CMJ" ;

label define H790266X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790267X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H790268X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790269X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790270X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H790272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790274X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H790275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790277X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790278X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H790279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSIDE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H790280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H790282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NUMBER OF TIMES"
         95 "95 95 TIMES OR MORE" ;

label define H790283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790291X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790295X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790296X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790297X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790298X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790299X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790300X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790301X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790302X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790303X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790304X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790305X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790306X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790307X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790308X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790309X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790310X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790311X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790312X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790313X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         175 "$175" ;

label define H790314X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790315X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         99 "$99" ;

label define H790316X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790317X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790319X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790320X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2146 "$2146" ;

label define H790321X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790322X
         -1 "-1 INAPPLICABLE   * THE VARIABLE BELOW HAS LT 4 unique values GT 0"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790323X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         51 "$51" ;

label define H790324X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1500 "$1500" ;

label define H790325X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790326X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790327X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790328X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790329X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790330X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790331X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790332X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790333X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790334X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790335X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790336X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790337X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790338X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790339X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO SCHOOL/KINDERGARTEN ONLY"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H790342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H790343X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H790344X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H790345X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H790346X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H790347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790348X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H790349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H790350X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H790351X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790353X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790357X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790358X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H790359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR" ;

label define H790360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2002 "2002 YEAR"
         2003 "2003 YEAR" ;

label define H790361X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR" ;

label define H790362X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         2003 "2003 YEAR"
         2004 "2004 YEAR" ;

label define H790363X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790364X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790365X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H790366X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790367X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790368X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790369X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2 "$2" ;

label define H790370X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790371X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790372X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790373X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790374X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790375X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790376X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790377X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790378X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790379X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790380X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790381X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790382X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790383X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790384X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790385X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790386X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790387X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790388X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790389X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790390X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790391X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790392X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790393X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790394X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790399X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790400X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790402X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H790403X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H790404X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H790405X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H790406X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         15 "15 PERSONS"
         16 "16 PERSONS"
         17 "17 PERSONS"
         18 "18 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H790407X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H790408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H790410X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/ QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/ DEPENDENT" ;

label define H790411X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790412X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H790413X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790415X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790418X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H790420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H790421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H790422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H790423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H790424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM"
         95 "95 DO NOT HAVE PERSONAL DOCTOR OR NURSE" ;

label define H790425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H790426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DRIVE"
         2 "2 IS DRIVEN"
         3 "3 TAXI, BUS, TRAIN, OTHER PUBLIC TRANSPO"
         4 "4 WALKS" ;

label define H790427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790428X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790429X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790430X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790432X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H790433X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790435X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790436X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790437X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790440X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790441X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790442X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790443X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790444X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1043 "$1044 - $1043"
         670 "$670 - $670" ;

label define H790445X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790446X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790447X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790448X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790449X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790450X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790451X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790452X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1550 "$1550" ;

label define H790453X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790454X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790455X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790456X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790457X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20 - $20"
         2430 "$2431 - $2430" ;

label define H790458X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790459X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790460X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790461X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         266 "$266" ;

label define H790462X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790463X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790464X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790465X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790466X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790467X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16 - $16"
         2248 "$2249 - $2248" ;

label define H790468X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790469X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790470X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790471X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16-INAPPLICABLE" ;

label define H790472X
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H790473X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN/CUBAN AMERICAN"
         3 "3 DOMINICAN"
         4 "4 MEXICAN/MEXICAN AMERICAN"
         5 "5 CENTRAL OR SOUTH AMERICAN"
         6 "6 NON-HISPANIC"
         91 "91 OTHER LATIN AMERICAN"
         92 "92 OTHER HISPANIC/LATINO" ;

label define H790474X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H790475X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790476X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790477X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790478X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790479X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790480X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790481X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790482X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790483X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790484X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790485X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790486X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790487X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790488X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790489X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790490X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790491X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790492X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790493X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790494X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790495X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790496X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790497X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790498X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790499X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790506X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790531X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790550X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790551X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H790552X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H790553X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H790554X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -9 "-9 NOT ASCERTAINED" ;

label define H790555X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H790556X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $57.69"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED" ;

label define H790557X
         0 "0 NO"
         1 "1 YES" ;

label define H790558X
         0 "0 NO"
         1 "1 YES" ;

label define H790559X
         0 "0 NO"
         1 "1 YES" ;

label define H790560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790567X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790568X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790570X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H790571X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H790572X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NATURAL RESOURCES"
         10 "10 EDUCATION, HEALTH, AND SOCIAL SERVICES"
         11 "11 LEISURE AND HOSPITALITY"
         12 "12 OTHER SERVICES"
         13 "13 PUBLIC ADMINISTRATION"
         14 "14 MILITARY"
         15 "15 UNCLASSIFIABLE INDUSTRY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 WHOLESALE AND RETAIL TRADE"
         6 "6 TRANSPORTATION AND UTILITIES"
         7 "7 INFORMATION"
         8 "8 FINANCIAL ACTIVITIES"
         9 "9 PROFESSIONAL AND BUSINESS SERVICES" ;

label define H790573X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790574X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790575X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790576X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790577X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790578X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790579X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790580X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790581X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790582X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790583X
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/2003"
         2 "2 NOT IN-SCOPE ON 12/31/2003" ;

label define H790584X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/03"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H790585X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/03"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H790586X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/03"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H790587X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/03"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H790588X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 2003"
         2 "2 OUT-OF-SCOPE FOR ALL OF 2003" ;

label define H790589X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H790590X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790591X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790592X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790593X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790594X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790595X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790596X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790597X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790598X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790599X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790600X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790601X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790602X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790603X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H790604X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790605X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ENGLISH & SPANISH"
         91 "91 OTHER" ;

label define H790606X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790608X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790609X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790610X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790611X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790612X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790613X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790614X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790615X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790616X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790617X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790618X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790619X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790620X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790621X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790622X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790623X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790624X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790625X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790626X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790627X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790628X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790629X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790630X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790631X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790632X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790633X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790634X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790635X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790637X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H790638X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790639X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790640X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H790641X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H790642X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H790643X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790644X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790645X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790646X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H790647X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790648X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790649X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ENGLISH"
         2 "2 SPANISH"
         3 "3 ANOTHER LANGUAGE" ;

label define H790650X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790651X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790652X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790653X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790654X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790655X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790656X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 OFFICE"
         2 "2 HOSPITAL, NOT ER"
         3 "3 HOSPITAL, ER" ;

label define H790657X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H790658X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790659X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H790660X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H790661X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H790662X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H790663X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H790664X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790665X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790666X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790667X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790668X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790669X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790670X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790671X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790672X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790673X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790674X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790675X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790676X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790677X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790678X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790679X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790680X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790681X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790682X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790683X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790684X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790685X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790686X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790687X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790688X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790689X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790690X
         1 "1 YES"
         2 "2 NO" ;

label define H790691X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790692X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790693X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790694X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790695X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP - HMO NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP HMO"
         2 "2 COV BY MEDICAID/SCHIP - NOT HMO"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790696X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790697X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790698X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790699X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790700X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790701X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790702X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790703X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790704X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790705X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790706X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY MCAID/SCHIP-GTKPR NOT ASCERTAINED"
         1 "1 COV BY MEDICAID/SCHIP GATEKEEPER PLAN"
         2 "2 COV BY MEDICAID/SCHIP - NOT GATEKEEPER"
         3 "3 NOT COV BY MEDICAID/SCHIP" ;

label define H790707X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790720X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790721X
         1 "1 YES"
         2 "2 NO" ;

label define H790722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790730X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790731X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790732X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790733X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790734X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790735X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790736X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790737X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790738X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790739X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790740X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED" ;

label define H790741X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790742X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790743X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H790744X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790745X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H790746X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H790747X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H790748X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790749X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 TRIED, BUT PERSON WAS UNCOOPERATIVE" ;

label define H790750X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790751X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790752X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790753X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H790754X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790755X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H790756X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H790757X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H790758X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790759X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790760X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790761X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790762X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790763X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H790764X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H790765X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H790766X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H790767X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H790768X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H790769X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H790770X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790771X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790772X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H790773X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H790774X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790775X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790776X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790777X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790778X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790779X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790780X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790781X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WEEKS"
         2 "2 MONTHS" ;

label define H790782X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790783X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790784X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790785X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790786X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790787X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H790788X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H790789X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H790790X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H790791X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790792X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790793X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790794X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790795X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790796X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790797X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790798X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790799X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790801X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790802X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790803X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790804X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790805X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790806X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790808X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790809X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790810X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         2815 "$2815" ;

label define H790811X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790812X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         423 "$423" ;

label define H790813X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790814X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790815X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790816X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790817X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790818X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790819X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790820X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790821X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790822X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790823X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790824X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790825X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790826X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790827X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790828X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790829X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "1" ;

label define H790830X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790831X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790832X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790833X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790834X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790835X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790836X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790837X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790838X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790839X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790840X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790841X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790842X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790843X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790844X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790845X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790846X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790847X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790848X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790849X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790850X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790851X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790852X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790853X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790854X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790855X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790856X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790857X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790858X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790859X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790860X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790861X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790862X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790863X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790864X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790865X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790866X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790867X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790868X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790869X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790870X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790871X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790872X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790873X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790874X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790875X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790876X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790877X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790878X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790879X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790880X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790881X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790882X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790883X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790884X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790885X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790886X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790887X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         165 "$165" ;

label define H790888X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790889X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790890X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790891X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790892X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790893X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790894X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790895X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790896X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790897X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790898X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790899X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790900X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790901X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790902X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790903X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790904X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790905X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790906X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790907X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790908X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790909X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790910X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790911X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H790912X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H790913X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MANAGEMENT, BUSINESS, AND FINANCIAL OPER"
         10 "10 NO WORK EXPERIENCE SINCE 1995"
         11 "11 UNCLASSIFIABLE OCCUPATION"
         2 "2 PROFESSIONAL AND RELATED OCCUPATIONS"
         3 "3 SERVICE OCCUPATIONS"
         4 "4 SALES AND RELATED OCCUPATIONS"
         5 "5 OFFICE AND ADMINISTRATIVE SUPPORT"
         6 "6 FARMING, FISHING, AND FORESTRY"
         7 "7 CONSTRUCTION, EXTRACTION, AND MAINTENANC"
         8 "8 PRODUCTION, TRNSPORTATION, MATRL MOVING"
         9 "9 MILITARY SPECIFIC OCCUPATIONS" ;

label define H790914X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790915X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790916X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790917X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790918X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790919X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790920X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790921X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790922X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H790923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790926X
         1 "1 YES"
         2 "2 NO" ;

label define H790927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790933X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790934X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790935X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790936X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790937X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790939X
         1 "1 YES"
         2 "2 NO" ;

label define H790940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790942X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H790949X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790950X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790951X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790952X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         235 "$235" ;

label define H790953X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790954X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790955X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790956X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790957X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790958X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790959X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790960X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790961X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790962X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790963X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790964X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790965X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790966X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790967X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790968X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790969X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790970X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790971X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790972X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790973X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790974X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790975X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790976X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790977X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790978X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790979X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790980X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790981X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790982X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790983X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790984X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790985X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790986X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790987X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790988X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790989X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790990X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790991X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790992X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790993X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790994X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790995X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790996X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790997X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790998X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H790999X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791000X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791001X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791002X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791003X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791004X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791005X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791006X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791007X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791008X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791009X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791010X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         235 "$235" ;

label define H791011X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791012X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791013X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791014X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791015X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791016X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791017X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791018X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791019X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791020X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791021X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791022X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791023X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791024X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791025X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791026X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791027X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791028X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791029X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791030X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791031X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791032X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791033X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791034X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791035X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791036X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791039X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791040X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791041X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791042X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791043X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791044X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791045X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791046X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791047X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791048X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791049X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791050X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791051X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791053X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791054X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791055X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791056X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791057X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791058X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791059X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791060X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791061X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791062X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791063X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791064X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791065X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791066X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791067X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791068X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791069X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791070X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791071X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791072X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791073X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791074X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791075X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791076X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791077X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791078X
         7 "7 PANEL 7"
         8 "8 PANEL 8" ;

label define H791079X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H791080X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791081X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791082X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791084X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791085X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791086X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791089X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791092X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791093X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791094X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791095X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791096X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791097X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791098X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791099X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791100X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791101X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791102X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791103X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791104X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791105X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791106X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791107X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791108X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791109X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791110X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791111X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791112X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791116X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H791117X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791119X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H791120X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H791121X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY HMO-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY HMO - NON-PLAN DRS COVERED"
         2 "2 COV BY HMO - NON-PLAN DRS NOT COVERED" ;

label define H791122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 VERY DIFFICULT"
         2 "2 SOMEWHAT DIFFICULT"
         3 "3 NOT TOO DIFFICULT"
         4 "4 NOT AT ALL DIFFICULT" ;

label define H791123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT APPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HOSPITAL CLINIC/OUTPATIENT DEPT"
         2 "2 HOSPITAL EMERGENCY ROOM"
         3 "3 NON-HOSPITAL PLACE" ;

label define H791126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H791129X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791130X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791131X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791132X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H791133X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H791134X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV GATEKPR-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY GATEKPR - NON-PLAN DRS COVERED"
         2 "2 COV BY GATEKPR-NON-PLAN DRS NOT COVERED" ;

label define H791135X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 A BIG PROBLEM"
         2 "2 A SMALL PROBLEM"
         3 "3 NOT A PROBLEM" ;

label define H791137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT AFFORD CARE"
         10 "10 DID NOT HAVE TIME OR TOOK TOO LONG"
         2 "2 INS CO WOULD NOT APPROVE/COVER/PAY"
         3 "3 DOCTOR REFUSED FAMILY INS PLAN"
         4 "4 PROBLEMS GETTING TO DOCTOR'S OFFICE"
         5 "5 DIFFERENT LANGUAGE"
         6 "6 COULD NOT GET TIME OFF WORK"
         7 "7 DK WHERE TO GO TO GET CARE"
         8 "8 WAS REFUSED SERVICES"
         9 "9 COULD NOT GET CHILD CARE"
         91 "91 OTHER" ;

label define H791138X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791139X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791140X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791141X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791142X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791143X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791144X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791145X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791146X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791147X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791148X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791149X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791150X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791151X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791152X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791153X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791154X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791155X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791156X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791157X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791158X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791159X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791160X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791161X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791162X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791163X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791164X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791165X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791166X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791167X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791168X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791169X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791170X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791171X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791172X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791173X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791174X
         1 "1 POOR/NEGATIVE"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H791175X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791176X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791177X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST-NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H791178X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H791179X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV DR LIST-NON-PLAN DRS NOT ASCERTAINED"
         1 "1 COV BY DR LIST - NON-PLAN DRS COVERED"
         2 "2 COV BY DR LIST-NON-PLAN DRS NOT COVERED" ;

label define H791180X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791181X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791182X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791183X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791184X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791185X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791186X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791187X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791188X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791189X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791190X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791191X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791192X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791193X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791194X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791195X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791196X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791197X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791198X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791199X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791200X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791201X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791202X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791203X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791204X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791205X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791206X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791207X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791208X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791209X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791210X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791211X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791212X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791213X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791214X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791215X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791216X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791217X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791218X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791219X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791220X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791221X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791222X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791223X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791224X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791225X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791226X
         -1 "-1 INAPPLICABLE"
         1 "1 FACILITY"
         2 "2 PERSON"
         3 "3 PERSON IN FACILITY PROVIDER" ;

label define H791227X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H791228X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H791229X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H791230X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H791231X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791232X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791233X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791234X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791235X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791236X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791237X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791238X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791239X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791240X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791241X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791242X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791243X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791244X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791245X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-DR LIST NOT ASCERTAINED"
         1 "1 COV BY PRIVATE PLAN W/DOCTOR LIST"
         2 "2 COV BY PRIV PLAN WITHOUT DR LIST"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791246X
         1 "1 YES"
         2 "2 NO" ;

label define H791247X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791248X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791249X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE - HMO NOT ASCERTAINED"
         1 "1 COV BY PRIVATE HMO"
         2 "2 COV BY PRIVATE INS - NOT HMO"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791250X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791251X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791252X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY PRIVATE-GATEKPR NOT ASCERTAINED"
         1 "1 COV BY PRIVATE GATEKEEPER PLAN"
         2 "2 COV BY PRIVATE INS - NOT GATEKEEPER"
         3 "3 NOT COV BY PRIVATE INS" ;

label define H791253X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H791254X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H791255X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H791256X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE RD: 4/2, 5/3"
         22 "22 LEAVE INSTITUTION ROUND: 4/2, 5/3"
         23 "23 LEAVES INSTITUTION & DIES RD: 4/2, 5/3"
         24 "24 DIES IN INST DURING ROUND: 4/2, 5/3"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO FAC, W/O KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H791257X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791258X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791259X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791260X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791261X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791262X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791263X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791264X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791265X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791266X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791267X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791268X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791269X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791270X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791271X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791272X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791273X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791274X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791275X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791276X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791277X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791278X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791279X
         -1 "-1 INAPPLICABLE"
         1 "1 ASIAN - NO OTHER RACE REPORTED"
         2 "2 ASIAN - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H791280X
         -1 "-1 INAPPLICABLE"
         1 "1 BLACK - NO OTHER RACE REPORTED"
         2 "2 BLACK - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H791281X
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK-NO OTH RACE/NOT HISPANIC"
         3 "3 PERSON IS ASIAN-NO OTH RACE/NOT HISPANIC"
         4 "4 OTHER RACE/NOT HISPANIC" ;

label define H791282X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 WHITE - OTHER RACE(S) REPORTED"
         3 "3 ALL OTHER RACE ASSIGNMENTS" ;

label define H791283X
         -1 "-1 INAPPLICABLE"
         1 "1 WHITE - NO OTHER RACE REPORTED"
         2 "2 BLACK - NO OTHER RACE REPORTED"
         3 "3 AMER INDIAN/ALASKA NATIVE - NO OTH RAC"
         4 "4 ASIAN - NO OTHER RACE REPORTED"
         5 "5 NATIVE HAWAIIAN/PACIFIC ISLANDER-NO OTHR"
         6 "6 MULTIPLE RACES REPORTED" ;

label define H791284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791288X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791290X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791291X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H791292X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H791293X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H791294X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H791295X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H791296X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H791297X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H791298X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H791299X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NEVER"
         2 "2 SOMETIMES"
         3 "3 USUALLY"
         4 "4 ALWAYS" ;

label define H791300X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791301X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791302X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791303X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H791304X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H791305X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H791306X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H791307X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H791308X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H791309X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H791310X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H791311X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791312X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791313X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H791314X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H791315X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H791316X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H791317X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H791318X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H791319X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H791320X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         15 "15 PERSONS IN RU"
         16 "16 PERSONS IN RU"
         17 "17 PERSONS IN RU"
         18 "18 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H791321X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791322X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791323X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791324X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791325X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791326X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791327X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791328X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791329X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791330X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791331X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791332X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791333X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791334X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791336X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791337X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791338X
         0 "0 NOT ELIGIBLE"
         1 "1 ELIGIBLE FOR SAQ - HAS SAQ DATA"
         2 "2 ELIGIBLE FOR SAQ - NO SAQ DATA" ;

label define H791339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791340X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791341X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791342X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791343X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791344X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791345X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791346X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ALWAYS"
         2 "2 NEARLY ALWAYS"
         3 "3 SOMETIMES"
         4 "4 SELDOM"
         5 "5 NEVER"
         6 "6 NEVER DRIVES/RIDES IN A CAR" ;

label define H791347X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791348X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791349X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791350X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791351X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791352X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H791353X
         -1 "-1 INAPPLICABLE"
         0 "0 NO"
         1 "1 YES" ;

label define H791354X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791355X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H791356X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791357X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791358X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791359X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791360X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791361X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H791362X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H791363X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H791364X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H791365X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H791366X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H791367X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H791368X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H791369X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791370X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791371X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED(WAGEIMP ONLY)"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK"
         7 "7 EDITED USING NHIS DATA" ;

label define H791372X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791373X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H791374X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791375X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791376X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H791377X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H791378X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS SEASONAL, NOT YEAR ROUND"
         2 "2 CMJ IS NOT SEASONAL, YEAR ROUND" ;

label define H791379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791395X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791396X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791397X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791398X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H791399X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H791400X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H791401X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791402X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791403X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H791404X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791405X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791406X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791407X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791408X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H791409X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H791410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791414X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791415X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG TERM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H791416X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H791417X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H791418X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 CMJ IS TEMPORARY"
         2 "2 CMJ IS NOT TEMPORARY" ;

label define H791419X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791420X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791421X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791422X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SORE THROAT"
         2 "2 OTHER SYMPTOMS" ;

label define H791425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 15 MINUTES"
         2 "2 15 TO 30 MINUTES"
         3 "3 31 TO 60 MINUTES (1 HOUR)"
         4 "4 61 TO 90 MINUTES"
         5 "5 91 MINUTES TO 120 MINUTES (2 HOURS)"
         6 "6 MORE THAN 120 MINUTES (2 HOURS)" ;

label define H791427X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791428X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791429X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791430X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791431X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791432X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791433X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791434X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791435X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791436X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791437X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791438X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791439X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791440X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791441X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791442X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791443X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791444X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791448X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791449X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791450X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791451X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791452X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791453X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791454X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791455X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791456X
         1 "1 YES"
         2 "2 NO" ;

label define H791457X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H791458X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H791459X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI EXTRA NOT ASCERTAINED"
         1 "1 COV BY TRICARE EXTRA"
         2 "2 COV BY TRICARE - NOT TRICARE EXTRA"
         3 "3 NOT COV BY TRICARE" ;

label define H791460X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791461X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791462X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791463X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791464X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H791465X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI FOR LIFE NOT ASCERTAINED"
         1 "1 COV BY TRICARE FOR LIFE"
         2 "2 COV BY TRICARE - NOT TRICARE FOR LIFE"
         3 "3 NOT COV BY TRICARE" ;

label define H791466X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791467X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791468X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791469X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791470X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H791471X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H791472X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV BY TRICARE-TRI PRIME NOT ASCERTAINED"
         1 "1 COV BY TRICARE PRIME"
         2 "2 COV BY TRICARE - NOT TRICARE PRIME"
         3 "3 NOT COV BY TRICARE" ;

label define H791473X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H791474X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H791475X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H791476X
         -1 "-1 INAPPLICABLE"
         -9 "-9 COV TRICARE-TRI STANDARD NOT ASCERTAINED"
         1 "1 COV BY TRICARE STANDARD"
         2 "2 COV BY TRICARE - NOT TRICARE STANDARD"
         3 "3 NOT COV BY TRICARE" ;

label define H791477X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791478X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791479X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791480X
         -1 "-1 INAPPLICABLE"
         1 "1 MD - GENERAL/FAMILY PRACTICE"
         10 "10 PHYSICIAN'S ASSISTANT"
         11 "11 OTHER NON-MD PROVIDER"
         12 "12 UNKNOWN"
         13 "13 MD - CARDIOLOGIST"
         14 "14 DOCTOR OF OSTEOPATHY"
         2 "2 MD - INTERNAL MEDICINE"
         3 "3 MD - PEDIATRICS"
         4 "4 MD - OB/GYN"
         5 "5 MD - SURGERY"
         6 "6 MD - OTHER"
         7 "7 CHIROPRACTOR"
         8 "8 NURSE"
         9 "9 NURSE PRACTITIONER" ;

label define H791481X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791483X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791484X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H791486X
         1 "1 YES"
         2 "2 NO" ;

label define H791487X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791488X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791489X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791491X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LESS THAN 1 YEAR"
         2 "2 1 - 4 YEARS"
         3 "3 5 - 9 YEARS"
         4 "4 10 - 14 YEARS"
         5 "5 15 YEARS OR MORE" ;

label define H791493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H791494X
         1 "1 ORIGINAL RESPONSE USED"
         3 "3 MISSING VALUES SET TO 0"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H791496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H791497X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H791499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H791500X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791501X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H791502X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791503X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791504X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791505X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791506X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791507X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791508X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791509X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791510X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791511X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791512X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791513X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791514X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791515X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791516X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791517X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791518X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791519X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791520X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791521X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791522X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791523X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791524X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791525X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791526X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791527X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791528X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791529X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791530X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791531X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791532X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H791533X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS" ;

label define H791534X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791535X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791536X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791537X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 WITHIN PAST 3 YEARS"
         4 "4 WITHIN PAST 5 YEARS"
         5 "5 MORE THAN 5 YEARS"
         6 "6 NEVER" ;

label define H791538X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791539X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791540X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791541X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791542X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791543X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791544X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791545X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791546X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 WITHIN PAST YEAR"
         2 "2 WITHIN PAST 2 YEARS"
         3 "3 MORE THAN 2 YEARS" ;

label define H791547X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791548X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791549X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H791555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY TRUE"
         2 "2 MOSTLY TRUE"
         3 "3 DON'T KNOW"
         4 "4 MOSTLY FALSE"
         5 "5 DEFINITELY FALSE" ;

label define H791559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H791561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H791562X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H791563X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H791564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEM"
         91 "91 SOME OTHER REASON" ;

label define H791565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HASN'T WORKED LONG ENOUGH"
         2 "2 DOESN'T WORK ENOUGH HOURS"
         3 "3 ON CALL"
         4 "4 MEDICAL PROBLEMS"
         91 "91 SOME OTHER REASON" ;

label define H791566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELDOM OR NEVER SICK"
         10 "10 INSURANCE-RELATED REASONS"
         11 "11 JOB-RELATED REASONS"
         12 "12 LOOKING FOR A NEW DOCTOR/NO DOCTOR YET"
         13 "13 USC DOCTOR IS SOMEWHERE ELSE"
         14 "14 DON'T LIKE/DON'T TRUST DOCTORS"
         17 "17 SELF/RELATIVE/FRIEND/COWORKER IS DR"
         2 "2 RECENTLY MOVED TO AREA"
         20 "20 WILL NOT GO TO THE DOCTOR"
         21 "21 PROBLEMS WITH TIME AND TRANSPORTATION"
         3 "3 DON'T KNOW WHERE TO GO"
         4 "4 USC IN AREA NOT AVAILABLE"
         5 "5 CAN'T FIND PROVIDER WHO SPEAKS LANGUAGE"
         6 "6 GOES DIFFERENT PLACES FOR DIFF NEEDS"
         7 "7 JUST CHANGED INSURANCE PLANS"
         8 "8 DON'T USE DOCS/TREAT SELF"
         9 "9 COST OF MEDICAL CARE"
         91 "91 OTHER REASON" ;

label define H791567X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791568X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791569X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791570X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791571X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791572X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791573X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         105 "$105" ;

label define H791574X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791576X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         865 "$865" ;

label define H791577X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791578X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         68 "$68" ;

label define H791579X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791580X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791581X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791582X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791583X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791584X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791585X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791586X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         3140 "$3140" ;

label define H791587X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791588X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791589X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791590X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4784 "$4784" ;

label define H791591X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791592X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         4727 "$4727" ;

label define H791593X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H791594X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACCELI42 H790001X;
label value ACTDTY31 H790002X;
label value ACTDTY42 H790003X;
label value ACTDTY53 H790004X;
label value ACTLIM31 H790005X;
label value ACTLIM53 H790006X;
label value ADACTI42 H790007X;
label value ADAPPT42 H790008X;
label value ADCAPE42 H790009X;
label value ADCLIM42 H790010X;
label value ADCMPD42 H790011X;
label value ADCMPM42 H790012X;
label value ADCMPY42 H790013X;
label value ADDAYA42 H790014X;
label value ADDEPR42 H790015X;
label value ADDOWN42 H790016X;
label value ADDRBP42 H790017X;
label value ADEXPL42 H790018X;
label value ADGENH42 H790019X;
label value ADHECR42 H790020X;
label value ADILCR42 H790021X;
label value ADILWW42 H790022X;
label value ADINSA42 H790023X;
label value ADINSB42 H790024X;
label value ADL3MO31 H790025X;
label value ADL3MO42 H790026X;
label value ADL3MO53 H790027X;
label value ADLANG42 H790028X;
label value ADLHLP31 H790029X;
label value ADLHLP42 H790030X;
label value ADLHLP53 H790031X;
label value ADLIST42 H790032X;
label value ADMALS42 H790033X;
label value ADMOBI42 H790034X;
label value ADMWLM42 H790035X;
label value ADNDCR42 H790036X;
label value ADNECP42 H790037X;
label value ADNRGY42 H790038X;
label value ADNSMK42 H790039X;
label value ADOVER42 H790040X;
label value ADPAIN42 H790041X;
label value ADPALS42 H790042X;
label value ADPAYN42 H790043X;
label value ADPRRE42 H790044X;
label value ADPRTM42 H790045X;
label value ADPRX42 H790046X;
label value ADPWLM42 H790047X;
label value ADRESP42 H790048X;
label value ADRISK42 H790049X;
label value ADRTCR42 H790050X;
label value ADRTWW42 H790051X;
label value ADSCAL42 H790052X;
label value ADSELF42 H790053X;
label value ADSMOK42 H790054X;
label value ADSOCA42 H790055X;
label value ADSPEC42 H790056X;
label value ADUPRO42 H790057X;
label value AFDC03 H790058X;
label value AFTHOU42 H790059X;
label value AIDHLP31 H790060X;
label value AIDHLP53 H790061X;
label value ALIIMP03 H790062X;
label value ALIMP03X H790063X;
label value AMAEXP03 H790064X;
label value AMAMCD03 H790065X;
label value AMAMCR03 H790066X;
label value AMAOFD03 H790067X;
label value AMAOPR03 H790068X;
label value AMAOPU03 H790069X;
label value AMAOSR03 H790070X;
label value AMAPRV03 H790071X;
label value AMASLF03 H790072X;
label value AMASST03 H790073X;
label value AMASTL03 H790074X;
label value AMATCH03 H790075X;
label value AMATRI03 H790076X;
label value AMAVA03 H790077X;
label value AMAWCP03 H790078X;
label value AMCEXP03 H790079X;
label value AMCHIR03 H790080X;
label value AMCMCD03 H790081X;
label value AMCMCR03 H790082X;
label value AMCOFD03 H790083X;
label value AMCOPR03 H790084X;
label value AMCOPU03 H790085X;
label value AMCOSR03 H790086X;
label value AMCPRV03 H790087X;
label value AMCSLF03 H790088X;
label value AMCSTL03 H790089X;
label value AMCTCH03 H790090X;
label value AMCTRI03 H790091X;
label value AMCVA03 H790092X;
label value AMCWCP03 H790093X;
label value AMDRC03 H790094X;
label value AMEEXP03 H790095X;
label value AMEMCD03 H790096X;
label value AMEMCR03 H790097X;
label value AMEOFD03 H790098X;
label value AMEOPR03 H790099X;
label value AMEOPU03 H790100X;
label value AMEOSR03 H790101X;
label value AMEPRV03 H790102X;
label value AMESLF03 H790103X;
label value AMESTL03 H790104X;
label value AMETCH03 H790105X;
label value AMETRI03 H790106X;
label value AMEVA03 H790107X;
label value AMEWCP03 H790108X;
label value AMNEXP03 H790109X;
label value AMNMCD03 H790110X;
label value AMNMCR03 H790111X;
label value AMNOFD03 H790112X;
label value AMNOPR03 H790113X;
label value AMNOPU03 H790114X;
label value AMNOSR03 H790115X;
label value AMNPRV03 H790116X;
label value AMNSLF03 H790117X;
label value AMNSTL03 H790118X;
label value AMNTCH03 H790119X;
label value AMNTRI03 H790120X;
label value AMNURS03 H790121X;
label value AMNVA03 H790122X;
label value AMNWCP03 H790123X;
label value AMOPTO03 H790124X;
label value AMTEXP03 H790125X;
label value AMTHER03 H790126X;
label value AMTMCD03 H790127X;
label value AMTMCR03 H790128X;
label value AMTOFD03 H790129X;
label value AMTOPR03 H790130X;
label value AMTOPU03 H790131X;
label value AMTOSR03 H790132X;
label value AMTOTC03 H790133X;
label value AMTPRV03 H790134X;
label value AMTSLF03 H790135X;
label value AMTSTL03 H790136X;
label value AMTTCH03 H790137X;
label value AMTTRI03 H790138X;
label value AMTVA03 H790139X;
label value AMTWCP03 H790140X;
label value ANGIDX53 H790141X;
label value ANYLIM03 H790142X;
label value APRDLM42 H790143X;
label value APRDLT42 H790144X;
label value APRTRM42 H790145X;
label value APRTRT42 H790146X;
label value ARTHDX53 H790147X;
label value ARTHTX53 H790148X;
label value ASACUT53 H790149X;
label value ASATAK53 H790150X;
label value ASDALY53 H790151X;
label value ASEVFL53 H790152X;
label value ASIANP42 H790153X;
label value ASMRCN53 H790154X;
label value ASPKFL53 H790155X;
label value ASPREV53 H790156X;
label value ASPRIN53 H790157X;
label value ASSTIL53 H790158X;
label value ASTHDX53 H790159X;
label value ASWNFL53 H790160X;
label value BEGRFD31 H790161X;
label value BEGRFD42 H790162X;
label value BEGRFD53 H790163X;
label value BEGRFM31 H790164X;
label value BEGRFM42 H790165X;
label value BEGRFM53 H790166X;
label value BEGRFY31 H790167X;
label value BEGRFY42 H790168X;
label value BEGRFY53 H790169X;
label value BENDIF31 H790170X;
label value BENDIF53 H790171X;
label value BLCKPR42 H790172X;
label value BLIND42 H790173X;
label value BMINDX53 H790174X;
label value BOOST42 H790175X;
label value BOWEL53 H790176X;
label value BPCHEK53 H790177X;
label value BPMLDX53 H790178X;
label value BPMONT53 H790179X;
label value BRSTEX53 H790180X;
label value BSNTY31 H790181X;
label value BSNTY42 H790182X;
label value BSNTY53 H790183X;
label value BUSIMP03 H790184X;
label value BUSNP03X H790185X;
label value CARECO42 H790186X;
label value CASHP03X H790187X;
label value CHAPPT42 H790188X;
label value CHBMIX42 H790189X;
label value CHCOUN42 H790190X;
label value CHDDX53 H790191X;
label value CHECK53 H790192X;
label value CHEMPB42 H790193X;
label value CHEXPL42 H790194X;
label value CHGJ3142 H790195X;
label value CHGJ4253 H790196X;
label value CHHECR42 H790197X;
label value CHILCR42 H790198X;
label value CHILWW42 H790199X;
label value CHLDP03X H790200X;
label value CHLICO42 H790201X;
label value CHLIHB42 H790202X;
label value CHLIMI42 H790203X;
label value CHLIMP03 H790204X;
label value CHLIST42 H790205X;
label value CHNDCR42 H790206X;
label value CHNECP42 H790207X;
label value CHOIC31 H790208X;
label value CHOIC42 H790209X;
label value CHOIC53 H790210X;
label value CHOLCK53 H790211X;
label value CHPMCN42 H790212X;
label value CHPMED42 H790213X;
label value CHPMHB42 H790214X;
label value CHPRRE42 H790215X;
label value CHPRTM42 H790216X;
label value CHRESP42 H790217X;
label value CHRTCR42 H790218X;
label value CHRTWW42 H790219X;
label value CHSERV42 H790220X;
label value CHSPEC42 H790221X;
label value CHSRCN42 H790222X;
label value CHSRHB42 H790223X;
label value CHTHCO42 H790224X;
label value CHTHER42 H790225X;
label value CHTHHB42 H790226X;
label value CLMDEP03 H790227X;
label value CLMHIP03 H790228X;
label value COGLIM31 H790229X;
label value COGLIM53 H790230X;
label value COVRMM H790231X;
label value COVRYY H790232X;
label value CSHCN42 H790233X;
label value CSHIMP03 H790234X;
label value CSTSVM42 H790235X;
label value CSTSVT42 H790236X;
label value DADPRO42 H790237X;
label value DDBDYS31 H790238X;
label value DDBDYS42 H790239X;
label value DDBDYS53 H790240X;
label value DDNSCL31 H790241X;
label value DDNSCL42 H790242X;
label value DDNSCL53 H790243X;
label value DDNWRK31 H790244X;
label value DDNWRK42 H790245X;
label value DDNWRK53 H790246X;
label value DEAF42 H790247X;
label value DECIDE42 H790248X;
label value DEDUCT03 H790249X;
label value DENTAL42 H790250X;
label value DENTCK53 H790251X;
label value DENTIN31 H790252X;
label value DENTIN42 H790253X;
label value DENTIN53 H790254X;
label value DEPDNT03 H790255X;
label value DFTOUS42 H790256X;
label value DIABDX53 H790257X;
label value DIDSERVE H790258X;
label value DIFFPL42 H790259X;
label value DIFFWG31 H790260X;
label value DIFFWG42 H790261X;
label value DIFFWG53 H790262X;
label value DISVW31X H790263X;
label value DISVW42X H790264X;
label value DISVW53X H790265X;
label value DIVDP03X H790266X;
label value DIVIMP03 H790267X;
label value DKWHRU42 H790268X;
label value DNDLAY42 H790269X;
label value DNDLPR42 H790270X;
label value DNDLRS42 H790271X;
label value DNUNAB42 H790272X;
label value DNUNPR42 H790273X;
label value DNUNRS42 H790274X;
label value DOBMM H790275X;
label value DOBYY H790276X;
label value DOCELS42 H790277X;
label value DPINRU03 H790278X;
label value DPOTSD03 H790279X;
label value DRTHRT53 H790280X;
label value DSA1C53 H790281X;
label value DSCKFT53 H790282X;
label value DSDIA53 H790283X;
label value DSDIET53 H790284X;
label value DSEB0253 H790285X;
label value DSEY0253 H790286X;
label value DSEY0353 H790287X;
label value DSEY0453 H790288X;
label value DSEYNV53 H790289X;
label value DSEYPR53 H790290X;
label value DSINSU53 H790291X;
label value DSKIDN53 H790292X;
label value DSMED53 H790293X;
label value DSPRX53 H790294X;
label value DVGEN03 H790295X;
label value DVGEXP03 H790296X;
label value DVGMCD03 H790297X;
label value DVGMCR03 H790298X;
label value DVGOFD03 H790299X;
label value DVGOPR03 H790300X;
label value DVGOPU03 H790301X;
label value DVGOSR03 H790302X;
label value DVGPRV03 H790303X;
label value DVGSLF03 H790304X;
label value DVGSTL03 H790305X;
label value DVGTCH03 H790306X;
label value DVGTRI03 H790307X;
label value DVGVA03 H790308X;
label value DVGWCP03 H790309X;
label value DVOEXP03 H790310X;
label value DVOMCD03 H790311X;
label value DVOMCR03 H790312X;
label value DVOOFD03 H790313X;
label value DVOOPR03 H790314X;
label value DVOOPU03 H790315X;
label value DVOOSR03 H790316X;
label value DVOPRV03 H790317X;
label value DVORTH03 H790318X;
label value DVOSLF03 H790319X;
label value DVOSTL03 H790320X;
label value DVOTCH03 H790321X;
label value DVOTRI03 H790322X;
label value DVOVA03 H790323X;
label value DVOWCP03 H790324X;
label value DVTEXP03 H790325X;
label value DVTMCD03 H790326X;
label value DVTMCR03 H790327X;
label value DVTOFD03 H790328X;
label value DVTOPR03 H790329X;
label value DVTOPU03 H790330X;
label value DVTOSR03 H790331X;
label value DVTOT03 H790332X;
label value DVTPRV03 H790333X;
label value DVTSLF03 H790334X;
label value DVTSTL03 H790335X;
label value DVTTCH03 H790336X;
label value DVTTRI03 H790337X;
label value DVTVA03 H790338X;
label value DVTWCP03 H790339X;
label value EATHLT42 H790340X;
label value EDUCYEAR H790341X;
label value EICRDT03 H790342X;
label value ELGRND03 H790343X;
label value ELGRND31 H790344X;
label value ELGRND42 H790345X;
label value ELGRND53 H790346X;
label value EMPHDX53 H790347X;
label value EMPST31 H790348X;
label value EMPST42 H790349X;
label value EMPST53 H790350X;
label value ENDRFD03 H790351X;
label value ENDRFD31 H790352X;
label value ENDRFD42 H790353X;
label value ENDRFD53 H790354X;
label value ENDRFM03 H790355X;
label value ENDRFM31 H790356X;
label value ENDRFM42 H790357X;
label value ENDRFM53 H790358X;
label value ENDRFY03 H790359X;
label value ENDRFY31 H790360X;
label value ENDRFY42 H790361X;
label value ENDRFY53 H790362X;
label value ENGHME42 H790363X;
label value ENGSPK42 H790364X;
label value EQU42 H790365X;
label value ERDEXP03 H790366X;
label value ERDMCD03 H790367X;
label value ERDMCR03 H790368X;
label value ERDOFD03 H790369X;
label value ERDOPR03 H790370X;
label value ERDOPU03 H790371X;
label value ERDOSR03 H790372X;
label value ERDPRV03 H790373X;
label value ERDSLF03 H790374X;
label value ERDSTL03 H790375X;
label value ERDTCH03 H790376X;
label value ERDTRI03 H790377X;
label value ERDVA03 H790378X;
label value ERDWCP03 H790379X;
label value ERFEXP03 H790380X;
label value ERFMCD03 H790381X;
label value ERFMCR03 H790382X;
label value ERFOFD03 H790383X;
label value ERFOPR03 H790384X;
label value ERFOPU03 H790385X;
label value ERFOSR03 H790386X;
label value ERFPRV03 H790387X;
label value ERFSLF03 H790388X;
label value ERFSTL03 H790389X;
label value ERFTCH03 H790390X;
label value ERFTRI03 H790391X;
label value ERFVA03 H790392X;
label value ERFWCP03 H790393X;
label value ERTOT03 H790394X;
label value EVRETIRE H790395X;
label value EVRUNAT H790396X;
label value EVRUNINS H790397X;
label value EVRWRK H790398X;
label value EXPLOP42 H790399X;
label value EXRCIS53 H790400X;
label value FACLPR42 H790401X;
label value FAMRFPYR H790402X;
label value FAMSZE03 H790403X;
label value FAMSZE31 H790404X;
label value FAMSZE42 H790405X;
label value FAMSZE53 H790406X;
label value FCRP1231 H790407X;
label value FILEDR03 H790408X;
label value FILER03 H790409X;
label value FLSTAT03 H790410X;
label value FLUSHT53 H790411X;
label value FMRS1231 H790412X;
label value FNGRDF31 H790413X;
label value FNGRDF53 H790414X;
label value FOODCT03 H790415X;
label value FOODMN03 H790416X;
label value FOODST03 H790417X;
label value FOODVL03 H790418X;
label value FTSTU03X H790419X;
label value FTSTU31X H790420X;
label value FTSTU42X H790421X;
label value FTSTU53X H790422X;
label value GDCPBM42 H790423X;
label value GDCPBT42 H790424X;
label value GENDRP42 H790425X;
label value GOTOUS42 H790426X;
label value HAVEUS42 H790427X;
label value HAVFUN42 H790428X;
label value HEARAD42 H790429X;
label value HEARDI42 H790430X;
label value HEARMO42 H790431X;
label value HEARNG42 H790432X;
label value HEARSM42 H790433X;
label value HELD31X H790434X;
label value HELD42X H790435X;
label value HELD53X H790436X;
label value HELMET42 H790437X;
label value HHAEXP03 H790438X;
label value HHAGD03 H790439X;
label value HHAMCD03 H790440X;
label value HHAMCR03 H790441X;
label value HHAOFD03 H790442X;
label value HHAOPR03 H790443X;
label value HHAOPU03 H790444X;
label value HHAOSR03 H790445X;
label value HHAPRV03 H790446X;
label value HHASLF03 H790447X;
label value HHASTL03 H790448X;
label value HHATCH03 H790449X;
label value HHATRI03 H790450X;
label value HHAVA03 H790451X;
label value HHAWCP03 H790452X;
label value HHINDD03 H790453X;
label value HHINFD03 H790454X;
label value HHNEXP03 H790455X;
label value HHNMCD03 H790456X;
label value HHNMCR03 H790457X;
label value HHNOFD03 H790458X;
label value HHNOPR03 H790459X;
label value HHNOPU03 H790460X;
label value HHNOSR03 H790461X;
label value HHNPRV03 H790462X;
label value HHNSLF03 H790463X;
label value HHNSTL03 H790464X;
label value HHNTCH03 H790465X;
label value HHNTRI03 H790466X;
label value HHNVA03 H790467X;
label value HHNWCP03 H790468X;
label value HHTOTD03 H790469X;
label value HIBPDX53 H790470X;
label value HIDEGYR H790471X;
label value HISPANX H790472X;
label value HISPCAT H790473X;
label value HLTHLF42 H790474X;
label value HOMEBH42 H790475X;
label value HOUR31 H790476X;
label value HOUR42 H790477X;
label value HOUR53 H790478X;
label value HPDAP03 H790479X;
label value HPDAU03 H790480X;
label value HPDDE03 H790481X;
label value HPDFE03 H790482X;
label value HPDJA03 H790483X;
label value HPDJL03 H790484X;
label value HPDJU03 H790485X;
label value HPDMA03 H790486X;
label value HPDMY03 H790487X;
label value HPDNO03 H790488X;
label value HPDOC03 H790489X;
label value HPDSE03 H790490X;
label value HPEAP03 H790491X;
label value HPEAU03 H790492X;
label value HPEDE03 H790493X;
label value HPEFE03 H790494X;
label value HPEJA03 H790495X;
label value HPEJL03 H790496X;
label value HPEJU03 H790497X;
label value HPEMA03 H790498X;
label value HPEMY03 H790499X;
label value HPENO03 H790500X;
label value HPEOC03 H790501X;
label value HPESE03 H790502X;
label value HPNAP03 H790503X;
label value HPNAU03 H790504X;
label value HPNDE03 H790505X;
label value HPNFE03 H790506X;
label value HPNJA03 H790507X;
label value HPNJL03 H790508X;
label value HPNJU03 H790509X;
label value HPNMA03 H790510X;
label value HPNMY03 H790511X;
label value HPNNO03 H790512X;
label value HPNOC03 H790513X;
label value HPNSE03 H790514X;
label value HPOAP03 H790515X;
label value HPOAU03 H790516X;
label value HPODE03 H790517X;
label value HPOFE03 H790518X;
label value HPOJA03 H790519X;
label value HPOJL03 H790520X;
label value HPOJU03 H790521X;
label value HPOMA03 H790522X;
label value HPOMY03 H790523X;
label value HPONO03 H790524X;
label value HPOOC03 H790525X;
label value HPOSE03 H790526X;
label value HPRAP03 H790527X;
label value HPRAU03 H790528X;
label value HPRDE03 H790529X;
label value HPRFE03 H790530X;
label value HPRJA03 H790531X;
label value HPRJL03 H790532X;
label value HPRJU03 H790533X;
label value HPRMA03 H790534X;
label value HPRMY03 H790535X;
label value HPRNO03 H790536X;
label value HPROC03 H790537X;
label value HPRSE03 H790538X;
label value HPSAP03 H790539X;
label value HPSAU03 H790540X;
label value HPSDE03 H790541X;
label value HPSFE03 H790542X;
label value HPSJA03 H790543X;
label value HPSJL03 H790544X;
label value HPSJU03 H790545X;
label value HPSMA03 H790546X;
label value HPSMY03 H790547X;
label value HPSNO03 H790548X;
label value HPSOC03 H790549X;
label value HPSSE03 H790550X;
label value HRHOW31 H790551X;
label value HRHOW42 H790552X;
label value HRHOW53 H790553X;
label value HRWG31X H790554X;
label value HRWG42X H790555X;
label value HRWG53X H790556X;
label value HRWGIM31 H790557X;
label value HRWGIM42 H790558X;
label value HRWGIM53 H790559X;
label value HSELIM31 H790560X;
label value HSELIM53 H790561X;
label value HSPLAP42 H790562X;
label value HYSTER53 H790563X;
label value IADL3M31 H790564X;
label value IADL3M42 H790565X;
label value IADL3M53 H790566X;
label value IADLHP31 H790567X;
label value IADLHP42 H790568X;
label value IADLHP53 H790569X;
label value INDCAT31 H790570X;
label value INDCAT42 H790571X;
label value INDCAT53 H790572X;
label value INS03X H790573X;
label value INS31X H790574X;
label value INS42X H790575X;
label value INS53X H790576X;
label value INSAP03X H790577X;
label value INSAT03X H790578X;
label value INSAT31X H790579X;
label value INSAT42X H790580X;
label value INSAT53X H790581X;
label value INSAU03X H790582X;
label value INSC1231 H790583X;
label value INSCOP03 H790584X;
label value INSCOP31 H790585X;
label value INSCOP42 H790586X;
label value INSCOP53 H790587X;
label value INSCOPE H790588X;
label value INSCOV03 H790589X;
label value INSDE03X H790590X;
label value INSENDMM H790591X;
label value INSENDYY H790592X;
label value INSFE03X H790593X;
label value INSJA03X H790594X;
label value INSJL03X H790595X;
label value INSJU03X H790596X;
label value INSMA03X H790597X;
label value INSMY03X H790598X;
label value INSNO03X H790599X;
label value INSOC03X H790600X;
label value INSRPL42 H790601X;
label value INSSE03X H790602X;
label value INTIMP03 H790603X;
label value INTRP03X H790604X;
label value INTVLANG H790605X;
label value IPDEXP03 H790606X;
label value IPDIS03 H790607X;
label value IPDMCD03 H790608X;
label value IPDMCR03 H790609X;
label value IPDOFD03 H790610X;
label value IPDOPR03 H790611X;
label value IPDOPU03 H790612X;
label value IPDOSR03 H790613X;
label value IPDPRV03 H790614X;
label value IPDSLF03 H790615X;
label value IPDSTL03 H790616X;
label value IPDTCH03 H790617X;
label value IPDTRI03 H790618X;
label value IPDVA03 H790619X;
label value IPDWCP03 H790620X;
label value IPFEXP03 H790621X;
label value IPFMCD03 H790622X;
label value IPFMCR03 H790623X;
label value IPFOFD03 H790624X;
label value IPFOPR03 H790625X;
label value IPFOPU03 H790626X;
label value IPFOSR03 H790627X;
label value IPFPRV03 H790628X;
label value IPFSLF03 H790629X;
label value IPFSTL03 H790630X;
label value IPFTCH03 H790631X;
label value IPFTRI03 H790632X;
label value IPFVA03 H790633X;
label value IPFWCP03 H790634X;
label value IPNGTD03 H790635X;
label value IPZERO03 H790636X;
label value IRAIMP03 H790637X;
label value IRASP03X H790638X;
label value JNTPID03 H790639X;
label value JOBORG31 H790640X;
label value JOBORG42 H790641X;
label value JOBORG53 H790642X;
label value JOBRSN42 H790643X;
label value JTINRU03 H790644X;
label value JTPAIN53 H790645X;
label value KEYNESS H790646X;
label value KIDPRO42 H790647X;
label value KNOWDR42 H790648X;
label value LANGHM42 H790649X;
label value LANGPR42 H790650X;
label value LAPBLT42 H790651X;
label value LFTDIF31 H790652X;
label value LFTDIF53 H790653X;
label value LKINFM42 H790654X;
label value LKINFT42 H790655X;
label value LOCATN42 H790656X;
label value LSHLTH42 H790657X;
label value LSTETH53 H790658X;
label value MAMOGR53 H790659X;
label value MARRY03X H790660X;
label value MARRY31X H790661X;
label value MARRY42X H790662X;
label value MARRY53X H790663X;
label value MCAID03 H790664X;
label value MCAID03X H790665X;
label value MCAID31 H790666X;
label value MCAID31X H790667X;
label value MCAID42 H790668X;
label value MCAID42X H790669X;
label value MCAID53 H790670X;
label value MCAID53X H790671X;
label value MCARE03 H790672X;
label value MCARE03X H790673X;
label value MCARE31 H790674X;
label value MCARE31X H790675X;
label value MCARE42 H790676X;
label value MCARE42X H790677X;
label value MCARE53 H790678X;
label value MCARE53X H790679X;
label value MCDAP03 H790680X;
label value MCDAP03X H790681X;
label value MCDAT03X H790682X;
label value MCDAT31X H790683X;
label value MCDAT42X H790684X;
label value MCDAT53X H790685X;
label value MCDAU03 H790686X;
label value MCDAU03X H790687X;
label value MCDDE03 H790688X;
label value MCDDE03X H790689X;
label value MCDEV03 H790690X;
label value MCDFE03 H790691X;
label value MCDFE03X H790692X;
label value MCDHMO03 H790693X;
label value MCDHMO31 H790694X;
label value MCDHMO42 H790695X;
label value MCDJA03 H790696X;
label value MCDJA03X H790697X;
label value MCDJL03 H790698X;
label value MCDJL03X H790699X;
label value MCDJU03 H790700X;
label value MCDJU03X H790701X;
label value MCDMA03 H790702X;
label value MCDMA03X H790703X;
label value MCDMC03 H790704X;
label value MCDMC31 H790705X;
label value MCDMC42 H790706X;
label value MCDMY03 H790707X;
label value MCDMY03X H790708X;
label value MCDNO03 H790709X;
label value MCDNO03X H790710X;
label value MCDOC03 H790711X;
label value MCDOC03X H790712X;
label value MCDSE03 H790713X;
label value MCDSE03X H790714X;
label value MCRAP03 H790715X;
label value MCRAP03X H790716X;
label value MCRAU03 H790717X;
label value MCRAU03X H790718X;
label value MCRDE03 H790719X;
label value MCRDE03X H790720X;
label value MCREV03 H790721X;
label value MCRFE03 H790722X;
label value MCRFE03X H790723X;
label value MCRJA03 H790724X;
label value MCRJA03X H790725X;
label value MCRJL03 H790726X;
label value MCRJL03X H790727X;
label value MCRJU03 H790728X;
label value MCRJU03X H790729X;
label value MCRMA03 H790730X;
label value MCRMA03X H790731X;
label value MCRMY03 H790732X;
label value MCRMY03X H790733X;
label value MCRNO03 H790734X;
label value MCRNO03X H790735X;
label value MCROC03 H790736X;
label value MCROC03X H790737X;
label value MCRSE03 H790738X;
label value MCRSE03X H790739X;
label value MCS42 H790740X;
label value MDDLAY42 H790741X;
label value MDDLPR42 H790742X;
label value MDDLRS42 H790743X;
label value MDUNAB42 H790744X;
label value MDUNPR42 H790745X;
label value MDUNRS42 H790746X;
label value MESBPR42 H790747X;
label value MESHGT42 H790748X;
label value MESVIS42 H790749X;
label value MESWGT42 H790750X;
label value MIDX53 H790751X;
label value MILDIF31 H790752X;
label value MILDIF53 H790753X;
label value MINORP42 H790754X;
label value MNHLTH31 H790755X;
label value MNHLTH42 H790756X;
label value MNHLTH53 H790757X;
label value MOMPRO42 H790758X;
label value MORE31 H790759X;
label value MORE42 H790760X;
label value MORE53 H790761X;
label value MORECOVR H790762X;
label value MORJOB31 H790763X;
label value MORJOB42 H790764X;
label value MORJOB53 H790765X;
label value MSA03 H790766X;
label value MSA31 H790767X;
label value MSA42 H790768X;
label value MSA53 H790769X;
label value MYSELF42 H790770X;
label value NATAMP42 H790771X;
label value NERVAF42 H790772X;
label value NEVILL42 H790773X;
label value NEWARE42 H790774X;
label value NEWDOC42 H790775X;
label value NOASPR53 H790776X;
label value NOFAT53 H790777X;
label value NOGODR42 H790778X;
label value NOINSBEF H790779X;
label value NOINSTM H790780X;
label value NOINUNIT H790781X;
label value NOLIKE42 H790782X;
label value NOREAS42 H790783X;
label value NOSMOK42 H790784X;
label value NUMEMP31 H790785X;
label value NUMEMP42 H790786X;
label value NUMEMP53 H790787X;
label value NWK31 H790788X;
label value NWK42 H790789X;
label value NWK53 H790790X;
label value OBAEXP03 H790791X;
label value OBAMCD03 H790792X;
label value OBAMCR03 H790793X;
label value OBAOFD03 H790794X;
label value OBAOPR03 H790795X;
label value OBAOPU03 H790796X;
label value OBAOSR03 H790797X;
label value OBAPRV03 H790798X;
label value OBASLF03 H790799X;
label value OBASST03 H790800X;
label value OBASTL03 H790801X;
label value OBATCH03 H790802X;
label value OBATRI03 H790803X;
label value OBAVA03 H790804X;
label value OBAWCP03 H790805X;
label value OBCEXP03 H790806X;
label value OBCHIR03 H790807X;
label value OBCMCD03 H790808X;
label value OBCMCR03 H790809X;
label value OBCOFD03 H790810X;
label value OBCOPR03 H790811X;
label value OBCOPU03 H790812X;
label value OBCOSR03 H790813X;
label value OBCPRV03 H790814X;
label value OBCSLF03 H790815X;
label value OBCSTL03 H790816X;
label value OBCTCH03 H790817X;
label value OBCTRI03 H790818X;
label value OBCVA03 H790819X;
label value OBCWCP03 H790820X;
label value OBDEXP03 H790821X;
label value OBDMCD03 H790822X;
label value OBDMCR03 H790823X;
label value OBDOFD03 H790824X;
label value OBDOPR03 H790825X;
label value OBDOPU03 H790826X;
label value OBDOSR03 H790827X;
label value OBDPRV03 H790828X;
label value OBDRV03 H790829X;
label value OBDSLF03 H790830X;
label value OBDSTL03 H790831X;
label value OBDTCH03 H790832X;
label value OBDTRI03 H790833X;
label value OBDVA03 H790834X;
label value OBDWCP03 H790835X;
label value OBEEXP03 H790836X;
label value OBEMCD03 H790837X;
label value OBEMCR03 H790838X;
label value OBEOFD03 H790839X;
label value OBEOPR03 H790840X;
label value OBEOPU03 H790841X;
label value OBEOSR03 H790842X;
label value OBEPRV03 H790843X;
label value OBESLF03 H790844X;
label value OBESTL03 H790845X;
label value OBETCH03 H790846X;
label value OBETRI03 H790847X;
label value OBEVA03 H790848X;
label value OBEWCP03 H790849X;
label value OBNEXP03 H790850X;
label value OBNMCD03 H790851X;
label value OBNMCR03 H790852X;
label value OBNOFD03 H790853X;
label value OBNOPR03 H790854X;
label value OBNOPU03 H790855X;
label value OBNOSR03 H790856X;
label value OBNPRV03 H790857X;
label value OBNSLF03 H790858X;
label value OBNSTL03 H790859X;
label value OBNTCH03 H790860X;
label value OBNTRI03 H790861X;
label value OBNURS03 H790862X;
label value OBNVA03 H790863X;
label value OBNWCP03 H790864X;
label value OBOEXP03 H790865X;
label value OBOMCD03 H790866X;
label value OBOMCR03 H790867X;
label value OBOOFD03 H790868X;
label value OBOOPR03 H790869X;
label value OBOOPU03 H790870X;
label value OBOOSR03 H790871X;
label value OBOPRV03 H790872X;
label value OBOPTO03 H790873X;
label value OBOSLF03 H790874X;
label value OBOSTL03 H790875X;
label value OBOTCH03 H790876X;
label value OBOTHV03 H790877X;
label value OBOTRI03 H790878X;
label value OBOVA03 H790879X;
label value OBOWCP03 H790880X;
label value OBTEXP03 H790881X;
label value OBTHER03 H790882X;
label value OBTMCD03 H790883X;
label value OBTMCR03 H790884X;
label value OBTOFD03 H790885X;
label value OBTOPR03 H790886X;
label value OBTOPU03 H790887X;
label value OBTOSR03 H790888X;
label value OBTOTV03 H790889X;
label value OBTPRV03 H790890X;
label value OBTSLF03 H790891X;
label value OBTSTL03 H790892X;
label value OBTTCH03 H790893X;
label value OBTTRI03 H790894X;
label value OBTVA03 H790895X;
label value OBTWCP03 H790896X;
label value OBVEXP03 H790897X;
label value OBVMCD03 H790898X;
label value OBVMCR03 H790899X;
label value OBVOFD03 H790900X;
label value OBVOPR03 H790901X;
label value OBVOPU03 H790902X;
label value OBVOSR03 H790903X;
label value OBVPRV03 H790904X;
label value OBVSLF03 H790905X;
label value OBVSTL03 H790906X;
label value OBVTCH03 H790907X;
label value OBVTRI03 H790908X;
label value OBVVA03 H790909X;
label value OBVWCP03 H790910X;
label value OCCCAT31 H790911X;
label value OCCCAT42 H790912X;
label value OCCCAT53 H790913X;
label value OFFER31X H790914X;
label value OFFER42X H790915X;
label value OFFER53X H790916X;
label value OFFHOU42 H790917X;
label value OFREMP31 H790918X;
label value OFREMP42 H790919X;
label value OFREMP53 H790920X;
label value OHRTDX53 H790921X;
label value ONGONG42 H790922X;
label value OPAAP03 H790923X;
label value OPAAU03 H790924X;
label value OPADE03 H790925X;
label value OPAEV03 H790926X;
label value OPAFE03 H790927X;
label value OPAJA03 H790928X;
label value OPAJL03 H790929X;
label value OPAJU03 H790930X;
label value OPAMA03 H790931X;
label value OPAMY03 H790932X;
label value OPANO03 H790933X;
label value OPAOC03 H790934X;
label value OPASE03 H790935X;
label value OPBAP03 H790936X;
label value OPBAU03 H790937X;
label value OPBDE03 H790938X;
label value OPBEV03 H790939X;
label value OPBFE03 H790940X;
label value OPBJA03 H790941X;
label value OPBJL03 H790942X;
label value OPBJU03 H790943X;
label value OPBMA03 H790944X;
label value OPBMY03 H790945X;
label value OPBNO03 H790946X;
label value OPBOC03 H790947X;
label value OPBSE03 H790948X;
label value OPDEXP03 H790949X;
label value OPDMCD03 H790950X;
label value OPDMCR03 H790951X;
label value OPDOFD03 H790952X;
label value OPDOPR03 H790953X;
label value OPDOPU03 H790954X;
label value OPDOSR03 H790955X;
label value OPDPRV03 H790956X;
label value OPDRV03 H790957X;
label value OPDSLF03 H790958X;
label value OPDSTL03 H790959X;
label value OPDTCH03 H790960X;
label value OPDTRI03 H790961X;
label value OPDVA03 H790962X;
label value OPDWCP03 H790963X;
label value OPFEXP03 H790964X;
label value OPFMCD03 H790965X;
label value OPFMCR03 H790966X;
label value OPFOFD03 H790967X;
label value OPFOPR03 H790968X;
label value OPFOPU03 H790969X;
label value OPFOSR03 H790970X;
label value OPFPRV03 H790971X;
label value OPFSLF03 H790972X;
label value OPFSTL03 H790973X;
label value OPFTCH03 H790974X;
label value OPFTRI03 H790975X;
label value OPFVA03 H790976X;
label value OPFWCP03 H790977X;
label value OPOEXP03 H790978X;
label value OPOMCD03 H790979X;
label value OPOMCR03 H790980X;
label value OPOOFD03 H790981X;
label value OPOOPR03 H790982X;
label value OPOOPU03 H790983X;
label value OPOOSR03 H790984X;
label value OPOPRV03 H790985X;
label value OPOSLF03 H790986X;
label value OPOSTL03 H790987X;
label value OPOTCH03 H790988X;
label value OPOTHV03 H790989X;
label value OPOTRI03 H790990X;
label value OPOVA03 H790991X;
label value OPOWCP03 H790992X;
label value OPPEXP03 H790993X;
label value OPPMCD03 H790994X;
label value OPPMCR03 H790995X;
label value OPPOFD03 H790996X;
label value OPPOPR03 H790997X;
label value OPPOPU03 H790998X;
label value OPPOSR03 H790999X;
label value OPPPRV03 H791000X;
label value OPPSLF03 H791001X;
label value OPPSTL03 H791002X;
label value OPPTCH03 H791003X;
label value OPPTRI03 H791004X;
label value OPPVA03 H791005X;
label value OPPWCP03 H791006X;
label value OPSEXP03 H791007X;
label value OPSMCD03 H791008X;
label value OPSMCR03 H791009X;
label value OPSOFD03 H791010X;
label value OPSOPR03 H791011X;
label value OPSOPU03 H791012X;
label value OPSOSR03 H791013X;
label value OPSPRV03 H791014X;
label value OPSSLF03 H791015X;
label value OPSSTL03 H791016X;
label value OPSTCH03 H791017X;
label value OPSTRI03 H791018X;
label value OPSVA03 H791019X;
label value OPSWCP03 H791020X;
label value OPTOTV03 H791021X;
label value OPVEXP03 H791022X;
label value OPVMCD03 H791023X;
label value OPVMCR03 H791024X;
label value OPVOFD03 H791025X;
label value OPVOPR03 H791026X;
label value OPVOPU03 H791027X;
label value OPVOSR03 H791028X;
label value OPVPRV03 H791029X;
label value OPVSLF03 H791030X;
label value OPVSTL03 H791031X;
label value OPVTCH03 H791032X;
label value OPVTRI03 H791033X;
label value OPVVA03 H791034X;
label value OPVWCP03 H791035X;
label value OTHDYS31 H791036X;
label value OTHDYS42 H791037X;
label value OTHDYS53 H791038X;
label value OTHEXP03 H791039X;
label value OTHIMP03 H791040X;
label value OTHINS42 H791041X;
label value OTHMCD03 H791042X;
label value OTHMCR03 H791043X;
label value OTHNDD31 H791044X;
label value OTHNDD42 H791045X;
label value OTHNDD53 H791046X;
label value OTHOFD03 H791047X;
label value OTHOPR03 H791048X;
label value OTHOPU03 H791049X;
label value OTHOSR03 H791050X;
label value OTHPRV03 H791051X;
label value OTHRCP42 H791052X;
label value OTHREA42 H791053X;
label value OTHRP03X H791054X;
label value OTHSLF03 H791055X;
label value OTHSTL03 H791056X;
label value OTHTCH03 H791057X;
label value OTHTRI03 H791058X;
label value OTHVA03 H791059X;
label value OTHWCP03 H791060X;
label value OTPAAT03 H791061X;
label value OTPAAT31 H791062X;
label value OTPAAT42 H791063X;
label value OTPAAT53 H791064X;
label value OTPBAT03 H791065X;
label value OTPBAT31 H791066X;
label value OTPBAT42 H791067X;
label value OTPBAT53 H791068X;
label value OTPUBA03 H791069X;
label value OTPUBA31 H791070X;
label value OTPUBA42 H791071X;
label value OTPUBA53 H791072X;
label value OTPUBB03 H791073X;
label value OTPUBB31 H791074X;
label value OTPUBB42 H791075X;
label value OTPUBB53 H791076X;
label value PACISP42 H791077X;
label value PANEL03 H791078X;
label value PAPSMR53 H791079X;
label value PAYDR31 H791080X;
label value PAYDR42 H791081X;
label value PAYDR53 H791082X;
label value PAYVAC31 H791083X;
label value PAYVAC42 H791084X;
label value PAYVAC53 H791085X;
label value PBINFM42 H791086X;
label value PBINFT42 H791087X;
label value PBPWKM42 H791088X;
label value PBPWKT42 H791089X;
label value PBSVCM42 H791090X;
label value PBSVCT42 H791091X;
label value PDKAP03 H791092X;
label value PDKAU03 H791093X;
label value PDKDE03 H791094X;
label value PDKFE03 H791095X;
label value PDKJA03 H791096X;
label value PDKJL03 H791097X;
label value PDKJU03 H791098X;
label value PDKMA03 H791099X;
label value PDKMY03 H791100X;
label value PDKNO03 H791101X;
label value PDKOC03 H791102X;
label value PDKSE03 H791103X;
label value PEGAP03 H791104X;
label value PEGAU03 H791105X;
label value PEGDE03 H791106X;
label value PEGFE03 H791107X;
label value PEGJA03 H791108X;
label value PEGJL03 H791109X;
label value PEGJU03 H791110X;
label value PEGMA03 H791111X;
label value PEGMY03 H791112X;
label value PEGNO03 H791113X;
label value PEGOC03 H791114X;
label value PEGSE03 H791115X;
label value PENIMP03 H791116X;
label value PENSP03X H791117X;
label value PERSLA42 H791118X;
label value PHMONP03 H791119X;
label value PHMONP31 H791120X;
label value PHMONP42 H791121X;
label value PHNREG42 H791122X;
label value PHYACT53 H791123X;
label value PHYSCL42 H791124X;
label value PLCTYP42 H791125X;
label value PMDLAY42 H791126X;
label value PMDLPR42 H791127X;
label value PMDLRS42 H791128X;
label value PMEDIN31 H791129X;
label value PMEDIN42 H791130X;
label value PMEDIN53 H791131X;
label value PMNCNP03 H791132X;
label value PMNCNP31 H791133X;
label value PMNCNP42 H791134X;
label value PMUNAB42 H791135X;
label value PMUNPR42 H791136X;
label value PMUNRS42 H791137X;
label value PNGAP03 H791138X;
label value PNGAU03 H791139X;
label value PNGDE03 H791140X;
label value PNGFE03 H791141X;
label value PNGJA03 H791142X;
label value PNGJL03 H791143X;
label value PNGJU03 H791144X;
label value PNGMA03 H791145X;
label value PNGMY03 H791146X;
label value PNGNO03 H791147X;
label value PNGOC03 H791148X;
label value PNGSE03 H791149X;
label value POGAP03 H791150X;
label value POGAU03 H791151X;
label value POGDE03 H791152X;
label value POGFE03 H791153X;
label value POGJA03 H791154X;
label value POGJL03 H791155X;
label value POGJU03 H791156X;
label value POGMA03 H791157X;
label value POGMY03 H791158X;
label value POGNO03 H791159X;
label value POGOC03 H791160X;
label value POGSE03 H791161X;
label value POUAP03 H791162X;
label value POUAU03 H791163X;
label value POUDE03 H791164X;
label value POUFE03 H791165X;
label value POUJA03 H791166X;
label value POUJL03 H791167X;
label value POUJU03 H791168X;
label value POUMA03 H791169X;
label value POUMY03 H791170X;
label value POUNO03 H791171X;
label value POUOC03 H791172X;
label value POUSE03 H791173X;
label value POVCAT03 H791174X;
label value PPRWKM42 H791175X;
label value PPRWKT42 H791176X;
label value PRDRNP03 H791177X;
label value PRDRNP31 H791178X;
label value PRDRNP42 H791179X;
label value PREVCOVR H791180X;
label value PREVEN42 H791181X;
label value PRIAP03 H791182X;
label value PRIAU03 H791183X;
label value PRIDE03 H791184X;
label value PRIDK03 H791185X;
label value PRIDK31 H791186X;
label value PRIDK42 H791187X;
label value PRIDK53 H791188X;
label value PRIEU03 H791189X;
label value PRIEU31 H791190X;
label value PRIEU42 H791191X;
label value PRIEU53 H791192X;
label value PRIFE03 H791193X;
label value PRIJA03 H791194X;
label value PRIJL03 H791195X;
label value PRIJU03 H791196X;
label value PRIMA03 H791197X;
label value PRIMY03 H791198X;
label value PRING03 H791199X;
label value PRING31 H791200X;
label value PRING42 H791201X;
label value PRING53 H791202X;
label value PRINO03 H791203X;
label value PRIOC03 H791204X;
label value PRIOG03 H791205X;
label value PRIOG31 H791206X;
label value PRIOG42 H791207X;
label value PRIOG53 H791208X;
label value PRIS03 H791209X;
label value PRIS31 H791210X;
label value PRIS42 H791211X;
label value PRIS53 H791212X;
label value PRISE03 H791213X;
label value PRIV03 H791214X;
label value PRIV31 H791215X;
label value PRIV42 H791216X;
label value PRIV53 H791217X;
label value PRIVAT03 H791218X;
label value PRIVAT31 H791219X;
label value PRIVAT42 H791220X;
label value PRIVAT53 H791221X;
label value PROUT03 H791222X;
label value PROUT31 H791223X;
label value PROUT42 H791224X;
label value PROUT53 H791225X;
label value PROVTY42 H791226X;
label value PROXY03 H791227X;
label value PROXY31 H791228X;
label value PROXY42 H791229X;
label value PROXY53 H791230X;
label value PRSAP03 H791231X;
label value PRSAU03 H791232X;
label value PRSDE03 H791233X;
label value PRSFE03 H791234X;
label value PRSJA03 H791235X;
label value PRSJL03 H791236X;
label value PRSJU03 H791237X;
label value PRSMA03 H791238X;
label value PRSMY03 H791239X;
label value PRSNO03 H791240X;
label value PRSOC03 H791241X;
label value PRSSE03 H791242X;
label value PRVDRL03 H791243X;
label value PRVDRL31 H791244X;
label value PRVDRL42 H791245X;
label value PRVEV03 H791246X;
label value PRVHMO03 H791247X;
label value PRVHMO31 H791248X;
label value PRVHMO42 H791249X;
label value PRVMNC03 H791250X;
label value PRVMNC31 H791251X;
label value PRVMNC42 H791252X;
label value PSA53 H791253X;
label value PSTATS31 H791254X;
label value PSTATS42 H791255X;
label value PSTATS53 H791256X;
label value PUB03X H791257X;
label value PUB31X H791258X;
label value PUB42X H791259X;
label value PUB53X H791260X;
label value PUBAP03X H791261X;
label value PUBAT03X H791262X;
label value PUBAT31X H791263X;
label value PUBAT42X H791264X;
label value PUBAT53X H791265X;
label value PUBAU03X H791266X;
label value PUBDE03X H791267X;
label value PUBFE03X H791268X;
label value PUBIMP03 H791269X;
label value PUBJA03X H791270X;
label value PUBJL03X H791271X;
label value PUBJU03X H791272X;
label value PUBMA03X H791273X;
label value PUBMY03X H791274X;
label value PUBNO03X H791275X;
label value PUBOC03X H791276X;
label value PUBP03X H791277X;
label value PUBSE03X H791278X;
label value RACEAX H791279X;
label value RACEBX H791280X;
label value RACETHNX H791281X;
label value RACEWX H791282X;
label value RACEX H791283X;
label value RCHDIF31 H791284X;
label value RCHDIF53 H791285X;
label value READNW42 H791286X;
label value RECPEP42 H791287X;
label value REFDP03X H791288X;
label value REFFRL42 H791289X;
label value REFIMP03 H791290X;
label value REGION03 H791291X;
label value REGION31 H791292X;
label value REGION42 H791293X;
label value REGION53 H791294X;
label value RESP03 H791295X;
label value RESP31 H791296X;
label value RESP42 H791297X;
label value RESP53 H791298X;
label value RESPCT42 H791299X;
label value RETPLN31 H791300X;
label value RETPLN42 H791301X;
label value RETPLN53 H791302X;
label value RFREL03X H791303X;
label value RFREL31X H791304X;
label value RFREL42X H791305X;
label value RFREL53X H791306X;
label value RNDFLG31 H791307X;
label value RTHLTH31 H791308X;
label value RTHLTH42 H791309X;
label value RTHLTH53 H791310X;
label value RTPLNM42 H791311X;
label value RTPLNT42 H791312X;
label value RUCLAS03 H791313X;
label value RUCLAS31 H791314X;
label value RUCLAS42 H791315X;
label value RUCLAS53 H791316X;
label value RUSIZE03 H791317X;
label value RUSIZE31 H791318X;
label value RUSIZE42 H791319X;
label value RUSIZE53 H791320X;
label value RXEXP03 H791321X;
label value RXMCD03 H791322X;
label value RXMCR03 H791323X;
label value RXOFD03 H791324X;
label value RXOPR03 H791325X;
label value RXOPU03 H791326X;
label value RXOSR03 H791327X;
label value RXPRV03 H791328X;
label value RXSLF03 H791329X;
label value RXSTL03 H791330X;
label value RXTOT03 H791331X;
label value RXTRI03 H791332X;
label value RXVA03 H791333X;
label value RXWCP03 H791334X;
label value SAFEST42 H791335X;
label value SALEP03X H791336X;
label value SALIMP03 H791337X;
label value SAQELIG H791338X;
label value SCHLBH42 H791339X;
label value SCHLIM31 H791340X;
label value SCHLIM53 H791341X;
label value SCHPRO42 H791342X;
label value SCLNBD31 H791343X;
label value SCLNBD42 H791344X;
label value SCLNBD53 H791345X;
label value SEATBE53 H791346X;
label value SEEDIF42 H791347X;
label value SELDSI42 H791348X;
label value SELFCM31 H791349X;
label value SELFCM42 H791350X;
label value SELFCM53 H791351X;
label value SEX H791352X;
label value SFFLAG42 H791353X;
label value SIBPRO42 H791354X;
label value SICEAS42 H791355X;
label value SICPAY31 H791356X;
label value SICPAY42 H791357X;
label value SICPAY53 H791358X;
label value SOCLIM31 H791359X;
label value SOCLIM53 H791360X;
label value SPOUID03 H791361X;
label value SPOUID31 H791362X;
label value SPOUID42 H791363X;
label value SPOUID53 H791364X;
label value SPOUIN03 H791365X;
label value SPOUIN31 H791366X;
label value SPOUIN42 H791367X;
label value SPOUIN53 H791368X;
label value SPRPRO42 H791369X;
label value SRTHRT53 H791370X;
label value SSCIMP03 H791371X;
label value SSECP03X H791372X;
label value SSIDIS03 H791373X;
label value SSIIMP03 H791374X;
label value SSIP03X H791375X;
label value SSNLJB31 H791376X;
label value SSNLJB42 H791377X;
label value SSNLJB53 H791378X;
label value STAAP03 H791379X;
label value STAAU03 H791380X;
label value STADE03 H791381X;
label value STAFE03 H791382X;
label value STAJA03 H791383X;
label value STAJL03 H791384X;
label value STAJU03 H791385X;
label value STAMA03 H791386X;
label value STAMY03 H791387X;
label value STANO03 H791388X;
label value STAOC03 H791389X;
label value STAPR03 H791390X;
label value STAPR31 H791391X;
label value STAPR42 H791392X;
label value STAPR53 H791393X;
label value STASE03 H791394X;
label value STJBDD31 H791395X;
label value STJBDD42 H791396X;
label value STJBDD53 H791397X;
label value STJBMM31 H791398X;
label value STJBMM42 H791399X;
label value STJBMM53 H791400X;
label value STJBYY31 H791401X;
label value STJBYY42 H791402X;
label value STJBYY53 H791403X;
label value STNDIF31 H791404X;
label value STNDIF53 H791405X;
label value STOMCH53 H791406X;
label value STOOL53 H791407X;
label value STPDIF31 H791408X;
label value STPDIF53 H791409X;
label value STPRAT03 H791410X;
label value STPRAT31 H791411X;
label value STPRAT42 H791412X;
label value STPRAT53 H791413X;
label value STRKDX53 H791414X;
label value TAXFRM03 H791415X;
label value TEMPJB31 H791416X;
label value TEMPJB42 H791417X;
label value TEMPJB53 H791418X;
label value THANTB53 H791419X;
label value THANTF53 H791420X;
label value THSWAB53 H791421X;
label value THSWBF53 H791422X;
label value THSYMF53 H791423X;
label value THSYMP53 H791424X;
label value TIMALN42 H791425X;
label value TMTKUS42 H791426X;
label value TOTDED03 H791427X;
label value TOTEXP03 H791428X;
label value TOTMCD03 H791429X;
label value TOTMCR03 H791430X;
label value TOTOFD03 H791431X;
label value TOTOPR03 H791432X;
label value TOTOPU03 H791433X;
label value TOTOSR03 H791434X;
label value TOTPRV03 H791435X;
label value TOTSLF03 H791436X;
label value TOTSTL03 H791437X;
label value TOTTCH03 H791438X;
label value TOTTRI03 H791439X;
label value TOTVA03 H791440X;
label value TOTWCP03 H791441X;
label value TRANS42 H791442X;
label value TRBLE42 H791443X;
label value TREATM42 H791444X;
label value TRIAP03X H791445X;
label value TRIAT03X H791446X;
label value TRIAT31X H791447X;
label value TRIAT42X H791448X;
label value TRIAT53X H791449X;
label value TRIAU03X H791450X;
label value TRICR03X H791451X;
label value TRICR31X H791452X;
label value TRICR42X H791453X;
label value TRICR53X H791454X;
label value TRIDE03X H791455X;
label value TRIEV03 H791456X;
label value TRIEX03X H791457X;
label value TRIEX31X H791458X;
label value TRIEX42X H791459X;
label value TRIFE03X H791460X;
label value TRIJA03X H791461X;
label value TRIJL03X H791462X;
label value TRIJU03X H791463X;
label value TRILI03X H791464X;
label value TRILI42X H791465X;
label value TRIMA03X H791466X;
label value TRIMY03X H791467X;
label value TRINO03X H791468X;
label value TRIOC03X H791469X;
label value TRIPR03X H791470X;
label value TRIPR31X H791471X;
label value TRIPR42X H791472X;
label value TRISE03X H791473X;
label value TRIST03X H791474X;
label value TRIST31X H791475X;
label value TRIST42X H791476X;
label value TRSTP03X H791477X;
label value TRTIMP03 H791478X;
label value TTLP03X H791479X;
label value TYPEPE42 H791480X;
label value UNABLE31 H791481X;
label value UNABLE53 H791482X;
label value UNEIMP03 H791483X;
label value UNEMP03X H791484X;
label value UNHAP42 H791485X;
label value UNINS03 H791486X;
label value UNION31 H791487X;
label value UNION42 H791488X;
label value UNION53 H791489X;
label value USBORN42 H791490X;
label value USCNOT42 H791491X;
label value USLGLV42 H791492X;
label value VETGULF H791493X;
label value VETIMP03 H791494X;
label value VETKOR H791495X;
label value VETOTH H791496X;
label value VETSP03X H791497X;
label value VETVIET H791498X;
label value VETWW H791499X;
label value VISEXP03 H791500X;
label value VISION42 H791501X;
label value VISMCD03 H791502X;
label value VISMCR03 H791503X;
label value VISOFD03 H791504X;
label value VISOPR03 H791505X;
label value VISOPU03 H791506X;
label value VISOSR03 H791507X;
label value VISPRV03 H791508X;
label value VISSLF03 H791509X;
label value VISSTL03 H791510X;
label value VISTCH03 H791511X;
label value VISTRI03 H791512X;
label value VISVA03 H791513X;
label value VISWCP03 H791514X;
label value WAGEP03X H791515X;
label value WAGIMP03 H791516X;
label value WASAFDC H791517X;
label value WASCHAMP H791518X;
label value WASESTB H791519X;
label value WASMCAID H791520X;
label value WASMCARE H791521X;
label value WASOTGOV H791522X;
label value WASOTHER H791523X;
label value WASPRIV H791524X;
label value WASSSI H791525X;
label value WASSTAT1 H791526X;
label value WASSTAT2 H791527X;
label value WASSTAT3 H791528X;
label value WASSTAT4 H791529X;
label value WASVA H791530X;
label value WCMPP03X H791531X;
label value WCPIMP03 H791532X;
label value WHENST53 H791533X;
label value WHITPR42 H791534X;
label value WHNBPR42 H791535X;
label value WHNBST42 H791536X;
label value WHNBWL53 H791537X;
label value WHNDEN42 H791538X;
label value WHNEAT42 H791539X;
label value WHNHEL42 H791540X;
label value WHNHGT42 H791541X;
label value WHNLAP42 H791542X;
label value WHNPHY42 H791543X;
label value WHNSAF42 H791544X;
label value WHNSMK42 H791545X;
label value WHNWGT42 H791546X;
label value WILFIL03 H791547X;
label value WKINBD31 H791548X;
label value WKINBD42 H791549X;
label value WKINBD53 H791550X;
label value WLK3MO31 H791551X;
label value WLK3MO53 H791552X;
label value WLKDIF31 H791553X;
label value WLKDIF53 H791554X;
label value WLKLIM31 H791555X;
label value WLKLIM53 H791556X;
label value WRGLAS42 H791557X;
label value WRHLTH42 H791558X;
label value WRKLIM31 H791559X;
label value WRKLIM53 H791560X;
label value YCHJ3142 H791561X;
label value YCHJ4253 H791562X;
label value YNOINS31 H791563X;
label value YNOINS42 H791564X;
label value YNOINS53 H791565X;
label value YNOUSC42 H791566X;
label value ZIDEXP03 H791567X;
label value ZIDMCD03 H791568X;
label value ZIDMCR03 H791569X;
label value ZIDOFD03 H791570X;
label value ZIDOPR03 H791571X;
label value ZIDOPU03 H791572X;
label value ZIDOSR03 H791573X;
label value ZIDPRV03 H791574X;
label value ZIDSLF03 H791575X;
label value ZIDSTL03 H791576X;
label value ZIDTCH03 H791577X;
label value ZIDTRI03 H791578X;
label value ZIDVA03 H791579X;
label value ZIDWCP03 H791580X;
label value ZIFEXP03 H791581X;
label value ZIFMCD03 H791582X;
label value ZIFMCR03 H791583X;
label value ZIFOFD03 H791584X;
label value ZIFOPR03 H791585X;
label value ZIFOPU03 H791586X;
label value ZIFOSR03 H791587X;
label value ZIFPRV03 H791588X;
label value ZIFSLF03 H791589X;
label value ZIFSTL03 H791590X;
label value ZIFTCH03 H791591X;
label value ZIFTRI03 H791592X;
label value ZIFVA03 H791593X;
label value ZIFWCP03 H791594X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H79.LOG and a data file named H79.DTA.  If these files (H79.DTA and H79.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

